/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.docgen.docs.utils;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class BallerinaDocUtils {
    private static final boolean debugEnabled = "true".equals(System.getProperty("debugDocerina"));
    private static final PrintStream out = System.out;

    private BallerinaDocUtils() {
    }

    public static void packageToZipFile(String sourceDirPath, String zipFilePath) throws IOException {
        Path p = Files.createFile(Path.of(zipFilePath, new String[0]), new FileAttribute[0]);
        Path pp = Path.of(sourceDirPath, new String[0]);
        try (ZipOutputStream zs = new ZipOutputStream(Files.newOutputStream(p, new OpenOption[0]));
             Stream<Path> sourcePaths = Files.walk(pp, new FileVisitOption[0]);){
            sourcePaths.filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                ZipEntry zipEntry = new ZipEntry(pp.relativize((Path)path).toString());
                try {
                    zs.putNextEntry(zipEntry);
                    Files.copy(path, zs);
                    zs.closeEntry();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
    }

    public static byte[] getHash(byte[] contentInBytes, String algorithm) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        return digest.digest(contentInBytes);
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static boolean isDebugEnabled() {
        return debugEnabled;
    }

    public static String getSummary(String description) {
        Pattern pattern = Pattern.compile("^(#+.*\\n+(\\[?!.*\\n+)*)?(.*\\n?)");
        Matcher matcher = pattern.matcher(description);
        if (matcher.find()) {
            return matcher.group(3);
        }
        return "";
    }
}

