/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.docgen.generator.model;

import com.google.gson.annotations.Expose;
import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.MapTypeSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Qualifiable;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.ArrayTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.FunctionTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.IntersectionTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.KeyTypeConstraintNode;
import io.ballerina.compiler.syntax.tree.MapTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.MemberTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.NilTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ObjectTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.OptionalTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ParameterizedTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ParenthesisedTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import io.ballerina.compiler.syntax.tree.RecordRestDescriptorNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SingletonTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.StreamTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.StreamTypeParamsNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TableTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TupleTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypeParameterNode;
import io.ballerina.compiler.syntax.tree.TypeReferenceNode;
import io.ballerina.compiler.syntax.tree.UnionTypeDescriptorNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.ballerinalang.docgen.Generator;
import org.ballerinalang.docgen.docs.utils.BallerinaDocUtils;
import org.ballerinalang.docgen.generator.model.DefaultableVariable;
import org.ballerinalang.docgen.generator.model.FunctionKind;
import org.ballerinalang.docgen.generator.model.Module;
import org.ballerinalang.docgen.generator.model.types.FunctionType;
import org.ballerinalang.docgen.generator.model.types.ObjectType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Type {
    @Expose
    public String orgName;
    @Expose
    public String moduleName;
    @Expose
    public String version;
    @Expose
    public String name;
    @Expose
    public String description;
    @Expose
    public List<String> descriptionSections;
    @Expose
    public String category;
    @Expose
    public boolean isAnonymousUnionType;
    @Expose
    public boolean isInclusion;
    @Expose
    public boolean isArrayType;
    @Expose
    public boolean isNullable;
    @Expose
    public boolean isOptional;
    @Expose
    public boolean isTuple;
    @Expose
    public boolean isIntersectionType;
    @Expose
    public boolean isParenthesisedType;
    @Expose
    public boolean isTypeDesc;
    @Expose
    public boolean isRestParam;
    @Expose
    public boolean isDeprecated;
    @Expose
    public boolean isPublic;
    @Expose
    public boolean generateUserDefinedTypeLink = true;
    @Expose
    public List<Type> memberTypes = new ArrayList<Type>();
    @Expose
    public int arrayDimensions;
    @Expose
    public Type elementType;
    @Expose
    public Type constraint;
    private static final Logger log = LoggerFactory.getLogger(Type.class);
    private static final String CATEGORY_NOT_FOUND = "not_found";
    private static final String CATEGORY_INLINE_RECORD = "inline_record";
    private static final String CATEGORY_INLINE_CLOSED_RECORD = "inline_closed_record";

    public Type() {
    }

    public static Type fromNode(Node node, SemanticModel semanticModel, Module module) {
        Type type = new Type();
        if (node instanceof SimpleNameReferenceNode) {
            Optional symbol;
            block69: {
                SimpleNameReferenceNode simpleNameReferenceNode = (SimpleNameReferenceNode)node;
                type.name = simpleNameReferenceNode.name().text();
                type.category = "reference";
                symbol = Optional.empty();
                try {
                    symbol = semanticModel.symbol(node);
                }
                catch (NullPointerException nullException) {
                    if (!BallerinaDocUtils.isDebugEnabled()) break block69;
                    log.error("Symbol find threw null pointer in : Line range:" + String.valueOf(node.lineRange()));
                }
            }
            if (symbol != null && symbol.isPresent()) {
                TypeReferenceTypeSymbol typeReferenceTypeSymbol;
                Object t = symbol.get();
                if (t instanceof TypeReferenceTypeSymbol && !Type.isPublic((typeReferenceTypeSymbol = (TypeReferenceTypeSymbol)t).definition())) {
                    type = Type.fromSemanticSymbol((Symbol)symbol.get(), Optional.empty(), null, false, module);
                } else {
                    Type.resolveSymbolMetaData(type, (Symbol)symbol.get(), module);
                }
            } else {
                type.generateUserDefinedTypeLink = false;
            }
        } else if (node instanceof QualifiedNameReferenceNode) {
            Optional symbol;
            block70: {
                QualifiedNameReferenceNode qualifiedNameReferenceNode = (QualifiedNameReferenceNode)node;
                type.moduleName = qualifiedNameReferenceNode.modulePrefix().text();
                type.category = "reference";
                type.name = qualifiedNameReferenceNode.identifier().text();
                symbol = Optional.empty();
                try {
                    symbol = semanticModel.symbol(node);
                }
                catch (NullPointerException nullException) {
                    if (!BallerinaDocUtils.isDebugEnabled()) break block70;
                    log.error("Symbol find threw null pointer in : Line range:" + String.valueOf(node.lineRange()));
                }
            }
            if (symbol != null && symbol.isPresent()) {
                TypeReferenceTypeSymbol typeReferenceTypeSymbol;
                Object t = symbol.get();
                if (t instanceof TypeReferenceTypeSymbol && !Type.isPublic((typeReferenceTypeSymbol = (TypeReferenceTypeSymbol)t).definition())) {
                    type = Type.fromSemanticSymbol((Symbol)symbol.get(), Optional.empty(), null, false, module);
                } else {
                    Type.resolveSymbolMetaData(type, (Symbol)symbol.get(), module);
                }
            } else {
                type.generateUserDefinedTypeLink = false;
            }
        } else if (node instanceof KeyTypeConstraintNode) {
            TypeParameterNode typeParameterNode2 = (TypeParameterNode)((KeyTypeConstraintNode)node).typeParameterNode();
            type.name = "key";
            type.category = "key";
            type.constraint = Type.fromNode((Node)typeParameterNode2.typeNode(), semanticModel, module);
        } else if (node instanceof TypeReferenceNode) {
            Optional symbol;
            block71: {
                symbol = Optional.empty();
                try {
                    symbol = semanticModel.symbol(node);
                }
                catch (NullPointerException nullException) {
                    if (!BallerinaDocUtils.isDebugEnabled()) break block71;
                    log.error("Symbol find threw null pointer in : Line range:" + String.valueOf(node.lineRange()));
                }
            }
            if (symbol != null && symbol.isPresent()) {
                type = Type.fromSemanticSymbol((Symbol)symbol.get(), Optional.empty(), null, true, module);
            }
        } else if (node instanceof BuiltinSimpleNameReferenceNode) {
            BuiltinSimpleNameReferenceNode builtinSimpleNameReferenceNode = (BuiltinSimpleNameReferenceNode)node;
            type.name = builtinSimpleNameReferenceNode.name().text();
            type.category = "builtin";
        } else if (node instanceof NilTypeDescriptorNode) {
            type.name = node.toString();
            type.category = "builtin";
        } else if (node instanceof ArrayTypeDescriptorNode) {
            ArrayTypeDescriptorNode arrayTypeDescriptorNode = (ArrayTypeDescriptorNode)node;
            type.isArrayType = true;
            type.arrayDimensions = arrayTypeDescriptorNode.dimensions().size();
            type.elementType = Type.fromNode((Node)arrayTypeDescriptorNode.memberTypeDesc(), semanticModel, module);
        } else if (node instanceof OptionalTypeDescriptorNode) {
            OptionalTypeDescriptorNode optionalTypeDescriptorNode = (OptionalTypeDescriptorNode)node;
            type = Type.fromNode(optionalTypeDescriptorNode.typeDescriptor(), semanticModel, module);
            type.isNullable = true;
        } else if (node instanceof UnionTypeDescriptorNode) {
            type.isAnonymousUnionType = true;
            Type.addUnionMemberTypes(node, semanticModel, type.memberTypes, module);
        } else if (node instanceof IntersectionTypeDescriptorNode) {
            type.isIntersectionType = true;
            Type.addIntersectionMemberTypes(node, semanticModel, type.memberTypes, module);
        } else if (node instanceof RecordTypeDescriptorNode) {
            RecordTypeDescriptorNode recordNode = (RecordTypeDescriptorNode)node;
            ArrayList<Type> fields = new ArrayList<Type>();
            recordNode.fields().forEach(node1 -> {
                if (node1 instanceof RecordFieldWithDefaultValueNode) {
                    RecordFieldWithDefaultValueNode recordField = (RecordFieldWithDefaultValueNode)node1;
                    Type defField = new Type();
                    defField.name = recordField.fieldName().text();
                    defField.elementType = Type.fromNode(recordField.typeName(), semanticModel, module);
                    fields.add(defField);
                } else if (node1 instanceof RecordFieldNode) {
                    RecordFieldNode recordField = (RecordFieldNode)node1;
                    Type recField = new Type();
                    recField.name = recordField.fieldName().text();
                    recField.elementType = Type.fromNode(recordField.typeName(), semanticModel, module);
                    fields.add(recField);
                }
            });
            if (recordNode.recordRestDescriptor().isPresent()) {
                Type restField = new Type();
                restField.elementType = Type.fromNode((Node)recordNode.recordRestDescriptor().get(), semanticModel, module);
                fields.add(restField);
            }
            type.category = recordNode.bodyStartDelimiter().kind().equals((Object)SyntaxKind.OPEN_BRACE_PIPE_TOKEN) && recordNode.recordRestDescriptor().isEmpty() ? CATEGORY_INLINE_CLOSED_RECORD : CATEGORY_INLINE_RECORD;
            type.memberTypes = fields;
        } else if (node instanceof StreamTypeDescriptorNode) {
            StreamTypeDescriptorNode streamNode = (StreamTypeDescriptorNode)node;
            StreamTypeParamsNode streamParams = streamNode.streamTypeParamsNode().isPresent() ? (StreamTypeParamsNode)streamNode.streamTypeParamsNode().get() : null;
            type.name = streamNode.streamKeywordToken().text();
            type.category = "stream";
            if (streamParams != null) {
                type.memberTypes.add(Type.fromNode(streamParams.leftTypeDescNode(), semanticModel, module));
                if (streamParams.rightTypeDescNode().isPresent()) {
                    type.memberTypes.add(Type.fromNode((Node)streamParams.rightTypeDescNode().get(), semanticModel, module));
                }
            }
        } else if (node instanceof FunctionTypeDescriptorNode) {
            FunctionTypeDescriptorNode functionDescNode = (FunctionTypeDescriptorNode)node;
            FunctionType functionType = new FunctionType();
            functionType.isLambda = true;
            functionType.isIsolated = Generator.containsToken((NodeList<Token>)functionDescNode.qualifierList(), SyntaxKind.ISOLATED_KEYWORD);
            if (functionDescNode.functionSignature().isPresent()) {
                FunctionSignatureNode functionSignature = (FunctionSignatureNode)functionDescNode.functionSignature().get();
                List<DefaultableVariable> variables = Generator.getDefaultableVariableList(functionSignature.parameters(), Optional.empty(), semanticModel, module);
                functionType.paramTypes.addAll(variables.stream().map(defaultableVariable -> defaultableVariable.type).toList());
                if (functionSignature.returnTypeDesc().isPresent()) {
                    ReturnTypeDescriptorNode returnType = (ReturnTypeDescriptorNode)functionSignature.returnTypeDesc().get();
                    functionType.returnType = Type.fromNode(returnType.type(), semanticModel, module);
                }
            }
            type = functionType;
        } else if (node instanceof MapTypeDescriptorNode) {
            MapTypeDescriptorNode mapTypeDesc = (MapTypeDescriptorNode)node;
            type.name = "map";
            type.category = "map";
            type.constraint = Type.fromNode((Node)mapTypeDesc.mapTypeParamsNode().typeNode(), semanticModel, module);
        } else if (node instanceof TableTypeDescriptorNode) {
            TableTypeDescriptorNode tableTypeDesc = (TableTypeDescriptorNode)node;
            type.name = "table";
            type.category = "table";
            type.constraint = Type.fromNode((Node)((TypeParameterNode)tableTypeDesc.rowTypeParameterNode()).typeNode(), semanticModel, module);
        } else if (node instanceof ParameterizedTypeDescriptorNode) {
            ParameterizedTypeDescriptorNode parameterizedTypeNode = (ParameterizedTypeDescriptorNode)node;
            SyntaxKind typeKind = node.kind();
            if (typeKind == SyntaxKind.ERROR_TYPE_DESC || typeKind == SyntaxKind.XML_TYPE_DESC) {
                type.name = parameterizedTypeNode.keywordToken().text();
                type.category = "builtin";
            } else if (typeKind == SyntaxKind.FUTURE_TYPE_DESC) {
                type.category = "future";
                type.elementType = parameterizedTypeNode.typeParamNode().map(typeParameterNode -> Type.fromNode((Node)typeParameterNode.typeNode(), semanticModel, module)).orElse(null);
            } else if (typeKind == SyntaxKind.TYPEDESC_TYPE_DESC) {
                type.elementType = parameterizedTypeNode.typeParamNode().map(typeParameterNode -> Type.fromNode((Node)typeParameterNode.typeNode(), semanticModel, module)).orElse(null);
                type.isTypeDesc = true;
            }
        } else if (node instanceof ObjectTypeDescriptorNode) {
            ObjectTypeDescriptorNode objectType = (ObjectTypeDescriptorNode)node;
            type.name = objectType.toString();
            type.category = "other";
            type.generateUserDefinedTypeLink = false;
        } else if (node instanceof SingletonTypeDescriptorNode) {
            SingletonTypeDescriptorNode singletonTypeDesc = (SingletonTypeDescriptorNode)node;
            type.name = singletonTypeDesc.simpleContExprNode().toString();
            type.category = "other";
            type.generateUserDefinedTypeLink = false;
        } else if (node instanceof ParenthesisedTypeDescriptorNode) {
            ParenthesisedTypeDescriptorNode parenthesisedNode = (ParenthesisedTypeDescriptorNode)node;
            type.elementType = Type.fromNode((Node)parenthesisedNode.typedesc(), semanticModel, module);
            type.isParenthesisedType = true;
        } else if (node instanceof TupleTypeDescriptorNode) {
            TupleTypeDescriptorNode typeDescriptor = (TupleTypeDescriptorNode)node;
            type.memberTypes.addAll(typeDescriptor.memberTypeDesc().stream().map(memberType -> Type.fromNode(memberType, semanticModel, module)).toList());
            type.isTuple = true;
        } else if (node instanceof MemberTypeDescriptorNode) {
            MemberTypeDescriptorNode member = (MemberTypeDescriptorNode)node;
            type = Type.fromNode((Node)member.typeDescriptor(), semanticModel, module);
        } else if (node instanceof RecordRestDescriptorNode) {
            RecordRestDescriptorNode recordRestDescriptorNode = (RecordRestDescriptorNode)node;
            type.isRestParam = true;
            type.elementType = Type.fromNode(recordRestDescriptorNode.typeName(), semanticModel, module);
        } else {
            type.name = node.toSourceCode();
            type.generateUserDefinedTypeLink = false;
            type.category = "UNKNOWN";
        }
        return type;
    }

    public static Type fromSemanticSymbol(Symbol symbol, Optional<Documentation> documentation, TypeReferenceTypeSymbol parentTypeRefSymbol, boolean isTypeInclusion, Module module) {
        Type type = new Type();
        if (symbol instanceof TypeReferenceTypeSymbol) {
            TypeReferenceTypeSymbol typeReferenceTypeSymbol = (TypeReferenceTypeSymbol)symbol;
            Symbol typeDefinition = typeReferenceTypeSymbol.definition();
            if (!(typeReferenceTypeSymbol.equals((Object)parentTypeRefSymbol) || Type.isPublic(typeReferenceTypeSymbol.definition()) && !isTypeInclusion)) {
                if (typeDefinition instanceof TypeDefinitionSymbol) {
                    TypeDefinitionSymbol typeDefinitionSymbol = (TypeDefinitionSymbol)typeDefinition;
                    type = Type.fromSemanticSymbol((Symbol)typeReferenceTypeSymbol.typeDescriptor(), typeDefinitionSymbol.documentation(), typeReferenceTypeSymbol, false, module);
                } else if (typeDefinition instanceof ClassSymbol) {
                    ClassSymbol classSymbol = (ClassSymbol)typeDefinition;
                    type = Type.fromSemanticSymbol((Symbol)typeReferenceTypeSymbol.typeDescriptor(), classSymbol.documentation(), typeReferenceTypeSymbol, false, module);
                }
            }
            if (Type.isPublic(typeReferenceTypeSymbol.definition())) {
                Type.resolveSymbolMetaData(type, symbol, module);
                type.isPublic = true;
            }
            type.name = typeReferenceTypeSymbol.getName().isPresent() ? (String)typeReferenceTypeSymbol.getName().get() : null;
        } else if (symbol instanceof RecordTypeSymbol) {
            RecordTypeSymbol recordTypeSymbol = (RecordTypeSymbol)symbol;
            Type recordType = type;
            recordType.name = recordTypeSymbol.getName().isPresent() ? (String)recordTypeSymbol.getName().get() : "";
            recordType.description = documentation.isPresent() && documentation.get().description().isPresent() ? (String)documentation.get().description().get() : "";
            recordTypeSymbol.fieldDescriptors().forEach((name, field) -> {
                Type recField = new Type();
                recField.name = name;
                recField.description = documentation.isPresent() ? (String)((Documentation)documentation.get()).parameterMap().get(name) : "";
                recField.elementType = Type.fromSemanticSymbol((Symbol)field.typeDescriptor(), documentation, parentTypeRefSymbol, isTypeInclusion, module);
                recordType.memberTypes.add(recField);
            });
            recordTypeSymbol.restTypeDescriptor().ifPresent(typeSymbol -> {
                Type restField = new Type();
                restField.isRestParam = true;
                restField.elementType = Type.fromSemanticSymbol((Symbol)typeSymbol, documentation, parentTypeRefSymbol, isTypeInclusion, module);
                restField.description = "Rest field";
                Type recField = new Type();
                recField.elementType = restField;
                recordType.memberTypes.add(recField);
            });
            recordType.category = CATEGORY_INLINE_RECORD;
        } else if (symbol instanceof ObjectTypeSymbol) {
            ObjectTypeSymbol objectTypeSymbol = (ObjectTypeSymbol)symbol;
            ObjectType objType = new ObjectType();
            objType.name = objectTypeSymbol.getName().isPresent() ? (String)objectTypeSymbol.getName().get() : "";
            objectTypeSymbol.fieldDescriptors().forEach((name, field) -> {
                if (field.qualifiers().contains(Qualifier.PUBLIC)) {
                    Type objField = new Type();
                    objField.name = name;
                    objField.description = documentation.isPresent() ? (String)((Documentation)documentation.get()).parameterMap().get(name) : "";
                    objField.elementType = Type.fromSemanticSymbol((Symbol)field.typeDescriptor(), documentation, parentTypeRefSymbol, isTypeInclusion, module);
                    objType.memberTypes.add(objField);
                }
            });
            ArrayList<FunctionType> functionTypes = new ArrayList<FunctionType>();
            objectTypeSymbol.methods().forEach((methodName, methodSymbol) -> {
                FunctionType functionType = new FunctionType();
                functionType.resourcePath = "";
                if (methodSymbol.qualifiers().contains(Qualifier.RESOURCE)) {
                    functionType.name = "";
                    functionType.accessor = methodName;
                } else {
                    functionType.name = methodName;
                    functionType.accessor = "";
                }
                functionType.description = methodSymbol.documentation().isPresent() && ((Documentation)methodSymbol.documentation().get()).description().isPresent() ? (String)((Documentation)methodSymbol.documentation().get()).description().get() : null;
                functionType.category = "included_function";
                functionType.isIsolated = methodSymbol.qualifiers().contains(Qualifier.ISOLATED);
                FunctionKind functionKind = methodSymbol.qualifiers().contains(Qualifier.REMOTE) ? FunctionKind.REMOTE : (methodSymbol.qualifiers().contains(Qualifier.RESOURCE) ? FunctionKind.RESOURCE : FunctionKind.OTHER);
                functionType.functionKind = functionKind;
                functionType.isExtern = methodSymbol.external();
                methodSymbol.typeDescriptor().params().ifPresent(parameterSymbols -> {
                    parameterSymbols.forEach(parameterSymbol -> {
                        Type paramType = new Type();
                        paramType.name = parameterSymbol.getName().isPresent() ? (String)parameterSymbol.getName().get() : "";
                        paramType.elementType = Type.fromSemanticSymbol((Symbol)parameterSymbol.typeDescriptor(), methodSymbol.documentation(), parentTypeRefSymbol, isTypeInclusion, module);
                        paramType.isDeprecated = parameterSymbol.annotations().stream().anyMatch(annotationSymbol -> ((String)annotationSymbol.getName().get()).equals("deprecated"));
                        functionType.paramTypes.add(paramType);
                    });
                    if (methodSymbol.typeDescriptor().restParam().isPresent()) {
                        ParameterSymbol restParam = (ParameterSymbol)methodSymbol.typeDescriptor().restParam().get();
                        Type restType = Type.fromSemanticSymbol((Symbol)restParam, methodSymbol.documentation(), parentTypeRefSymbol, isTypeInclusion, module);
                        restType.isDeprecated = restParam.annotations().stream().anyMatch(annotationSymbol -> ((String)annotationSymbol.getName().get()).equals("deprecated"));
                        functionType.paramTypes.add(restType);
                    }
                    if (methodSymbol.typeDescriptor().returnTypeDescriptor().isPresent()) {
                        Type returnType;
                        functionType.returnType = returnType = Type.fromSemanticSymbol((Symbol)methodSymbol.typeDescriptor().returnTypeDescriptor().get(), methodSymbol.documentation(), parentTypeRefSymbol, isTypeInclusion, module);
                    }
                });
                functionTypes.add(functionType);
            });
            objType.functionTypes = functionTypes;
            type = objType;
        } else if (symbol instanceof MapTypeSymbol) {
            MapTypeSymbol mapTypeSymbol = (MapTypeSymbol)symbol;
            type.name = "map";
            type.category = "map";
            type.constraint = Type.fromSemanticSymbol((Symbol)mapTypeSymbol.typeParam(), documentation, parentTypeRefSymbol, isTypeInclusion, module);
        } else if (symbol instanceof UnionTypeSymbol) {
            UnionTypeSymbol unionSymbol = (UnionTypeSymbol)symbol;
            type.isAnonymousUnionType = true;
            ArrayList<Type> unionMembers = new ArrayList<Type>();
            unionSymbol.memberTypeDescriptors().forEach(typeSymbol -> unionMembers.add(Type.fromSemanticSymbol((Symbol)typeSymbol, documentation, parentTypeRefSymbol, isTypeInclusion, module)));
            type.memberTypes = unionMembers;
        } else if (symbol instanceof IntersectionTypeSymbol) {
            IntersectionTypeSymbol intersectionSymbol = (IntersectionTypeSymbol)symbol;
            type.isIntersectionType = true;
            ArrayList<Type> intersectionMembers = new ArrayList<Type>();
            intersectionSymbol.memberTypeDescriptors().forEach(typeSymbol -> intersectionMembers.add(Type.fromSemanticSymbol((Symbol)typeSymbol, documentation, parentTypeRefSymbol, isTypeInclusion, module)));
            type.memberTypes = intersectionMembers;
        } else if (symbol instanceof ArrayTypeSymbol) {
            ArrayTypeSymbol arrayTypeSymbol = (ArrayTypeSymbol)symbol;
            type.isArrayType = true;
            type.arrayDimensions = 1;
            type.elementType = Type.fromSemanticSymbol((Symbol)arrayTypeSymbol.memberTypeDescriptor(), documentation, parentTypeRefSymbol, isTypeInclusion, module);
        } else if (symbol instanceof TypeSymbol) {
            TypeSymbol typeSymbol2 = (TypeSymbol)symbol;
            type.category = "builtin";
            type.name = typeSymbol2.signature();
        }
        return type;
    }

    public static void addUnionMemberTypes(Node node, SemanticModel semanticModel, List<Type> members, Module module) {
        if (node instanceof UnionTypeDescriptorNode) {
            UnionTypeDescriptorNode unionTypeNode = (UnionTypeDescriptorNode)node;
            Type.addUnionMemberTypes((Node)unionTypeNode.leftTypeDesc(), semanticModel, members, module);
            Type.addUnionMemberTypes((Node)unionTypeNode.rightTypeDesc(), semanticModel, members, module);
            return;
        }
        members.add(Type.fromNode(node, semanticModel, module));
    }

    public static void addIntersectionMemberTypes(Node node, SemanticModel semanticModel, List<Type> members, Module module) {
        if (node instanceof IntersectionTypeDescriptorNode) {
            IntersectionTypeDescriptorNode intersectionTypeNode = (IntersectionTypeDescriptorNode)node;
            Type.addIntersectionMemberTypes(intersectionTypeNode.leftTypeDesc(), semanticModel, members, module);
            Type.addIntersectionMemberTypes(intersectionTypeNode.rightTypeDesc(), semanticModel, members, module);
            return;
        }
        members.add(Type.fromNode(node, semanticModel, module));
    }

    public static void resolveSymbolMetaData(Type type, Symbol symbol, Module module) {
        TypeDefinitionSymbol typeDefSymbol;
        ModuleID moduleID;
        ModuleID moduleID2 = moduleID = symbol.getModule().isPresent() ? ((ModuleSymbol)symbol.getModule().get()).id() : null;
        if (moduleID != null) {
            type.moduleName = moduleID.moduleName();
            type.orgName = moduleID.orgName();
            type.version = moduleID.version();
        } else {
            type.moduleName = "UNK_MOD";
            type.orgName = "UNK_ORG";
            type.version = "UNK_VER";
        }
        if (!(type.orgName.equals("UNK_ORG") || Objects.equals(type.moduleName, module.id) && Objects.equals(type.orgName, module.orgName))) {
            type.category = "libs";
        } else if (symbol instanceof TypeReferenceTypeSymbol) {
            TypeReferenceTypeSymbol typeSymbol = (TypeReferenceTypeSymbol)symbol;
            if (typeSymbol.definition().kind().equals((Object)SymbolKind.ENUM)) {
                type.category = "enums";
            } else if (typeSymbol.typeDescriptor() != null) {
                type.category = Type.getTypeCategory(typeSymbol.typeDescriptor());
            }
        } else if (symbol instanceof ConstantSymbol) {
            type.category = "constants";
        } else if (symbol instanceof VariableSymbol) {
            VariableSymbol variableSymbol = (VariableSymbol)symbol;
            if (variableSymbol.typeDescriptor() != null) {
                type.category = Type.getTypeCategory(variableSymbol.typeDescriptor());
            }
        } else if (symbol instanceof TypeDefinitionSymbol && (typeDefSymbol = (TypeDefinitionSymbol)symbol).typeDescriptor() != null) {
            type.category = Type.getTypeCategory(typeDefSymbol.typeDescriptor());
        }
        if (type.category.equals(CATEGORY_NOT_FOUND)) {
            type.generateUserDefinedTypeLink = false;
        }
    }

    public static String getTypeCategory(TypeSymbol typeDescriptor) {
        if (typeDescriptor.kind().equals((Object)SymbolKind.TYPE) && typeDescriptor.typeKind() != null) {
            if (typeDescriptor.typeKind().equals((Object)TypeDescKind.RECORD)) {
                return "records";
            }
            if (typeDescriptor.typeKind().equals((Object)TypeDescKind.OBJECT)) {
                return "objectTypes";
            }
            if (typeDescriptor.typeKind().equals((Object)TypeDescKind.ERROR)) {
                return "errors";
            }
            if (typeDescriptor.typeKind().equals((Object)TypeDescKind.UNION)) {
                if (((UnionTypeSymbol)typeDescriptor).memberTypeDescriptors().stream().allMatch(typeSymbol -> {
                    if (typeSymbol.typeKind().equals((Object)TypeDescKind.TYPE_REFERENCE)) {
                        return Type.getTypeCategory(typeSymbol).equals("errors");
                    }
                    return typeSymbol.typeKind().equals((Object)TypeDescKind.ERROR);
                })) {
                    return "errors";
                }
                return "types";
            }
            if (typeDescriptor.typeKind().equals((Object)TypeDescKind.TYPE_REFERENCE)) {
                return Type.getTypeCategory(((TypeReferenceTypeSymbol)typeDescriptor).typeDescriptor());
            }
            if (typeDescriptor.typeKind().equals((Object)TypeDescKind.DECIMAL) || typeDescriptor.typeKind().isXMLType() || typeDescriptor.typeKind().equals((Object)TypeDescKind.FUNCTION) || typeDescriptor.typeKind().isStringType() || typeDescriptor.typeKind().isIntegerType()) {
                return "types";
            }
            if (typeDescriptor.typeKind().equals((Object)TypeDescKind.INTERSECTION)) {
                return Type.getIntersectionTypeCategory((IntersectionTypeSymbol)typeDescriptor);
            }
            if (typeDescriptor.typeKind().equals((Object)TypeDescKind.ANY)) {
                return "types";
            }
            return "types";
        }
        if (typeDescriptor.kind().equals((Object)SymbolKind.CLASS)) {
            Qualifiable classSymbol = (Qualifiable)typeDescriptor;
            if (classSymbol.qualifiers().contains(Qualifier.CLIENT)) {
                return "clients";
            }
            if (classSymbol.qualifiers().contains(Qualifier.LISTENER) || "Listener".equals(typeDescriptor.getName().orElse(null))) {
                return "listeners";
            }
            return "classes";
        }
        return CATEGORY_NOT_FOUND;
    }

    public static String getIntersectionTypeCategory(IntersectionTypeSymbol intersectionTypeSymbol) {
        for (TypeSymbol memberType : intersectionTypeSymbol.memberTypeDescriptors()) {
            String category = Type.getTypeCategory(memberType);
            if (category.equals(CATEGORY_NOT_FOUND)) continue;
            return category;
        }
        return "types";
    }

    public Type(String name) {
        this.name = name;
        this.category = "builtin";
    }

    public Type(String name, String description, List<String> descriptionSections, boolean isDeprecated) {
        this.name = name;
        this.description = description;
        this.descriptionSections = descriptionSections;
        this.isDeprecated = isDeprecated;
    }

    private static boolean isPublic(Symbol typeDefinition) {
        return typeDefinition instanceof TypeDefinitionSymbol && ((TypeDefinitionSymbol)typeDefinition).qualifiers().contains(Qualifier.PUBLIC) || typeDefinition instanceof ClassSymbol && ((ClassSymbol)typeDefinition).qualifiers().contains(Qualifier.PUBLIC);
    }
}

