/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.ldap;

import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncSearchResultListener;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import io.ballerina.lib.ldap.Client;
import io.ballerina.lib.ldap.Utils;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.ValueUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.CompletableFuture;

public class CustomSearchEntryListener
implements AsyncSearchResultListener {
    private static final long serialVersionUID = 1L;
    private transient CompletableFuture<Object> future;
    private transient BArray array;
    private transient BError error;
    private transient BTypedesc typeDesc;
    private final String dN;

    public CustomSearchEntryListener(CompletableFuture<Object> future, BTypedesc typeDesc, String dN) {
        this.future = future;
        this.array = ValueCreator.createArrayValue((ArrayType)((ArrayType)typeDesc.getDescribingType()));
        this.dN = dN;
        this.typeDesc = typeDesc;
        this.error = null;
    }

    public void searchResultReceived(AsyncRequestID requestID, SearchResult searchResult) {
        if (this.error != null) {
            this.future.complete(this.error);
            return;
        }
        if (!searchResult.getResultCode().equals((Object)ResultCode.SUCCESS)) {
            LDAPException ldapException = new LDAPException((LDAPResult)searchResult);
            this.future.complete(Utils.createError(ldapException.getMessage(), ldapException));
            return;
        }
        if (this.array.isEmpty()) {
            String errorMessage = String.format("Entry is not found for DN: '%s'", this.dN);
            LDAPException ldapException = new LDAPException(ResultCode.OTHER, errorMessage);
            this.future.complete(Utils.createError(ldapException.getMessage(), ldapException));
            return;
        }
        this.future.complete(this.array);
    }

    public void searchEntryReturned(SearchResultEntry searchEntry) {
        try {
            BMap entry = ValueCreator.createMapValue();
            for (Attribute attribute : searchEntry.getAttributes()) {
                Client.processAttribute(attribute, (BMap<BString, Object>)entry);
            }
            ArrayType arrayType = (ArrayType)this.typeDesc.getDescribingType();
            this.array.append(ValueUtils.convert((Object)entry, (Type)arrayType.getElementType()));
        }
        catch (Exception e) {
            this.error = Utils.createError(e.getMessage(), e);
        }
    }

    public void searchReferenceReturned(SearchResultReference searchReference) {
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.array = ValueCreator.createArrayValue((ArrayType)((ArrayType)this.typeDesc.getDescribingType()));
        this.error = null;
    }

    public void setFuture(CompletableFuture<Object> future) {
        this.future = future;
    }

    public void setTypeDesc(BTypedesc typeDesc) {
        this.typeDesc = typeDesc;
        this.array = ValueCreator.createArrayValue((ArrayType)((ArrayType)typeDesc.getDescribingType()));
    }
}

