/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket;

import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketConnectorException;
import java.util.List;

public class HeaderParam {
    private int typeTag;
    private boolean nilable;
    private Type type;
    private String headerName;

    public void init(Type type) throws WebSocketConnectorException {
        this.type = type;
        this.typeTag = type.getTag();
        this.validateHeaderParamType();
    }

    private void validateHeaderParamType() throws WebSocketConnectorException {
        if (this.type instanceof UnionType) {
            List memberTypes = ((UnionType)this.type).getMemberTypes();
            int size = memberTypes.size();
            if (size > 2 || !this.type.isNilable()) {
                throw new WebSocketConnectorException("Invalid header param type '" + this.type.getName() + "': a string or an array of a string can only be union with '()'.Eg: string|() or string[]|()");
            }
            this.nilable = true;
            for (Type type : memberTypes) {
                if (type.getTag() == 14) continue;
                this.validateBasicType(type);
                break;
            }
        } else {
            this.validateBasicType(this.type);
        }
    }

    private void validateBasicType(Type type) throws WebSocketConnectorException {
        if (this.isValidBasicType(type.getTag()) || type.getTag() == 32 && this.isValidBasicType(((ArrayType)type).getElementType().getTag())) {
            this.typeTag = type.getTag();
            return;
        }
        throw new WebSocketConnectorException("Incompatible header parameter type: '" + type.getName() + "'. expected: string or string[]");
    }

    private boolean isValidBasicType(int typeTag) {
        return typeTag == 5;
    }

    public int getTypeTag() {
        return this.typeTag;
    }

    public boolean isNilable() {
        return this.nilable;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    void setHeaderName(String headerName) {
        this.headerName = headerName;
    }
}

