/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket;

import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketConnectorException;

public final class QueryParam {
    private final int typeTag;
    private final boolean nilable;
    private final Type type;

    QueryParam(Type type, boolean nilable) throws WebSocketConnectorException {
        this.type = type;
        this.typeTag = type.getTag();
        this.nilable = nilable;
        this.validateQueryParamType();
    }

    private void validateQueryParamType() throws WebSocketConnectorException {
        if (this.isValidBasicType(this.typeTag) || this.typeTag == 32 && this.isValidBasicType(((ArrayType)this.type).getElementType().getTag())) {
            return;
        }
        throw new WebSocketConnectorException("Incompatible query parameter type: '" + this.type.getName() + "'");
    }

    private boolean isValidBasicType(int typeTag) {
        return typeTag == 5 || typeTag == 1 || typeTag == 3 || typeTag == 6 || typeTag == 4;
    }

    public boolean isNilable() {
        return this.nilable;
    }

    public Type getType() {
        return this.type;
    }
}

