/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket;

import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WebSocketService {
    protected final BObject service;
    protected Runtime runtime;
    private final Map<String, MethodType> resourcesMap = new ConcurrentHashMap<String, MethodType>();
    private Map<String, Object> wsServices = new ConcurrentHashMap<String, Object>();

    public WebSocketService(Runtime runtime) {
        this.runtime = runtime;
        this.service = null;
    }

    public WebSocketService(BObject service, Runtime runtime) {
        this.runtime = runtime;
        this.service = service;
        this.populateResourcesMap(service);
    }

    private void populateResourcesMap(BObject service) {
        ObjectType serviceType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)service));
        for (MethodType resource : serviceType.getMethods()) {
            this.resourcesMap.put(resource.getName(), resource);
        }
    }

    public MethodType getResourceByName(String resourceName) {
        return this.resourcesMap.get(resourceName);
    }

    public BObject getBalService() {
        return this.service;
    }

    public Runtime getRuntime() {
        return this.runtime;
    }

    public void addWsService(String channelId, Object dispatchingService) {
        this.wsServices.put(channelId, dispatchingService);
    }

    public Object getWsService(String key) {
        return this.wsServices.get(key);
    }
}

