/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket.client.listener;

import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.transport.contract.websocket.ClientHandshakeListener;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketConnection;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.ballerina.stdlib.http.transport.message.HttpCarbonResponse;
import io.ballerina.stdlib.websocket.WebSocketConstants;
import io.ballerina.stdlib.websocket.WebSocketService;
import io.ballerina.stdlib.websocket.WebSocketUtil;
import io.ballerina.stdlib.websocket.actions.websocketconnector.WebSocketConnector;
import io.ballerina.stdlib.websocket.client.RetryContext;
import io.ballerina.stdlib.websocket.client.listener.SyncClientConnectorListener;
import io.ballerina.stdlib.websocket.observability.WebSocketObservabilityUtil;
import io.ballerina.stdlib.websocket.server.WebSocketConnectionInfo;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryWriteTextHandshakeListener
implements ClientHandshakeListener {
    private final String message;
    private final BObject clientEndpoint;
    private final SyncClientConnectorListener connectorListener;
    private WebSocketConnectionInfo connectionInfo;
    private final CompletableFuture<Object> balFuture;
    private AtomicBoolean textCallbackCompleted;
    private static final Logger logger = LoggerFactory.getLogger(RetryWriteTextHandshakeListener.class);

    public RetryWriteTextHandshakeListener(String message, BObject clientEndpoint, SyncClientConnectorListener connectorListener, CompletableFuture<Object> balFuture, AtomicBoolean textCallbackCompleted) {
        this.message = message;
        this.clientEndpoint = clientEndpoint;
        this.connectorListener = connectorListener;
        this.balFuture = balFuture;
        this.textCallbackCompleted = textCallbackCompleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSuccess(WebSocketConnection webSocketConnection, HttpCarbonResponse httpCarbonResponse) {
        this.clientEndpoint.addNativeData("response", (Object)HttpUtil.createResponseStruct((HttpCarbonMessage)httpCarbonResponse));
        WebSocketUtil.populatWebSocketEndpoint(webSocketConnection, this.clientEndpoint);
        this.setWebSocketOpenConnectionInfo(webSocketConnection, this.clientEndpoint, (WebSocketService)this.clientEndpoint.getNativeData("callbackService"));
        this.connectorListener.setConnectionInfo(this.connectionInfo);
        webSocketConnection.removeReadIdleStateHandler();
        WebSocketObservabilityUtil.observeConnection(this.connectionInfo);
        WebSocketConnectionInfo connectionInfo = (WebSocketConnectionInfo)this.clientEndpoint.getNativeData("NATIVE_DATA_WEBSOCKET_CONNECTION_INFO");
        PromiseCombiner promiseCombiner = new PromiseCombiner((EventExecutor)ImmediateEventExecutor.INSTANCE);
        ByteBuf byteBuf = null;
        ByteBuf lastSlice = null;
        try {
            int index;
            WebSocketConnector.setWriteTimeoutHandler(this.clientEndpoint, this.balFuture, this.textCallbackCompleted, connectionInfo);
            byteBuf = WebSocketConnector.fromText(this.message);
            int noBytes = byteBuf.readableBytes();
            int size = (Integer)connectionInfo.getWebSocketEndpoint().getNativeData("MAX_FRAME_SIZE");
            for (index = 0; index < noBytes - size; index += size) {
                ByteBuf slice = null;
                try {
                    slice = byteBuf.retainedSlice(index, size);
                    String chunk = slice.toString(CharsetUtil.UTF_8);
                    ChannelFuture future = connectionInfo.getWebSocketConnection().pushText(chunk, false);
                    promiseCombiner.add((Future)future);
                }
                catch (Throwable throwable) {
                    WebSocketConnector.release(slice);
                    throw throwable;
                }
                WebSocketConnector.release(slice);
            }
            lastSlice = byteBuf.retainedSlice(index, noBytes - index);
            String chunk = lastSlice.toString(CharsetUtil.UTF_8);
            ChannelFuture future = connectionInfo.getWebSocketConnection().pushText(chunk, true);
            promiseCombiner.add((Future)future);
            promiseCombiner.finish((Promise)connectionInfo.getWebSocketConnection().getChannel().newPromise().addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
                WebSocketConnector.removeWriteTimeoutHandler(this.clientEndpoint, connectionInfo);
                if (channelFuture.isSuccess()) {
                    WebSocketUtil.handleWebSocketCallback(this.balFuture, channelFuture, logger, connectionInfo, this.textCallbackCompleted);
                    WebSocketObservabilityUtil.observeSend("text", connectionInfo);
                    WebSocketUtil.adjustContextOnSuccess((RetryContext)this.clientEndpoint.getNativeData(WebSocketConstants.RETRY_CONFIG.toString()));
                } else if (!this.textCallbackCompleted.get()) {
                    WebSocketUtil.setCallbackFunctionBehaviour(connectionInfo, this.balFuture, future.cause(), this.textCallbackCompleted);
                }
            })));
        }
        catch (IllegalAccessException | IllegalStateException e) {
            try {
                WebSocketObservabilityUtil.observeError(WebSocketObservabilityUtil.getConnectionInfo(this.clientEndpoint), "message_sent", "text", e.getMessage());
                WebSocketUtil.setCallbackFunctionBehaviour(connectionInfo, this.balFuture, e, this.textCallbackCompleted);
            }
            catch (Throwable throwable) {
                WebSocketConnector.release(byteBuf);
                WebSocketConnector.release(lastSlice);
                throw throwable;
            }
            WebSocketConnector.release(byteBuf);
            WebSocketConnector.release(lastSlice);
        }
        WebSocketConnector.release(byteBuf);
        WebSocketConnector.release(lastSlice);
    }

    public void onError(Throwable throwable, HttpCarbonResponse httpCarbonResponse) {
        this.setWebSocketOpenConnectionInfo(null, this.clientEndpoint, (WebSocketService)this.clientEndpoint.getNativeData("callbackService"));
        if (throwable instanceof IOException && WebSocketUtil.reconnectForWrite(this.connectionInfo, this.balFuture, this.textCallbackCompleted, this.message, null)) {
            return;
        }
        if (!this.textCallbackCompleted.get()) {
            this.balFuture.complete((Object)WebSocketUtil.createErrorByType(throwable));
            this.textCallbackCompleted.set(true);
        }
    }

    private void setWebSocketOpenConnectionInfo(WebSocketConnection webSocketConnection, BObject webSocketClient, WebSocketService wsService) {
        this.connectionInfo = new WebSocketConnectionInfo(wsService, webSocketConnection, webSocketClient);
        webSocketClient.addNativeData("NATIVE_DATA_WEBSOCKET_CONNECTION_INFO", (Object)this.connectionInfo);
    }
}

