/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket.serviceendpoint;

import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.BallerinaConnectorException;
import io.ballerina.stdlib.http.api.HttpConnectionManager;
import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.transport.contract.ServerConnector;
import io.ballerina.stdlib.http.transport.contract.config.InboundMsgSizeValidationConfig;
import io.ballerina.stdlib.http.transport.contract.config.ListenerConfiguration;
import io.ballerina.stdlib.http.transport.contract.config.Parameter;
import io.ballerina.stdlib.http.transport.contract.config.SslConfiguration;
import io.ballerina.stdlib.websocket.WebSocketConstants;
import io.ballerina.stdlib.websocket.WebSocketUtil;
import io.ballerina.stdlib.websocket.serviceendpoint.AbstractWebsocketNativeFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class InitEndpoint
extends AbstractWebsocketNativeFunction {
    public static Object initEndpoint(BObject serviceEndpoint) {
        try {
            ServerConnector httpServerConnector;
            if (serviceEndpoint.get(StringUtils.fromString((String)"httpListener")) != null) {
                httpServerConnector = (ServerConnector)((BObject)serviceEndpoint.get(StringUtils.fromString((String)"httpListener"))).getNativeData("HTTP_SERVER_CONNECTOR");
            } else {
                BMap serviceEndpointConfig = serviceEndpoint.getMapValue(WebSocketConstants.SERVICE_ENDPOINT_CONFIG);
                long port = serviceEndpoint.getIntValue(WebSocketConstants.ENDPOINT_CONFIG_PORT);
                ListenerConfiguration listenerConfiguration = InitEndpoint.getListenerConfig(port, serviceEndpointConfig);
                httpServerConnector = HttpConnectionManager.getInstance().createHttpServerConnector(listenerConfiguration);
            }
            serviceEndpoint.addNativeData("HTTP_SERVER_CONNECTOR", (Object)httpServerConnector);
            InitEndpoint.resetRegistry(serviceEndpoint);
            return null;
        }
        catch (BError errorValue) {
            return errorValue;
        }
        catch (Exception e) {
            return WebSocketUtil.createWebsocketError(e.getMessage(), WebSocketConstants.ErrorCode.Error);
        }
    }

    private static ListenerConfiguration getListenerConfig(long port, BMap endpointConfig) {
        String host = endpointConfig.getStringValue(HttpConstants.ENDPOINT_CONFIG_HOST).getValue();
        BMap sslConfig = endpointConfig.getMapValue(HttpConstants.ENDPOINT_CONFIG_SECURESOCKET);
        long idleTimeout = (long)((BDecimal)endpointConfig.get((Object)WebSocketConstants.ANNOTATION_ATTR_TIMEOUT)).floatValue() * 1000L;
        ListenerConfiguration listenerConfiguration = new ListenerConfiguration();
        BMap http1Settings = (BMap)endpointConfig.get((Object)HttpConstants.HTTP1_SETTINGS);
        listenerConfiguration.setPipeliningLimit(http1Settings.getIntValue(HttpConstants.PIPELINING_REQUEST_LIMIT).longValue());
        String keepAlive = http1Settings.getStringValue(HttpConstants.ENDPOINT_CONFIG_KEEP_ALIVE).getValue();
        listenerConfiguration.setKeepAliveConfig(HttpUtil.getKeepAliveConfig((String)keepAlive));
        BMap requestLimits = endpointConfig.getMapValue(HttpConstants.REQUEST_LIMITS);
        HttpUtil.setInboundMgsSizeValidationConfig((long)requestLimits.getIntValue(HttpConstants.MAX_URI_LENGTH), (long)requestLimits.getIntValue(HttpConstants.MAX_HEADER_SIZE), (long)requestLimits.getIntValue(HttpConstants.MAX_ENTITY_BODY_SIZE), (InboundMsgSizeValidationConfig)listenerConfiguration.getMsgSizeValidationConfig());
        listenerConfiguration.setHost(host);
        if (port == 0L) {
            throw new BallerinaConnectorException("Listener port is not defined");
        }
        listenerConfiguration.setPort(Math.toIntExact(port));
        if (idleTimeout < 0L) {
            throw new BallerinaConnectorException("Idle timeout cannot be negative. If you want to disable the timeout please use value 0");
        }
        listenerConfiguration.setSocketIdleTimeout(Math.toIntExact(idleTimeout));
        listenerConfiguration.setVersion("1.1");
        if (endpointConfig.getType().getName().equalsIgnoreCase("ListenerConfiguration")) {
            BString serverName = endpointConfig.getStringValue(HttpConstants.SERVER_NAME);
            listenerConfiguration.setServerHeader(serverName != null ? serverName.getValue() : "ballerina");
        }
        listenerConfiguration.setPipeliningEnabled(true);
        Object webSocketCompressionEnabled = endpointConfig.get((Object)WebSocketConstants.COMPRESSION_ENABLED_CONFIG);
        if (webSocketCompressionEnabled != null) {
            listenerConfiguration.setWebSocketCompressionEnabled(((Boolean)webSocketCompressionEnabled).booleanValue());
        }
        if (sslConfig != null) {
            return InitEndpoint.setSslConfig((BMap<BString, Object>)sslConfig, listenerConfiguration);
        }
        return listenerConfiguration;
    }

    private static ListenerConfiguration setSslConfig(BMap<BString, Object> secureSocket, ListenerConfiguration listenerConfiguration) {
        BArray ciphers;
        BMap<BString, Object> certValidation;
        BMap<BString, Object> protocol;
        ArrayList<Parameter> serverParamList = new ArrayList<Parameter>();
        listenerConfiguration.setScheme("https");
        BMap<BString, Object> key = InitEndpoint.getBMapValueIfPresent(secureSocket, HttpConstants.SECURESOCKET_CONFIG_KEY);
        assert (key != null);
        InitEndpoint.evaluateKeyField(key, (SslConfiguration)listenerConfiguration);
        BMap<BString, Object> mutualSsl = InitEndpoint.getBMapValueIfPresent(secureSocket, HttpConstants.SECURESOCKET_CONFIG_MUTUAL_SSL);
        if (mutualSsl != null) {
            String verifyClient = mutualSsl.getStringValue(HttpConstants.SECURESOCKET_CONFIG_VERIFY_CLIENT).getValue();
            listenerConfiguration.setVerifyClient(verifyClient);
            Object cert = mutualSsl.get((Object)HttpConstants.SECURESOCKET_CONFIG_CERT);
            InitEndpoint.evaluateCertField(cert, (SslConfiguration)listenerConfiguration);
        }
        if ((protocol = InitEndpoint.getBMapValueIfPresent(secureSocket, HttpConstants.SECURESOCKET_CONFIG_PROTOCOL)) != null) {
            InitEndpoint.evaluateProtocolField(protocol, (SslConfiguration)listenerConfiguration, serverParamList);
        }
        if ((certValidation = InitEndpoint.getBMapValueIfPresent(secureSocket, HttpConstants.SECURESOCKET_CONFIG_CERT_VALIDATION)) != null) {
            InitEndpoint.evaluateCertValidationField(certValidation, (SslConfiguration)listenerConfiguration);
        }
        BArray bArray = ciphers = secureSocket.containsKey((Object)HttpConstants.SECURESOCKET_CONFIG_CIPHERS) ? secureSocket.getArrayValue(HttpConstants.SECURESOCKET_CONFIG_CIPHERS) : null;
        if (ciphers != null) {
            InitEndpoint.evaluateCiphersField(ciphers, serverParamList);
        }
        InitEndpoint.evaluateCommonFields(secureSocket, (SslConfiguration)listenerConfiguration, serverParamList);
        listenerConfiguration.setTLSStoreType("PKCS12");
        if (!serverParamList.isEmpty()) {
            listenerConfiguration.setParameters(serverParamList);
        }
        listenerConfiguration.setId(HttpUtil.getListenerInterface((String)listenerConfiguration.getHost(), (int)listenerConfiguration.getPort()));
        return listenerConfiguration;
    }

    private static void evaluateKeyField(BMap<BString, Object> key, SslConfiguration sslConfiguration) {
        if (key.containsKey((Object)HttpConstants.SECURESOCKET_CONFIG_KEYSTORE_FILE_PATH)) {
            String keyStoreFile = key.getStringValue(HttpConstants.SECURESOCKET_CONFIG_KEYSTORE_FILE_PATH).getValue();
            if (keyStoreFile.isBlank()) {
                throw WebSocketUtil.createWebsocketError("KeyStore file location must be provided for secure connection", WebSocketConstants.ErrorCode.SslError);
            }
            String keyStorePassword = key.getStringValue(HttpConstants.SECURESOCKET_CONFIG_KEYSTORE_PASSWORD).getValue();
            if (keyStorePassword.isBlank()) {
                throw WebSocketUtil.createWebsocketError("KeyStore password must be provided for secure connection", WebSocketConstants.ErrorCode.SslError);
            }
            sslConfiguration.setKeyStoreFile(keyStoreFile);
            sslConfiguration.setKeyStorePass(keyStorePassword);
        } else {
            BString keyPassword;
            String certFile = key.getStringValue(HttpConstants.SECURESOCKET_CONFIG_CERTKEY_CERT_FILE).getValue();
            String keyFile = key.getStringValue(HttpConstants.SECURESOCKET_CONFIG_CERTKEY_KEY_FILE).getValue();
            BString bString = keyPassword = key.containsKey((Object)HttpConstants.SECURESOCKET_CONFIG_CERTKEY_KEY_PASSWORD) ? key.getStringValue(HttpConstants.SECURESOCKET_CONFIG_CERTKEY_KEY_PASSWORD) : null;
            if (certFile.isBlank()) {
                throw WebSocketUtil.createWebsocketError("Certificate file location must be provided for secure connection", WebSocketConstants.ErrorCode.SslError);
            }
            if (keyFile.isBlank()) {
                throw WebSocketUtil.createWebsocketError("Private key file location must be provided for secure connection", WebSocketConstants.ErrorCode.SslError);
            }
            sslConfiguration.setServerCertificates(certFile);
            sslConfiguration.setServerKeyFile(keyFile);
            if (keyPassword != null && !keyPassword.getValue().isBlank()) {
                sslConfiguration.setServerKeyPassword(keyPassword.getValue());
            }
        }
    }

    private static void evaluateCertField(Object cert, SslConfiguration sslConfiguration) {
        if (cert instanceof BMap) {
            BMap trustStore = (BMap)cert;
            String trustStoreFile = trustStore.getStringValue(HttpConstants.SECURESOCKET_CONFIG_TRUSTSTORE_FILE_PATH).getValue();
            String trustStorePassword = trustStore.getStringValue(HttpConstants.SECURESOCKET_CONFIG_TRUSTSTORE_PASSWORD).getValue();
            if (trustStoreFile.isBlank()) {
                throw WebSocketUtil.createWebsocketError("TrustStore file location must be provided for secure connection", WebSocketConstants.ErrorCode.SslError);
            }
            if (trustStorePassword.isBlank()) {
                throw WebSocketUtil.createWebsocketError("TrustStore password must be provided for secure connection", WebSocketConstants.ErrorCode.SslError);
            }
            sslConfiguration.setTrustStoreFile(trustStoreFile);
            sslConfiguration.setTrustStorePass(trustStorePassword);
        } else {
            String certFile = ((BString)cert).getValue();
            if (certFile.isBlank()) {
                throw WebSocketUtil.createWebsocketError("Certificate file location must be provided for secure connection", WebSocketConstants.ErrorCode.SslError);
            }
            sslConfiguration.setServerTrustCertificates(certFile);
        }
    }

    private static void evaluateProtocolField(BMap<BString, Object> protocol, SslConfiguration sslConfiguration, List<Parameter> paramList) {
        String sslProtocol;
        List<String> sslEnabledProtocolsValueList = Arrays.asList(protocol.getArrayValue(HttpConstants.SECURESOCKET_CONFIG_PROTOCOL_VERSIONS).getStringArray());
        if (!sslEnabledProtocolsValueList.isEmpty()) {
            String sslEnabledProtocols = sslEnabledProtocolsValueList.stream().collect(Collectors.joining(",", "", ""));
            Parameter serverProtocols = new Parameter("sslEnabledProtocols", sslEnabledProtocols);
            paramList.add(serverProtocols);
        }
        if (!(sslProtocol = protocol.getStringValue(HttpConstants.SECURESOCKET_CONFIG_PROTOCOL_NAME).getValue()).isBlank()) {
            sslConfiguration.setSSLProtocol(sslProtocol);
        }
    }

    private static void evaluateCertValidationField(BMap<BString, Object> certValidation, SslConfiguration sslConfiguration) {
        String type = certValidation.getStringValue(HttpConstants.SECURESOCKET_CONFIG_CERT_VALIDATION_TYPE).getValue();
        if (type.equals(HttpConstants.SECURESOCKET_CONFIG_CERT_VALIDATION_TYPE_OCSP_STAPLING.getValue())) {
            sslConfiguration.setOcspStaplingEnabled(true);
        } else {
            sslConfiguration.setValidateCertEnabled(true);
        }
        long cacheSize = certValidation.getIntValue(HttpConstants.SECURESOCKET_CONFIG_CERT_VALIDATION_CACHE_SIZE).intValue();
        long cacheValidityPeriod = ((BDecimal)certValidation.get((Object)HttpConstants.SECURESOCKET_CONFIG_CERT_VALIDATION_CACHE_VALIDITY_PERIOD)).intValue();
        if (cacheValidityPeriod != 0L) {
            sslConfiguration.setCacheValidityPeriod(Math.toIntExact(cacheValidityPeriod));
        }
        if (cacheSize != 0L) {
            sslConfiguration.setCacheSize(Math.toIntExact(cacheSize));
        }
    }

    private static void evaluateCiphersField(BArray ciphers, List<Parameter> paramList) {
        String[] ciphersArray = ciphers.getStringArray();
        List<String> ciphersList = Arrays.asList(ciphersArray);
        if (ciphersList.size() > 0) {
            String ciphersString = ciphersList.stream().map(Object::toString).collect(Collectors.joining(",", "", ""));
            Parameter serverParameters = new Parameter("ciphers", ciphersString);
            paramList.add(serverParameters);
        }
    }

    private static void evaluateCommonFields(BMap<BString, Object> secureSocket, SslConfiguration sslConfiguration, List<Parameter> paramList) {
        sslConfiguration.setSslSessionTimeOut((int)InitEndpoint.getLongValueOrDefault(secureSocket, HttpConstants.SECURESOCKET_CONFIG_SESSION_TIMEOUT));
        sslConfiguration.setSslHandshakeTimeOut(InitEndpoint.getLongValueOrDefault(secureSocket, HttpConstants.SECURESOCKET_CONFIG_HANDSHAKE_TIMEOUT));
        String enableSessionCreation = String.valueOf(secureSocket.getBooleanValue(HttpConstants.SECURESOCKET_CONFIG_SHARE_SESSION));
        Parameter enableSessionCreationParam = new Parameter(HttpConstants.SECURESOCKET_CONFIG_SHARE_SESSION.getValue(), enableSessionCreation);
        paramList.add(enableSessionCreationParam);
    }

    private static BMap<BString, Object> getBMapValueIfPresent(BMap<BString, Object> map, BString key) {
        return map.containsKey((Object)key) ? map.getMapValue(key) : null;
    }

    private static long getLongValueOrDefault(BMap<BString, Object> map, BString key) {
        return map.containsKey((Object)key) ? ((BDecimal)map.get((Object)key)).intValue() : 0L;
    }

    private InitEndpoint() {
    }
}

