/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket.serviceendpoint;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.types.ResourceMethodType;
import io.ballerina.runtime.api.types.ServiceType;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.websocket.server.WebSocketServerService;
import io.ballerina.stdlib.websocket.server.WebSocketServicesRegistry;
import io.ballerina.stdlib.websocket.serviceendpoint.AbstractWebsocketNativeFunction;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class Register
extends AbstractWebsocketNativeFunction {
    public static Object register(Environment env, BObject serviceEndpoint, BObject service, Object serviceName) {
        WebSocketServicesRegistry webSocketServicesRegistry = Register.getWebSocketServicesRegistry(serviceEndpoint);
        Runtime runtime = env.getRuntime();
        String basePath = Register.getBasePath(serviceName);
        ResourceMethodType[] resourceList = ((ServiceType)TypeUtils.getType((Object)service)).getResourceMethods();
        ResourceMethodType resource = resourceList[0];
        resource.getAccessor();
        try {
            if (resourceList.length == 1 && resourceList[0].getAccessor().equals("get")) {
                webSocketServicesRegistry.registerService(new WebSocketServerService(service, runtime, basePath));
            }
        }
        catch (BError ex) {
            return ex;
        }
        return null;
    }

    private static String getBasePath(Object serviceName) {
        if (serviceName instanceof BArray) {
            List strings = Arrays.stream(((BArray)serviceName).getStringArray()).map(HttpUtil::unescapeAndEncodeValue).collect(Collectors.toList());
            String basePath = String.join((CharSequence)"/", strings);
            return HttpUtil.sanitizeBasePath((String)basePath);
        }
        if (serviceName instanceof BString) {
            String basePath = ((BString)serviceName).getValue();
            return HttpUtil.sanitizeBasePath((String)basePath);
        }
        return "/";
    }

    private Register() {
    }
}

