/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.mime.nativeimpl;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BValue;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.stdlib.io.channels.base.Channel;
import io.ballerina.stdlib.io.utils.IOConstants;
import io.ballerina.stdlib.io.utils.IOUtils;
import io.ballerina.stdlib.mime.nativeimpl.MimeDataSourceBuilder;
import io.ballerina.stdlib.mime.util.EntityBodyChannel;
import io.ballerina.stdlib.mime.util.EntityBodyHandler;
import io.ballerina.stdlib.mime.util.EntityWrapper;
import io.ballerina.stdlib.mime.util.HeaderUtil;
import io.ballerina.stdlib.mime.util.MimeConstants;
import io.ballerina.stdlib.mime.util.MimeUtil;
import io.ballerina.stdlib.mime.util.MultipartDataSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeEntityBody {
    private static final Logger log = LoggerFactory.getLogger(MimeEntityBody.class);

    public static Object getBodyParts(BObject entityObj) {
        try {
            String baseType = HeaderUtil.getBaseType(entityObj);
            if (baseType != null && (baseType.toLowerCase(Locale.getDefault()).startsWith("multipart/") || baseType.toLowerCase(Locale.getDefault()).startsWith("message/"))) {
                Channel byteChannel;
                BArray partsArray = EntityBodyHandler.getBodyPartArray(entityObj);
                if ((partsArray == null || partsArray.size() < 1) && (byteChannel = EntityBodyHandler.getByteChannel(entityObj)) != null) {
                    EntityBodyHandler.decodeEntityBody(entityObj, byteChannel);
                    partsArray = EntityBodyHandler.getBodyPartArray(entityObj);
                    entityObj.addNativeData("entity_byte_channel", null);
                }
                return partsArray;
            }
            return MimeUtil.createError("ParserError", "Entity body is not a type of composite media type. Received content-type : " + baseType);
        }
        catch (Throwable err) {
            return MimeUtil.createError("ParserError", "Error occurred while extracting body parts from entity: " + MimeDataSourceBuilder.getErrorMsg(err));
        }
    }

    public static Object getBodyPartsAsChannel(Environment env, BObject entityObj) {
        try {
            String contentType = MimeUtil.getContentTypeWithParameters(entityObj);
            if (HeaderUtil.isMultipart(contentType)) {
                EntityBodyChannel entityBodyChannel = MimeEntityBody.createEntityBodyChannel(env, entityObj, contentType);
                BObject byteChannelObj = ValueCreator.createObjectValue((Module)IOUtils.getIOPackage(), (String)"ReadableByteChannel", (Object[])new Object[0]);
                byteChannelObj.addNativeData("byteChannel", (Object)new EntityWrapper(entityBodyChannel));
                return byteChannelObj;
            }
            return MimeUtil.createError("ParserError", "Entity doesn't contain body parts");
        }
        catch (Throwable err) {
            log.error("Error occurred while constructing a byte channel out of body parts", err);
            return MimeUtil.createError("ParserError", "Error occurred while constructing a byte channel out of body parts : " + MimeDataSourceBuilder.getErrorMsg(err));
        }
    }

    public static Object getBodyPartsAsStream(Environment env, BObject entityObj) {
        try {
            String contentType = MimeUtil.getContentTypeWithParameters(entityObj);
            if (HeaderUtil.isMultipart(contentType)) {
                EntityBodyChannel entityBodyChannel = MimeEntityBody.createEntityBodyChannel(env, entityObj, contentType);
                entityObj.addNativeData("entity_byte_channel", (Object)new EntityWrapper(entityBodyChannel));
                return null;
            }
            return MimeUtil.createError("ParserError", "Entity doesn't contain body parts");
        }
        catch (Throwable err) {
            log.error("Error occurred while constructing a byte stream out of body parts", err);
            return MimeUtil.createError("ParserError", "Error occurred while constructing a byte stream out of body parts : " + MimeDataSourceBuilder.getErrorMsg(err));
        }
    }

    private static EntityBodyChannel createEntityBodyChannel(Environment env, BObject entityObj, String contentType) throws IOException {
        String boundaryValue = HeaderUtil.extractBoundaryParameter(contentType);
        String multipartDataBoundary = boundaryValue != null ? boundaryValue : MimeUtil.getNewMultipartDelimiter();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        MultipartDataSource multipartDataSource = new MultipartDataSource(env, entityObj, multipartDataBoundary);
        multipartDataSource.serialize(outputStream);
        EntityBodyChannel entityBodyChannel = new EntityBodyChannel(new ByteArrayInputStream(outputStream.toByteArray()));
        MimeUtil.closeOutputStream(outputStream);
        return entityBodyChannel;
    }

    public static Object getByteChannel(BObject entityObj) {
        try {
            BObject byteChannelObj = ValueCreator.createObjectValue((Module)IOUtils.getIOPackage(), (String)"ReadableByteChannel", (Object[])new Object[0]);
            Channel byteChannel = EntityBodyHandler.getByteChannel(entityObj);
            if (byteChannel != null) {
                byteChannelObj.addNativeData("byteChannel", (Object)byteChannel);
                return byteChannelObj;
            }
            if (EntityBodyHandler.getMessageDataSource(entityObj) != null) {
                return MimeUtil.createError("ParserError", "Byte channel is not available but payload can be obtain either as xml, json, string or byte[] type");
            }
            if (EntityBodyHandler.getBodyPartArray(entityObj) != null && EntityBodyHandler.getBodyPartArray(entityObj).size() != 0) {
                return MimeUtil.createError("ParserError", "Byte channel is not available since payload contains a set of body parts");
            }
            return MimeUtil.createError("ParserError", "Byte channel is not available as payload");
        }
        catch (Throwable err) {
            return MimeUtil.createError("ParserError", "Error occurred while constructing byte channel from entity body : " + MimeDataSourceBuilder.getErrorMsg(err));
        }
    }

    public static Object getByteStream(BObject entityObj) {
        BStream byteStream = EntityBodyHandler.getByteStream(entityObj);
        if (byteStream != null) {
            return byteStream;
        }
        Channel byteChannel = EntityBodyHandler.getByteChannel(entityObj);
        if (byteChannel != null) {
            return null;
        }
        if (EntityBodyHandler.getMessageDataSource(entityObj) != null) {
            return MimeUtil.createError("ParserError", "Byte stream is not available but payload can be obtain either as xml, json, string or byte[] type");
        }
        if (EntityBodyHandler.getBodyPartArray(entityObj) != null && EntityBodyHandler.getBodyPartArray(entityObj).size() != 0) {
            return MimeUtil.createError("ParserError", "Byte stream is not available since payload contains a set of body parts");
        }
        return MimeUtil.createError("ParserError", "Byte stream is not available as payload");
    }

    public static Object getStreamEntryRecord(Environment env, BObject entityObj, long inputArraySize) {
        return env.yieldAndRun(() -> {
            byte[] bytes;
            Channel byteChannel = EntityBodyHandler.getByteChannel(entityObj);
            if (byteChannel == null) {
                return null;
            }
            int arraySize = (int)inputArraySize;
            try {
                InputStream inputStream = byteChannel.getInputStream();
                try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                    do {
                        byte[] buffer = new byte[arraySize];
                        int readCount = inputStream.read(buffer, 0, arraySize);
                        arraySize -= readCount;
                        if (readCount == -1 && output.size() == 0) {
                            EntityBodyHandler.closeByteChannel(byteChannel);
                            entityObj.addNativeData("entity_byte_channel", null);
                            BValue bValue = null;
                            return bValue;
                        }
                        if (readCount == -1) break;
                        output.write(buffer, 0, readCount);
                    } while (arraySize > 0);
                    bytes = output.toByteArray();
                }
            }
            catch (IOException | RuntimeException ex) {
                return IOUtils.createError((IOConstants.ErrorCode)IOConstants.ErrorCode.GenericError, (String)("Error occurred while reading stream:" + ex.getMessage()));
            }
            BMap streamEntry = ValueCreator.createRecordValue((Module)MimeUtil.getMimePackage(), (String)"StreamEntry");
            streamEntry.put((Object)MimeConstants.FIELD_VALUE, (Object)ValueCreator.createArrayValue((byte[])bytes));
            return streamEntry;
        });
    }

    public static Object closeInputByteStream(BObject entityObj) {
        Channel byteChannel = EntityBodyHandler.getByteChannel(entityObj);
        if (byteChannel != null) {
            try {
                byteChannel.close();
                entityObj.addNativeData("entity_byte_channel", null);
            }
            catch (IOException e) {
                return IOUtils.createError((Throwable)e);
            }
        }
        return null;
    }

    public static Object getMediaType(BString contentType) {
        try {
            BObject mediaType = ValueCreator.createObjectValue((Module)MimeUtil.getMimePackage(), (String)"MediaType", (Object[])new Object[0]);
            return MimeUtil.parseMediaType(mediaType, contentType.getValue());
        }
        catch (Throwable err) {
            return MimeUtil.createError("InvalidContentTypeError", MimeDataSourceBuilder.getErrorMsg(err));
        }
    }

    public static void setBodyParts(BObject entityObj, BArray bodyParts, BString contentType) {
        entityObj.addNativeData("body_parts", (Object)bodyParts);
        MimeUtil.setMediaTypeToEntity(entityObj, contentType != null ? contentType.getValue() : "multipart/form-data");
    }

    public static void setByteArray(BObject entityObj, BArray payload, BString contentType) {
        EntityBodyHandler.addMessageDataSource(entityObj, payload);
        MimeUtil.setMediaTypeToEntity(entityObj, contentType != null ? contentType.getValue() : "application/octet-stream");
    }

    public static void setByteChannel(BObject entityObj, BObject byteChannel, BString contentType) {
        entityObj.addNativeData("entity_byte_channel", byteChannel.getNativeData("byteChannel"));
        Object dataSource = EntityBodyHandler.getMessageDataSource(entityObj);
        if (dataSource != null) {
            entityObj.addNativeData("message_datasource", null);
        }
        MimeUtil.setMediaTypeToEntity(entityObj, contentType != null ? contentType.getValue() : "application/octet-stream");
    }

    public static void setByteStream(BObject entityObj, BStream byteStream, BString contentType) {
        entityObj.addNativeData("entity_byte_stream", (Object)byteStream);
        entityObj.addNativeData("entity_byte_channel", null);
        entityObj.addNativeData("message_datasource", null);
        MimeUtil.setMediaTypeToEntity(entityObj, contentType != null ? contentType.getValue() : "application/octet-stream");
    }

    public static void setJson(BObject entityObj, Object jsonContent, BString contentType) {
        EntityBodyHandler.addJsonMessageDataSource(entityObj, jsonContent);
        MimeUtil.setMediaTypeToEntity(entityObj, contentType != null ? contentType.getValue() : "application/json");
    }

    public static void setText(BObject entityObj, BString textContent, BString contentType) {
        EntityBodyHandler.addMessageDataSource(entityObj, textContent);
        MimeUtil.setMediaTypeToEntity(entityObj, contentType != null ? contentType.getValue() : "text/plain");
    }

    public static void setXml(BObject entityObj, BXml xmlContent, BString contentType) {
        EntityBodyHandler.addMessageDataSource(entityObj, xmlContent);
        MimeUtil.setMediaTypeToEntity(entityObj, contentType != null ? contentType.getValue() : "application/xml");
    }

    public static Object writeEventStreamBytesToOutputStream(BObject eventStreamWriter, BArray bytes) {
        return EntityBodyHandler.writeEventStreamBytesToOutputStream(eventStreamWriter, bytes.getBytes());
    }

    private MimeEntityBody() {
    }
}

