/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contractimpl.common.BackPressureHandler;
import org.wso2.transport.http.netty.contractimpl.common.HttpRoute;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.common.states.SenderReqRespStateManager;
import org.wso2.transport.http.netty.contractimpl.sender.ConnectionAvailabilityFuture;
import org.wso2.transport.http.netty.contractimpl.sender.HttpClientChannelInitializer;
import org.wso2.transport.http.netty.contractimpl.sender.TargetHandler;
import org.wso2.transport.http.netty.contractimpl.sender.channel.pool.ConnectionManager;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2ClientChannel;
import org.wso2.transport.http.netty.internal.HandlerExecutor;
import org.wso2.transport.http.netty.internal.HttpTransportContextHolder;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class TargetChannel {
    private static final Logger LOG = LoggerFactory.getLogger(TargetChannel.class);
    public SenderReqRespStateManager senderReqRespStateManager;
    public String trgHlrConnPoolId;
    private boolean requestHeaderWritten = false;
    private Channel channel;
    private HttpClientChannelInitializer httpClientChannelInitializer;
    private ChannelInboundHandlerAdapter correlatedSource;
    private ConnectionManager connectionManager;
    private TargetHandler targetHandler;
    private Http2ClientChannel http2ClientChannel;
    private final HttpRoute httpRoute;
    private final ChannelFuture channelFuture;
    private final HandlerExecutor handlerExecutor;
    private final ConnectionAvailabilityFuture connectionAvailabilityFuture;

    public TargetChannel(HttpClientChannelInitializer httpClientChannelInitializer, ChannelFuture channelFuture, HttpRoute httpRoute, ConnectionAvailabilityFuture connectionAvailabilityFuture) {
        this.httpClientChannelInitializer = httpClientChannelInitializer;
        this.channelFuture = channelFuture;
        this.handlerExecutor = HttpTransportContextHolder.getInstance().getHandlerExecutor();
        this.httpRoute = httpRoute;
        if (httpClientChannelInitializer != null) {
            this.http2ClientChannel = new Http2ClientChannel(httpClientChannelInitializer.getHttp2ConnectionManager(), httpClientChannelInitializer.getConnection(), httpRoute, channelFuture.channel());
        }
        this.connectionAvailabilityFuture = connectionAvailabilityFuture;
    }

    public void configTargetHandler(HttpCarbonMessage httpCarbonMessage, HttpResponseFuture httpInboundResponseFuture) {
        this.targetHandler = this.httpClientChannelInitializer.getTargetHandler();
        this.targetHandler.setHttpResponseFuture(httpInboundResponseFuture);
        this.targetHandler.setOutboundRequestMsg(httpCarbonMessage);
        this.targetHandler.setConnectionManager(this.connectionManager);
        this.targetHandler.setTargetChannel(this);
    }

    public void writeContent(HttpCarbonMessage httpOutboundRequest) {
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtTargetRequestReceiving(httpOutboundRequest);
        }
        BackPressureHandler backpressureHandler = Util.getBackPressureHandler(this.targetHandler.getContext());
        Util.setBackPressureListener(httpOutboundRequest, backpressureHandler, httpOutboundRequest.getSourceContext());
        this.resetTargetChannelState();
        httpOutboundRequest.getHttpContentAsync().setMessageListener(httpContent -> {
            Util.checkUnWritabilityAndNotify(this.targetHandler.getContext(), backpressureHandler);
            this.channel.eventLoop().execute(() -> {
                try {
                    this.senderReqRespStateManager.writeOutboundRequestEntity(httpOutboundRequest, httpContent);
                }
                catch (Exception exception) {
                    String errorMsg = "Failed to send the request : " + exception.getMessage().toLowerCase(Locale.ENGLISH);
                    LOG.error(errorMsg, (Throwable)exception);
                    this.targetHandler.getHttpResponseFuture().notifyHttpListener(exception);
                }
            });
        });
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public ChannelFuture getChannelFuture() {
        return this.channelFuture;
    }

    private void resetTargetChannelState() {
        this.requestHeaderWritten = false;
    }

    public void setCorrelatedSource(ChannelInboundHandlerAdapter correlatedSource) {
        this.correlatedSource = correlatedSource;
    }

    public ChannelInboundHandlerAdapter getCorrelatedSource() {
        return this.correlatedSource;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public Http2ClientChannel getHttp2ClientChannel() {
        return this.http2ClientChannel;
    }

    public ConnectionAvailabilityFuture getConnectionReadyFuture() {
        return this.connectionAvailabilityFuture;
    }

    public void setRequestHeaderWritten(boolean isRequestWritten) {
        this.requestHeaderWritten = isRequestWritten;
    }

    public boolean isRequestHeaderWritten() {
        return this.requestHeaderWritten;
    }

    public HttpRoute getHttpRoute() {
        return this.httpRoute;
    }
}

