/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.extension;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.flowmodelgenerator.core.DataMapManager;
import io.ballerina.flowmodelgenerator.extension.request.DataMapperAddElementRequest;
import io.ballerina.flowmodelgenerator.extension.request.DataMapperModelRequest;
import io.ballerina.flowmodelgenerator.extension.request.DataMapperQueryConvertRequest;
import io.ballerina.flowmodelgenerator.extension.request.DataMapperSourceRequest;
import io.ballerina.flowmodelgenerator.extension.request.DataMapperTypesRequest;
import io.ballerina.flowmodelgenerator.extension.request.DataMapperVisualizeRequest;
import io.ballerina.flowmodelgenerator.extension.response.DataMapperAddElementResponse;
import io.ballerina.flowmodelgenerator.extension.response.DataMapperModelResponse;
import io.ballerina.flowmodelgenerator.extension.response.DataMapperSourceResponse;
import io.ballerina.flowmodelgenerator.extension.response.DataMapperTypesResponse;
import io.ballerina.flowmodelgenerator.extension.response.DataMapperVisualizeResponse;
import io.ballerina.projects.Document;
import io.ballerina.projects.Project;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.eclipse.lsp4j.services.LanguageServer;

@JsonSegment(value="dataMapper")
public class DataMapperService
implements ExtendedLanguageServerService {
    private WorkspaceManager workspaceManager;

    public void init(LanguageServer langServer, WorkspaceManager workspaceManager) {
        this.workspaceManager = workspaceManager;
    }

    public Class<?> getRemoteInterface() {
        return null;
    }

    @JsonRequest
    public CompletableFuture<DataMapperTypesResponse> types(DataMapperTypesRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            DataMapperTypesResponse response = new DataMapperTypesResponse();
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                this.workspaceManager.loadProject(filePath);
                Optional semanticModel = this.workspaceManager.semanticModel(filePath);
                Optional document = this.workspaceManager.document(filePath);
                if (semanticModel.isEmpty() || document.isEmpty()) {
                    return response;
                }
                DataMapManager dataMapManager = new DataMapManager(this.workspaceManager, (Document)document.get());
                response.setType(dataMapManager.getTypes(request.flowNode(), request.propertyKey(), (SemanticModel)semanticModel.get()));
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<DataMapperModelResponse> mappings(DataMapperModelRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            DataMapperModelResponse response = new DataMapperModelResponse();
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                Project project = this.workspaceManager.loadProject(filePath);
                Optional document = this.workspaceManager.document(filePath);
                if (document.isEmpty()) {
                    return response;
                }
                DataMapManager dataMapManager = new DataMapManager(this.workspaceManager, (Document)document.get());
                response.setMappingsModel(dataMapManager.getMappings(request.flowNode(), request.position(), request.propertyKey(), Path.of(request.filePath(), new String[0]), request.targetField(), project));
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<DataMapperSourceResponse> getSource(DataMapperSourceRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            DataMapperSourceResponse response = new DataMapperSourceResponse();
            try {
                DataMapManager dataMapManager = new DataMapManager(null, null);
                response.setSource(dataMapManager.getSource(request.mappings(), request.flowNode(), request.targetField()));
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<DataMapperSourceResponse> convertToQuery(DataMapperQueryConvertRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            DataMapperSourceResponse response = new DataMapperSourceResponse();
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                Project project = this.workspaceManager.loadProject(filePath);
                Optional semanticModel = this.workspaceManager.semanticModel(filePath);
                Optional document = this.workspaceManager.document(filePath);
                if (semanticModel.isEmpty() || document.isEmpty()) {
                    return response;
                }
                DataMapManager dataMapManager = new DataMapManager(this.workspaceManager, (Document)document.get());
                response.setSource(dataMapManager.getQuery(request.flowNode(), request.targetField(), Path.of(request.filePath(), new String[0]), request.position(), project));
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<DataMapperVisualizeResponse> visualizable(DataMapperVisualizeRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            DataMapperVisualizeResponse response = new DataMapperVisualizeResponse();
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                Project project = this.workspaceManager.loadProject(filePath);
                Optional document = this.workspaceManager.document(filePath);
                if (document.isEmpty()) {
                    return response;
                }
                DataMapManager dataMapManager = new DataMapManager(this.workspaceManager, (Document)document.get());
                response.setVisualizableProperties(dataMapManager.getVisualizableProperties(request.flowNode(), project, filePath, request.position()));
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<DataMapperAddElementResponse> addElement(DataMapperAddElementRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            DataMapperAddElementResponse response = new DataMapperAddElementResponse();
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                Project project = this.workspaceManager.loadProject(filePath);
                Optional semanticModel = this.workspaceManager.semanticModel(filePath);
                Optional document = this.workspaceManager.document(filePath);
                if (semanticModel.isEmpty() || document.isEmpty()) {
                    return response;
                }
                DataMapManager dataMapManager = new DataMapManager(this.workspaceManager, (Document)document.get());
                response.setSource(dataMapManager.addElement(request.flowNode(), request.propertyKey(), Path.of(request.filePath(), new String[0]), request.targetField(), project, request.position()));
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }
}

