/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.extension;

import com.google.gson.JsonArray;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.flowmodelgenerator.core.TypesGenerator;
import io.ballerina.flowmodelgenerator.core.VisibleVariableTypesGenerator;
import io.ballerina.flowmodelgenerator.core.expressioneditor.Debouncer;
import io.ballerina.flowmodelgenerator.core.expressioneditor.DocumentContext;
import io.ballerina.flowmodelgenerator.core.expressioneditor.ExpressionEditorContext;
import io.ballerina.flowmodelgenerator.core.expressioneditor.services.CompletionRequest;
import io.ballerina.flowmodelgenerator.core.expressioneditor.services.DebouncedExpressionEditorRequest;
import io.ballerina.flowmodelgenerator.core.expressioneditor.services.DiagnosticsRequest;
import io.ballerina.flowmodelgenerator.core.expressioneditor.services.SignatureHelpRequest;
import io.ballerina.flowmodelgenerator.core.model.Codedata;
import io.ballerina.flowmodelgenerator.extension.request.ExpressionEditorCompletionRequest;
import io.ballerina.flowmodelgenerator.extension.request.ExpressionEditorDiagnosticsRequest;
import io.ballerina.flowmodelgenerator.extension.request.ExpressionEditorSignatureRequest;
import io.ballerina.flowmodelgenerator.extension.request.ExpressionEditorTypesRequest;
import io.ballerina.flowmodelgenerator.extension.request.FunctionCallTemplateRequest;
import io.ballerina.flowmodelgenerator.extension.request.ImportModuleRequest;
import io.ballerina.flowmodelgenerator.extension.request.VisibleVariableTypeRequest;
import io.ballerina.flowmodelgenerator.extension.response.FunctionCallTemplateResponse;
import io.ballerina.flowmodelgenerator.extension.response.ImportModuleResponse;
import io.ballerina.flowmodelgenerator.extension.response.VisibleVariableTypesResponse;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.ModuleInfo;
import io.ballerina.modelgenerator.commons.PackageUtil;
import io.ballerina.projects.CompilationOptions;
import io.ballerina.projects.Document;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleDependency;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.Project;
import io.ballerina.tools.text.LinePosition;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.langserver.LSClientLogger;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManagerProxy;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.eclipse.lsp4j.services.LanguageServer;

@JsonSegment(value="expressionEditor")
public class ExpressionEditorService
implements ExtendedLanguageServerService {
    private WorkspaceManagerProxy workspaceManagerProxy;
    private LanguageServer langServer;
    private LSClientLogger lsClientLogger;
    private static final CompilationOptions COMPILATION_OPTIONS = CompilationOptions.builder().setSticky(Boolean.valueOf(false)).setOffline(Boolean.valueOf(false)).build();

    public void init(LanguageServer langServer, WorkspaceManagerProxy workspaceManagerProxy, LanguageServerContext serverContext) {
        this.workspaceManagerProxy = workspaceManagerProxy;
        this.langServer = langServer;
        this.lsClientLogger = LSClientLogger.getInstance((LanguageServerContext)serverContext);
    }

    public Class<?> getRemoteInterface() {
        return null;
    }

    @JsonRequest
    public CompletableFuture<VisibleVariableTypesResponse> visibleVariableTypes(VisibleVariableTypeRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            VisibleVariableTypesResponse response = new VisibleVariableTypesResponse();
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                this.workspaceManagerProxy.get().loadProject(filePath);
                DocumentContext documentContext = new DocumentContext(this.workspaceManagerProxy, filePath);
                Optional semanticModel = documentContext.semanticModel();
                Document document = documentContext.document();
                if (semanticModel.isEmpty()) {
                    return response;
                }
                VisibleVariableTypesGenerator visibleVariableTypesGenerator = new VisibleVariableTypesGenerator((SemanticModel)semanticModel.get(), document, CommonUtils.getPosition((LinePosition)request.position(), (Document)document));
                JsonArray visibleVariableTypes = visibleVariableTypesGenerator.getVisibleVariableTypes();
                response.setCategories(visibleVariableTypes);
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> types(ExpressionEditorTypesRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                DocumentContext documentContext = new DocumentContext(this.workspaceManagerProxy, filePath);
                return TypesGenerator.getInstance().getTypes(documentContext, request.typeConstraint(), request.position());
            }
            catch (Throwable e) {
                return Either.forRight((Object)new CompletionList());
            }
        });
    }

    @JsonRequest
    public CompletableFuture<SignatureHelp> signatureHelp(ExpressionEditorSignatureRequest request) {
        String fileUri = CommonUtils.getExprUri((String)request.filePath());
        return Debouncer.getInstance().debounce((DebouncedExpressionEditorRequest)new SignatureHelpRequest(new ExpressionEditorContext(this.workspaceManagerProxy, fileUri, request.context(), Path.of(request.filePath(), new String[0])), request.signatureHelpContext(), this.langServer.getTextDocumentService()));
    }

    @JsonRequest
    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(ExpressionEditorCompletionRequest request) {
        String fileUri = CommonUtils.getExprUri((String)request.filePath());
        return Debouncer.getInstance().debounce((DebouncedExpressionEditorRequest)new CompletionRequest(new ExpressionEditorContext(this.workspaceManagerProxy, fileUri, request.context(), Path.of(request.filePath(), new String[0])), request.completionContext(), this.langServer.getTextDocumentService()));
    }

    @JsonRequest
    public CompletableFuture<DiagnosticsRequest.Diagnostics> diagnostics(ExpressionEditorDiagnosticsRequest request) {
        String fileUri = CommonUtils.getExprUri((String)request.filePath());
        return Debouncer.getInstance().debounce((DebouncedExpressionEditorRequest)DiagnosticsRequest.from((ExpressionEditorContext)new ExpressionEditorContext(this.workspaceManagerProxy, fileUri, request.context(), Path.of(request.filePath(), new String[0]))));
    }

    @JsonRequest
    public CompletableFuture<FunctionCallTemplateResponse> functionCallTemplate(FunctionCallTemplateRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            FunctionCallTemplateResponse response = new FunctionCallTemplateResponse();
            try {
                Object template;
                Codedata codedata = request.codedata();
                switch (request.kind()) {
                    case CURRENT: {
                        template = codedata.symbol();
                        break;
                    }
                    case IMPORTED: {
                        response.setPrefix(codedata.getModulePrefix());
                        response.setModuleId(codedata.getModuleId());
                        template = codedata.getModulePrefix() + ":" + codedata.symbol();
                        break;
                    }
                    case AVAILABLE: {
                        template = codedata.getModulePrefix() + ":" + codedata.symbol();
                        this.applyModuleImport(request.filePath(), codedata.getModuleId(), codedata.getImportSignature(), response);
                        break;
                    }
                    default: {
                        response.setError(new IllegalArgumentException("Invalid kind: " + String.valueOf((Object)request.kind()) + ". Expected kinds are: CURRENT, IMPORTED, AVAILABLE."));
                        return response;
                    }
                }
                if (request.searchKind() != null && request.searchKind().equals("TYPE")) {
                    response.setTemplate((String)template);
                } else {
                    response.setTemplate((String)template + "(${1})");
                }
            }
            catch (Exception e) {
                response.setError(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<ImportModuleResponse> importModule(ImportModuleRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            ImportModuleResponse response = new ImportModuleResponse();
            try {
                String importStatement = request.importStatement().replaceFirst("^import\\s+", "").replaceAll(";\\n?$", "");
                this.applyModuleImport(request.filePath(), importStatement, importStatement, response);
            }
            catch (Exception e) {
                response.setError(e);
            }
            return response;
        });
    }

    private void applyModuleImport(String filePathString, String moduleId, String importStatement, ImportModuleResponse response) {
        String fileUri = CommonUtils.getExprUri((String)filePathString);
        Path filePath = Path.of(filePathString, new String[0]);
        ExpressionEditorContext expressionEditorContext = new ExpressionEditorContext(this.workspaceManagerProxy, fileUri, filePath, null);
        Optional importTextEdit = expressionEditorContext.getImport(importStatement);
        importTextEdit.ifPresent(textEdit -> {
            expressionEditorContext.applyTextEdits(List.of(textEdit));
            PackageUtil.pullModuleAndNotify((LSClientLogger)this.lsClientLogger, (ModuleInfo)ModuleInfo.from((String)moduleId));
        });
        String[] split = importStatement.split("/");
        Project project = (Project)expressionEditorContext.documentContext().project().orElseThrow();
        project.currentPackage().getResolution(COMPILATION_OPTIONS);
        Module module = (Module)expressionEditorContext.documentContext().module().orElseThrow();
        ModuleDescriptor descriptor = module.moduleDependencies().stream().map(ModuleDependency::descriptor).filter(moduleDependencyDescriptor -> moduleDependencyDescriptor.org().value().equals(split[0]) && moduleDependencyDescriptor.packageName().value().equals(split[1])).findFirst().orElseThrow(() -> new IllegalArgumentException("Module not found for: " + importStatement));
        response.setPrefix(CommonUtils.getDefaultModulePrefix((String)descriptor.packageName().value()));
        response.setModuleId(CommonUtils.constructModuleId((ModuleDescriptor)descriptor));
    }
}

