/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.extension;

import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.flowmodelgenerator.extension.request.CreateFilesRequest;
import io.ballerina.flowmodelgenerator.extension.response.CommonSourceResponse;
import io.ballerina.flowmodelgenerator.extension.response.ICPEnabledResponse;
import io.ballerina.projects.BallerinaToml;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.toml.semantic.ast.TomlKeyValueNode;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.eclipse.lsp4j.services.LanguageServer;

@JsonSegment(value="icpService")
public class ICPEnablerService
implements ExtendedLanguageServerService {
    private static final String LS = System.lineSeparator();
    private static final String BALLERINAX = "ballerinax";
    private static final String MODULE_NAME = "wso2.controlplane";
    private static final String IMPORT_STMT = "import ballerinax/wso2.controlplane as _;%n";
    private static final String REMOTE_MANAGEMENT_TRUE = "remoteManagement = true";
    private static final String REMOTE_MANAGEMENT_FALSE = "remoteManagement = false";
    private static final String BUILD_OPTIONS = "%n%n[build-options]%n";
    private WorkspaceManager workspaceManager;

    public void init(LanguageServer langServer, WorkspaceManager workspaceManager) {
        this.workspaceManager = workspaceManager;
    }

    @JsonRequest
    public CompletableFuture<ICPEnabledResponse> isIcpEnabled(CreateFilesRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            ICPEnabledResponse response = new ICPEnabledResponse();
            try {
                TomlKeyValueNode keyValueNode;
                String value;
                TomlTableNode buildOptions;
                TopLevelNode icpNode;
                Path filePath = Path.of(request.projectPath(), new String[0]);
                Project project = this.workspaceManager.loadProject(filePath);
                Package pkg = project.currentPackage();
                Module defaultModule = pkg.getDefaultModule();
                Collection documentIds = defaultModule.documentIds();
                boolean hasCorrectImport = false;
                block2: for (DocumentId documentId : documentIds) {
                    if (hasCorrectImport) break;
                    Document document = defaultModule.document(documentId);
                    ModulePartNode root = (ModulePartNode)document.syntaxTree().rootNode();
                    NodeList imports = root.imports();
                    for (ImportDeclarationNode importNode : imports) {
                        if (!ICPEnablerService.validOrg(importNode) || !ICPEnablerService.validModuleName(importNode) || !ICPEnablerService.validPrefix(importNode)) continue;
                        hasCorrectImport = true;
                        continue block2;
                    }
                }
                if (!hasCorrectImport) {
                    response.setEnabled(false);
                    return response;
                }
                Optional ballerinaToml = pkg.ballerinaToml();
                if (ballerinaToml.isEmpty()) {
                    throw new RuntimeException("Ballerina.toml not found");
                }
                TomlTableNode tomlTableNode = ((BallerinaToml)ballerinaToml.get()).tomlAstNode();
                TopLevelNode topLevelNode = (TopLevelNode)tomlTableNode.entries().get("build-options");
                if (topLevelNode instanceof TomlTableNode && (icpNode = (TopLevelNode)(buildOptions = (TomlTableNode)topLevelNode).entries().get("remoteManagement")) instanceof TomlKeyValueNode && (value = (keyValueNode = (TomlKeyValueNode)icpNode).value().toNativeValue().toString()).trim().equals("true")) {
                    response.setEnabled(true);
                    return response;
                }
                response.setEnabled(false);
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<CommonSourceResponse> addICP(CreateFilesRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            CommonSourceResponse response = new CommonSourceResponse();
            try {
                Optional ballerinaToml;
                Object document;
                Path filePath = Path.of(request.projectPath(), new String[0]);
                Project project = this.workspaceManager.loadProject(filePath);
                Package pkg = project.currentPackage();
                Module defaultModule = pkg.getDefaultModule();
                Collection documentIds = defaultModule.documentIds();
                boolean hasCorrectImport = false;
                block2: for (DocumentId documentId : documentIds) {
                    if (hasCorrectImport) break;
                    document = defaultModule.document(documentId);
                    ModulePartNode root = (ModulePartNode)document.syntaxTree().rootNode();
                    NodeList imports = root.imports();
                    for (ImportDeclarationNode importNode : imports) {
                        if (!ICPEnablerService.validOrg(importNode) || !ICPEnablerService.validModuleName(importNode) || !ICPEnablerService.validPrefix(importNode)) continue;
                        hasCorrectImport = true;
                        continue block2;
                    }
                }
                HashMap<String, List<TextEdit>> textEdits = new HashMap<String, List<TextEdit>>();
                response.setTextEdits(textEdits);
                if (!hasCorrectImport) {
                    Path mainPath = project.sourceRoot().resolve("main.bal");
                    document = this.workspaceManager.document(mainPath);
                    if (((Optional)document).isEmpty()) {
                        throw new RuntimeException("main.bal not found");
                    }
                    Node node = ((Document)((Optional)document).get()).syntaxTree().rootNode();
                    TextEdit edit = new TextEdit(PositionUtil.toRange((LinePosition)node.lineRange().startLine()), IMPORT_STMT.formatted(new Object[0]));
                    textEdits.put(mainPath.toString(), List.of(edit));
                }
                if ((ballerinaToml = pkg.ballerinaToml()).isEmpty()) {
                    throw new RuntimeException("Ballerina.toml not found");
                }
                Path tomlPath = project.sourceRoot().resolve("Ballerina.toml");
                TomlTableNode tomlTableNode = ((BallerinaToml)ballerinaToml.get()).tomlAstNode();
                TopLevelNode topLevelNode = (TopLevelNode)tomlTableNode.entries().get("build-options");
                if (topLevelNode instanceof TomlTableNode) {
                    TomlTableNode buildOptions = (TomlTableNode)topLevelNode;
                    TopLevelNode icpNode = (TopLevelNode)buildOptions.entries().get("remoteManagement");
                    if (icpNode instanceof TomlKeyValueNode) {
                        TomlKeyValueNode keyValueNode = (TomlKeyValueNode)icpNode;
                        String value = keyValueNode.value().toNativeValue().toString();
                        if (value.trim().equals("true")) {
                            return response;
                        }
                        TextEdit edit = new TextEdit(PositionUtil.toRange((LineRange)icpNode.location().lineRange()), REMOTE_MANAGEMENT_TRUE);
                        textEdits.put(tomlPath.toString(), List.of(edit));
                    } else {
                        TextEdit edit = new TextEdit(PositionUtil.toRange((LinePosition)buildOptions.location().lineRange().endLine()), REMOTE_MANAGEMENT_TRUE + LS);
                        textEdits.put(tomlPath.toString(), List.of(edit));
                    }
                } else {
                    TextEdit edit = new TextEdit(PositionUtil.toRange((LinePosition)tomlTableNode.location().lineRange().endLine()), BUILD_OPTIONS.formatted(new Object[0]) + REMOTE_MANAGEMENT_TRUE + LS);
                    textEdits.put(tomlPath.toString(), List.of(edit));
                }
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<CommonSourceResponse> disableICP(CreateFilesRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            CommonSourceResponse response = new CommonSourceResponse();
            try {
                TomlTableNode buildOptions;
                TopLevelNode icpNode;
                Optional ballerinaToml;
                Path filePath = Path.of(request.projectPath(), new String[0]);
                Project project = this.workspaceManager.loadProject(filePath);
                Package pkg = project.currentPackage();
                Module defaultModule = pkg.getDefaultModule();
                Collection documentIds = defaultModule.documentIds();
                boolean hasCorrectImport = false;
                HashMap<String, List<TextEdit>> textEdits = new HashMap<String, List<TextEdit>>();
                response.setTextEdits(textEdits);
                block2: for (DocumentId documentId : documentIds) {
                    if (hasCorrectImport) break;
                    Document document = defaultModule.document(documentId);
                    ModulePartNode root = (ModulePartNode)document.syntaxTree().rootNode();
                    NodeList imports = root.imports();
                    for (ImportDeclarationNode importNode : imports) {
                        if (!ICPEnablerService.validOrg(importNode) || !ICPEnablerService.validModuleName(importNode) || !ICPEnablerService.validPrefix(importNode)) continue;
                        hasCorrectImport = true;
                        Path path = project.sourceRoot().resolve(importNode.lineRange().fileName());
                        textEdits.put(path.toString(), List.of(new TextEdit(PositionUtil.toRange((LineRange)importNode.location().lineRange()), "")));
                        continue block2;
                    }
                }
                if ((ballerinaToml = pkg.ballerinaToml()).isEmpty()) {
                    throw new RuntimeException("Ballerina.toml not found");
                }
                Path tomlPath = project.sourceRoot().resolve("Ballerina.toml");
                TomlTableNode tomlTableNode = ((BallerinaToml)ballerinaToml.get()).tomlAstNode();
                TopLevelNode topLevelNode = (TopLevelNode)tomlTableNode.entries().get("build-options");
                if (topLevelNode instanceof TomlTableNode && (icpNode = (TopLevelNode)(buildOptions = (TomlTableNode)topLevelNode).entries().get("remoteManagement")) instanceof TomlKeyValueNode) {
                    TomlKeyValueNode keyValueNode = (TomlKeyValueNode)icpNode;
                    if (buildOptions.entries().size() == 1) {
                        TextEdit edit = new TextEdit(PositionUtil.toRange((LineRange)buildOptions.location().lineRange()), "");
                        textEdits.put(tomlPath.toString(), List.of(edit));
                    } else {
                        String value = keyValueNode.value().toNativeValue().toString();
                        if (value.trim().equals("true")) {
                            TextEdit edit = new TextEdit(PositionUtil.toRange((LineRange)icpNode.location().lineRange()), "");
                            textEdits.put(tomlPath.toString(), List.of(edit));
                        }
                    }
                }
            }
            catch (Throwable e) {
                response.setError(e);
            }
            return response;
        });
    }

    private static boolean validOrg(ImportDeclarationNode importNode) {
        Optional importOrgNameNode = importNode.orgName();
        return importOrgNameNode.isPresent() && ((ImportOrgNameNode)importOrgNameNode.get()).orgName().text().trim().equals(BALLERINAX);
    }

    private static boolean validModuleName(ImportDeclarationNode importNode) {
        SeparatedNodeList identifierTokens = importNode.moduleName();
        return identifierTokens.stream().map(Node::toSourceCode).map(String::trim).collect(Collectors.joining(".")).equals(MODULE_NAME);
    }

    private static boolean validPrefix(ImportDeclarationNode importNode) {
        Optional prefix = importNode.prefix();
        return prefix.isPresent() && ((ImportPrefixNode)prefix.get()).prefix().text().trim().equals("_");
    }

    public Class<?> getRemoteInterface() {
        return null;
    }
}

