/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter;

import com.sun.jdi.Field;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.request.EventRequestManager;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.identifier.Utils;
import io.ballerina.projects.Project;
import io.ballerina.projects.directory.SingleFileProject;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.ballerinalang.debugadapter.BallerinaExtendedDebugServer;
import org.ballerinalang.debugadapter.BallerinaStackFrame;
import org.ballerinalang.debugadapter.BreakpointProcessor;
import org.ballerinalang.debugadapter.DebugExecutionManager;
import org.ballerinalang.debugadapter.DebugInstruction;
import org.ballerinalang.debugadapter.DebugOutputLogger;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.ExecutionContext;
import org.ballerinalang.debugadapter.JDIEventProcessor;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.breakpoint.BalBreakpoint;
import org.ballerinalang.debugadapter.completion.CompletionGenerator;
import org.ballerinalang.debugadapter.completion.context.CompletionContext;
import org.ballerinalang.debugadapter.completion.util.CompletionUtil;
import org.ballerinalang.debugadapter.config.ClientAttachConfigHolder;
import org.ballerinalang.debugadapter.config.ClientConfigHolder;
import org.ballerinalang.debugadapter.config.ClientConfigurationException;
import org.ballerinalang.debugadapter.config.ClientLaunchConfigHolder;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.DebugExpressionEvaluator;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.jdi.JDIUtils;
import org.ballerinalang.debugadapter.jdi.JdiProxyException;
import org.ballerinalang.debugadapter.jdi.LocalVariableProxyImpl;
import org.ballerinalang.debugadapter.jdi.StackFrameProxyImpl;
import org.ballerinalang.debugadapter.jdi.ThreadReferenceProxyImpl;
import org.ballerinalang.debugadapter.jdi.VirtualMachineProxyImpl;
import org.ballerinalang.debugadapter.runner.BPackageRunner;
import org.ballerinalang.debugadapter.runner.BProgramRunner;
import org.ballerinalang.debugadapter.runner.BSingleFileRunner;
import org.ballerinalang.debugadapter.utils.PackageUtils;
import org.ballerinalang.debugadapter.utils.ServerUtils;
import org.ballerinalang.debugadapter.variable.BCompoundVariable;
import org.ballerinalang.debugadapter.variable.BSimpleVariable;
import org.ballerinalang.debugadapter.variable.BVariable;
import org.ballerinalang.debugadapter.variable.BVariableType;
import org.ballerinalang.debugadapter.variable.IndexedCompoundVariable;
import org.ballerinalang.debugadapter.variable.NamedCompoundVariable;
import org.ballerinalang.debugadapter.variable.VariableFactory;
import org.ballerinalang.debugadapter.variable.VariableUtils;
import org.eclipse.lsp4j.debug.Breakpoint;
import org.eclipse.lsp4j.debug.Capabilities;
import org.eclipse.lsp4j.debug.CompletionItem;
import org.eclipse.lsp4j.debug.CompletionsArguments;
import org.eclipse.lsp4j.debug.CompletionsResponse;
import org.eclipse.lsp4j.debug.ConfigurationDoneArguments;
import org.eclipse.lsp4j.debug.ContinueArguments;
import org.eclipse.lsp4j.debug.ContinueResponse;
import org.eclipse.lsp4j.debug.ContinuedEventArguments;
import org.eclipse.lsp4j.debug.DisconnectArguments;
import org.eclipse.lsp4j.debug.EvaluateArguments;
import org.eclipse.lsp4j.debug.EvaluateResponse;
import org.eclipse.lsp4j.debug.ExitedEventArguments;
import org.eclipse.lsp4j.debug.InitializeRequestArguments;
import org.eclipse.lsp4j.debug.NextArguments;
import org.eclipse.lsp4j.debug.OutputEventArguments;
import org.eclipse.lsp4j.debug.PauseArguments;
import org.eclipse.lsp4j.debug.RestartArguments;
import org.eclipse.lsp4j.debug.RunInTerminalRequestArguments;
import org.eclipse.lsp4j.debug.RunInTerminalResponse;
import org.eclipse.lsp4j.debug.Scope;
import org.eclipse.lsp4j.debug.ScopesArguments;
import org.eclipse.lsp4j.debug.ScopesResponse;
import org.eclipse.lsp4j.debug.SetBreakpointsArguments;
import org.eclipse.lsp4j.debug.SetBreakpointsResponse;
import org.eclipse.lsp4j.debug.SetExceptionBreakpointsArguments;
import org.eclipse.lsp4j.debug.SourceArguments;
import org.eclipse.lsp4j.debug.SourceResponse;
import org.eclipse.lsp4j.debug.StackFrame;
import org.eclipse.lsp4j.debug.StackTraceArguments;
import org.eclipse.lsp4j.debug.StackTraceResponse;
import org.eclipse.lsp4j.debug.StepInArguments;
import org.eclipse.lsp4j.debug.StepOutArguments;
import org.eclipse.lsp4j.debug.TerminateArguments;
import org.eclipse.lsp4j.debug.ThreadsResponse;
import org.eclipse.lsp4j.debug.Variable;
import org.eclipse.lsp4j.debug.VariablesArguments;
import org.eclipse.lsp4j.debug.VariablesResponse;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.services.GenericEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBallerinaDebugServer
implements BallerinaExtendedDebugServer {
    private IDebugProtocolClient client;
    private ClientConfigHolder clientConfigHolder;
    private DebugExecutionManager executionManager;
    private JDIEventProcessor eventProcessor;
    private final ExecutionContext context;
    private SuspendedContext suspendedContext;
    private DebugOutputLogger outputLogger;
    private DebugExpressionEvaluator evaluator;
    private ThreadReferenceProxyImpl activeThread;
    private final AtomicInteger nextVarReference = new AtomicInteger(1);
    private final Map<Integer, StackFrameProxyImpl> stackFrames = new HashMap<Integer, StackFrameProxyImpl>();
    private final Map<Long, StackFrame[]> threadStackTraces = new HashMap<Long, StackFrame[]>();
    private final Map<Integer, Integer> scopeIdToFrameIds = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> variableToStackFrames = new ConcurrentHashMap<Integer, Integer>();
    private final Map<Integer, BCompoundVariable> loadedCompoundVariables = new ConcurrentHashMap<Integer, BCompoundVariable>();
    private final ExecutorService variableExecutor = Executors.newSingleThreadExecutor();
    private static final String SCOPE_NAME_LOCAL = "Local";
    private static final String SCOPE_NAME_GLOBAL = "Global";
    private static final String VALUE_UNKNOWN = "unknown";
    private static final String EVAL_ARGS_CONTEXT_VARIABLES = "variables";
    private static final String COMPILATION_ERROR_MESSAGE = "error: compilation contains errors";
    private static final String TERMINAL_TITLE = "Ballerina Debug Terminal";
    private static final String RUN_IN_TERMINAL_REQUEST = "runInTerminal";
    private static final int VARIABLE_FETCH_TIMEOUT = 2000;
    private static final Logger LOGGER = LoggerFactory.getLogger(JBallerinaDebugServer.class);

    public JBallerinaDebugServer() {
        this.context = new ExecutionContext(this);
    }

    public ExecutionContext getContext() {
        return this.context;
    }

    public ClientConfigHolder getClientConfigHolder() {
        return this.clientConfigHolder;
    }

    public DebugOutputLogger getOutputLogger() {
        return this.outputLogger;
    }

    public CompletableFuture<Capabilities> initialize(InitializeRequestArguments args) {
        Capabilities capabilities = new Capabilities();
        capabilities.setSupportsConfigurationDoneRequest(Boolean.valueOf(true));
        capabilities.setSupportsTerminateRequest(Boolean.valueOf(true));
        capabilities.setSupportTerminateDebuggee(Boolean.valueOf(true));
        capabilities.setSupportsConditionalBreakpoints(Boolean.valueOf(true));
        capabilities.setSupportsLogPoints(Boolean.valueOf(true));
        capabilities.setSupportsCompletionsRequest(Boolean.valueOf(true));
        capabilities.setCompletionTriggerCharacters((String[])CompletionUtil.getTriggerCharacters().toArray(String[]::new));
        capabilities.setSupportsRestartRequest(Boolean.valueOf(true));
        capabilities.setSupportsHitConditionalBreakpoints(Boolean.valueOf(false));
        capabilities.setSupportsModulesRequest(Boolean.valueOf(false));
        capabilities.setSupportsStepBack(Boolean.valueOf(false));
        capabilities.setSupportsTerminateThreadsRequest(Boolean.valueOf(false));
        capabilities.setSupportsFunctionBreakpoints(Boolean.valueOf(false));
        capabilities.setSupportsExceptionOptions(Boolean.valueOf(false));
        capabilities.setSupportsExceptionFilterOptions(Boolean.valueOf(false));
        capabilities.setSupportsExceptionInfoRequest(Boolean.valueOf(false));
        this.context.setSupportsRunInTerminalRequest(args.getSupportsRunInTerminalRequest() != null && args.getSupportsRunInTerminalRequest() != false);
        this.eventProcessor = new JDIEventProcessor(this.context);
        this.outputLogger = new DebugOutputLogger(this.client);
        this.context.setClient(this.client);
        this.client.initialized();
        return CompletableFuture.completedFuture(capabilities);
    }

    public CompletableFuture<SetBreakpointsResponse> setBreakpoints(SetBreakpointsArguments args) {
        return CompletableFuture.supplyAsync(() -> {
            SetBreakpointsResponse bpResponse = new SetBreakpointsResponse();
            if (ServerUtils.isNoDebugMode(this.context)) {
                return bpResponse;
            }
            BalBreakpoint[] balBreakpoints = (BalBreakpoint[])Arrays.stream(args.getBreakpoints()).map(sourceBreakpoint -> ServerUtils.toBalBreakpoint(this.context, sourceBreakpoint, args.getSource())).toArray(BalBreakpoint[]::new);
            LinkedHashMap<Integer, BalBreakpoint> breakpointsMap = new LinkedHashMap<Integer, BalBreakpoint>();
            for (BalBreakpoint bp : balBreakpoints) {
                breakpointsMap.put(bp.getLine(), bp);
            }
            String sourcePathUri = args.getSource().getPath();
            Optional<String> qualifiedClassName = PackageUtils.getQualifiedClassName(this.context, sourcePathUri);
            if (qualifiedClassName.isEmpty()) {
                LOGGER.warn("Failed to set breakpoints. Source path is not a valid Ballerina source: " + sourcePathUri);
                return bpResponse;
            }
            this.eventProcessor.enableBreakpoints(qualifiedClassName.get(), breakpointsMap);
            BreakpointProcessor bpProcessor = this.eventProcessor.getBreakpointProcessor();
            Map userBpMap = bpProcessor.getUserBreakpoints().get(qualifiedClassName.get());
            if (userBpMap == null) {
                LOGGER.warn("Failed to set breakpoints for source: " + sourcePathUri);
                return bpResponse;
            }
            Breakpoint[] breakpoints = (Breakpoint[])userBpMap.values().stream().map(BalBreakpoint::getAsDAPBreakpoint).toArray(Breakpoint[]::new);
            bpResponse.setBreakpoints(breakpoints);
            return bpResponse;
        });
    }

    public CompletableFuture<Void> configurationDone(ConfigurationDoneArguments args) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> launch(Map<String, Object> args) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.clientConfigHolder = new ClientLaunchConfigHolder(args);
                this.launchDebuggeeProgram();
                return null;
            }
            catch (Exception e) {
                this.outputLogger.sendErrorOutput("Failed to launch the Ballerina program due to: " + e.getMessage());
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<Void> attach(Map<String, Object> args) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.clientConfigHolder = new ClientAttachConfigHolder(args);
                this.context.setDebugMode(ExecutionContext.DebugMode.ATTACH);
                Project srcProject = this.context.getProjectCache().getProject(Path.of(this.clientConfigHolder.getSourcePath(), new String[0]));
                this.context.setSourceProject(srcProject);
                ClientAttachConfigHolder configHolder = (ClientAttachConfigHolder)this.clientConfigHolder;
                String hostName = configHolder.getHostName().orElse("");
                int portName = configHolder.getDebuggePort();
                this.attachToRemoteVM(hostName, portName);
                return null;
            }
            catch (Exception e) {
                String errorMessage = this.getAttachmentErrorMessage(e);
                this.outputLogger.sendErrorOutput(errorMessage);
                this.terminateDebugSession(this.context.getDebuggeeVM() != null, false);
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<ThreadsResponse> threads() {
        ThreadsResponse threadsResponse = new ThreadsResponse();
        if (this.eventProcessor == null) {
            return CompletableFuture.completedFuture(threadsResponse);
        }
        Map<Integer, ThreadReferenceProxyImpl> threadsMap = this.getActiveStrandThreads();
        if (threadsMap == null) {
            return CompletableFuture.completedFuture(threadsResponse);
        }
        org.eclipse.lsp4j.debug.Thread[] threads = new org.eclipse.lsp4j.debug.Thread[threadsMap.size()];
        threadsMap.values().stream().map(this::toDapThread).toList().toArray(threads);
        threadsResponse.setThreads(threads);
        return CompletableFuture.completedFuture(threadsResponse);
    }

    public CompletableFuture<Void> pause(PauseArguments args) {
        VirtualMachineProxyImpl debuggeeVM = this.context.getDebuggeeVM();
        if (!debuggeeVM.canBeModified()) {
            this.getOutputLogger().sendDebugServerOutput("Failed to suspend the remote VM due to: pause requests are not supported on read-only VMs");
            return CompletableFuture.completedFuture(null);
        }
        debuggeeVM.suspend();
        this.eventProcessor.notifyStopEvent("pause", args.getThreadId());
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<StackTraceResponse> stackTrace(StackTraceArguments args) {
        StackTraceResponse stackTraceResponse = new StackTraceResponse();
        try {
            this.activeThread = this.getAllThreads().get(args.getThreadId());
            if (this.threadStackTraces.containsKey(this.activeThread.uniqueID())) {
                stackTraceResponse.setStackFrames(this.threadStackTraces.get(this.activeThread.uniqueID()));
            } else {
                StackFrame[] validFrames = (StackFrame[])this.activeThread.frames().stream().map(this::toDapStackFrame).filter(ServerUtils::isValidFrame).toArray(StackFrame[]::new);
                stackTraceResponse.setStackFrames(validFrames);
                this.threadStackTraces.put(this.activeThread.uniqueID(), validFrames);
            }
            return CompletableFuture.completedFuture(stackTraceResponse);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            stackTraceResponse.setStackFrames(new StackFrame[0]);
            return CompletableFuture.completedFuture(stackTraceResponse);
        }
    }

    public CompletableFuture<ScopesResponse> scopes(ScopesArguments args) {
        Scope localScope = new Scope();
        localScope.setName(SCOPE_NAME_LOCAL);
        this.scopeIdToFrameIds.put(this.nextVarReference.get(), args.getFrameId());
        localScope.setVariablesReference(this.nextVarReference.getAndIncrement());
        Scope globalScope = new Scope();
        globalScope.setName(SCOPE_NAME_GLOBAL);
        this.scopeIdToFrameIds.put(this.nextVarReference.get(), -args.getFrameId());
        globalScope.setVariablesReference(this.nextVarReference.getAndIncrement());
        Scope[] scopes = new Scope[]{localScope, globalScope};
        ScopesResponse scopesResponse = new ScopesResponse();
        scopesResponse.setScopes(scopes);
        return CompletableFuture.completedFuture(scopesResponse);
    }

    public CompletableFuture<VariablesResponse> variables(VariablesArguments args) {
        VariablesResponse variablesResponse = new VariablesResponse();
        try {
            Integer frameId = this.scopeIdToFrameIds.get(args.getVariablesReference());
            if (frameId == null) {
                variablesResponse.setVariables(this.computeChildVariables(args));
                return CompletableFuture.completedFuture(variablesResponse);
            }
            StackFrameProxyImpl stackFrame = this.stackFrames.get(Math.abs(frameId));
            if (stackFrame == null) {
                variablesResponse.setVariables(new Variable[0]);
                return CompletableFuture.completedFuture(variablesResponse);
            }
            this.suspendedContext = new SuspendedContext(this.context, this.activeThread, stackFrame);
            if (frameId < 0) {
                variablesResponse.setVariables(this.computeGlobalScopeVariables(args));
            } else {
                variablesResponse.setVariables(this.computeLocalScopeVariables(args));
            }
            return CompletableFuture.completedFuture(variablesResponse);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            variablesResponse.setVariables(new Variable[0]);
            return CompletableFuture.completedFuture(variablesResponse);
        }
    }

    public CompletableFuture<SourceResponse> source(SourceArguments args) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<ContinueResponse> continue_(ContinueArguments args) {
        this.prepareFor(DebugInstruction.CONTINUE, args.getThreadId());
        this.context.getDebuggeeVM().resume();
        ContinueResponse continueResponse = new ContinueResponse();
        continueResponse.setAllThreadsContinued(Boolean.valueOf(true));
        return CompletableFuture.completedFuture(continueResponse);
    }

    public CompletableFuture<Void> next(NextArguments args) {
        this.prepareFor(DebugInstruction.STEP_OVER, args.getThreadId());
        this.eventProcessor.sendStepRequest(args.getThreadId(), 2);
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> stepIn(StepInArguments args) {
        this.prepareFor(DebugInstruction.STEP_IN, args.getThreadId());
        this.eventProcessor.sendStepRequest(args.getThreadId(), 1);
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> stepOut(StepOutArguments args) {
        this.prepareFor(DebugInstruction.STEP_OUT, args.getThreadId());
        this.eventProcessor.sendStepRequest(args.getThreadId(), 3);
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> restart(RestartArguments args) {
        if (this.context.getDebugMode() == ExecutionContext.DebugMode.ATTACH) {
            this.outputLogger.sendErrorOutput("Restart operation is not supported in remote debug mode.");
            return CompletableFuture.completedFuture(null);
        }
        try {
            this.resetServer();
            this.launchDebuggeeProgram();
        }
        catch (Exception e) {
            LOGGER.error("Failed to restart the Ballerina program due to: {}", (Object)e.getMessage(), (Object)e);
            this.outputLogger.sendErrorOutput("Failed to restart the Ballerina program");
            this.terminateDebugSession(this.context.getDebuggeeVM() != null, true);
        }
        return CompletableFuture.completedFuture(null);
    }

    private void launchDebuggeeProgram() throws Exception {
        this.context.setDebugMode(ExecutionContext.DebugMode.LAUNCH);
        Project sourceProject = this.context.getProjectCache().getProject(Path.of(this.clientConfigHolder.getSourcePath(), new String[0]));
        this.context.setSourceProject(sourceProject);
        String sourceProjectRoot = this.context.getSourceProjectRoot();
        if (ServerUtils.isFastRunEnabled(this.context)) {
            int port = ServerUtils.findFreePort();
            this.outputLogger.sendDebugServerOutput("Waiting for the debug process to start...%s%s".formatted(System.lineSeparator(), System.lineSeparator()));
            ServerUtils.sendFastRunNotification(this.context, port);
            this.attachToRemoteVM("localhost", port);
        } else {
            BProgramRunner programRunner;
            BProgramRunner bProgramRunner = programRunner = this.context.getSourceProject() instanceof SingleFileProject ? new BSingleFileRunner((ClientLaunchConfigHolder)this.clientConfigHolder, sourceProjectRoot) : new BPackageRunner((ClientLaunchConfigHolder)this.clientConfigHolder, sourceProjectRoot);
            if (this.context.getSupportsRunInTerminalRequest() && this.clientConfigHolder.getRunInTerminalKind() != null) {
                this.launchInTerminal(programRunner);
            } else {
                Process debuggeeProcess = programRunner.start();
                this.context.setLaunchedProcess(debuggeeProcess);
                this.startListeningToProgramOutput();
            }
        }
    }

    public CompletableFuture<Void> setExceptionBreakpoints(SetExceptionBreakpointsArguments args) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<EvaluateResponse> evaluate(EvaluateArguments args) {
        if (this.executionManager == null || !this.executionManager.isActive()) {
            this.context.getOutputLogger().sendErrorOutput(EvaluationExceptionKind.PREFIX + "Debug server is not connected to any program VM.");
            return CompletableFuture.completedFuture(new EvaluateResponse());
        }
        if (args.getFrameId() == null) {
            this.context.getOutputLogger().sendErrorOutput(EvaluationExceptionKind.PREFIX + "Remote VM is not suspended and still in running state.");
            return CompletableFuture.completedFuture(new EvaluateResponse());
        }
        if (args.getContext() != null && args.getContext().equals(EVAL_ARGS_CONTEXT_VARIABLES)) {
            EvaluateResponse response = new EvaluateResponse();
            response.setResult(args.getExpression());
            return CompletableFuture.completedFuture(response);
        }
        try {
            StackFrameProxyImpl frame = this.stackFrames.get(args.getFrameId());
            SuspendedContext suspendedContext = new SuspendedContext(this.context, this.activeThread, frame);
            EvaluationContext evaluationContext = new EvaluationContext(suspendedContext);
            this.evaluator = Objects.requireNonNullElse(this.evaluator, new DebugExpressionEvaluator(evaluationContext));
            this.evaluator.setExpression(args.getExpression());
            BExpressionValue evaluateResult = this.evaluator.evaluate();
            EvaluateResponse evaluateResponse = this.constructEvaluateResponse(args, evaluateResult.getBVariable());
            return CompletableFuture.completedFuture(evaluateResponse);
        }
        catch (EvaluationException e) {
            this.context.getOutputLogger().sendErrorOutput(e.getMessage());
            return CompletableFuture.completedFuture(new EvaluateResponse());
        }
        catch (Exception e) {
            this.context.getOutputLogger().sendErrorOutput(EvaluationExceptionKind.PREFIX + "internal error");
            return CompletableFuture.completedFuture(new EvaluateResponse());
        }
    }

    public CompletableFuture<CompletionsResponse> completions(CompletionsArguments args) {
        return CompletableFuture.supplyAsync(() -> {
            CompletionsResponse completionsResponse = new CompletionsResponse();
            if (this.suspendedContext == null) {
                return completionsResponse;
            }
            CompletionContext completionContext = new CompletionContext(this.suspendedContext);
            if (!CompletionUtil.triggerCharactersFound(args.getText())) {
                CompletionItem[] visibleSymbolCompletions = CompletionUtil.getVisibleSymbolCompletions(completionContext);
                completionsResponse.setTargets(visibleSymbolCompletions);
                return completionsResponse;
            }
            try {
                NonTerminalNode injectedExpressionNode = CompletionUtil.getInjectedExpressionNode(completionContext, args, this.clientConfigHolder.getSourcePath(), this.suspendedContext.getLineNumber());
                completionContext.setNodeAtCursor(injectedExpressionNode);
                Optional<Node> resolverNode = CompletionUtil.getResolverNode(injectedExpressionNode);
                if (resolverNode.isEmpty()) {
                    return completionsResponse;
                }
                switch (resolverNode.get().kind()) {
                    case FIELD_ACCESS: {
                        CompletionItem[] completionItems = CompletionGenerator.getFieldAccessCompletions(completionContext, resolverNode.get());
                        completionsResponse.setTargets(completionItems);
                        break;
                    }
                    case REMOTE_METHOD_CALL_ACTION: {
                        CompletionItem[] completionItems = CompletionGenerator.getRemoteMethodCallActionCompletions(completionContext, resolverNode.get());
                        completionsResponse.setTargets(completionItems);
                        break;
                    }
                    case ASYNC_SEND_ACTION: {
                        CompletionItem[] completionItems = CompletionGenerator.getAsyncSendActionCompletions(completionContext, resolverNode.get());
                        completionsResponse.setTargets(completionItems);
                        break;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
            }
            return completionsResponse;
        });
    }

    public CompletableFuture<Void> disconnect(DisconnectArguments args) {
        this.context.setTerminateRequestReceived(true);
        boolean terminateDebuggee = Objects.requireNonNullElse(args.getTerminateDebuggee(), true);
        this.terminateDebugSession(terminateDebuggee, true);
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> terminate(TerminateArguments args) {
        this.context.setTerminateRequestReceived(true);
        this.terminateDebugSession(true, true);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> output(OutputEventArguments arguments) {
        switch (arguments.getCategory()) {
            case "stdout": {
                this.outputLogger.sendProgramOutput(arguments.getOutput());
                break;
            }
            case "stderr": {
                this.outputLogger.sendErrorOutput(arguments.getOutput());
                break;
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<RunInTerminalResponse> runInTerminal(RunInTerminalRequestArguments args) {
        GenericEndpoint endPoint = new GenericEndpoint((Object)this.context.getClient());
        endPoint.request(RUN_IN_TERMINAL_REQUEST, (Object)args).thenApply(response -> {
            int tryCounter = 0;
            while (this.context.getDebuggeeVM() == null && tryCounter < 10) {
                try {
                    JDIUtils.sleepMillis(3000L);
                    this.attachToRemoteVM("localhost", this.clientConfigHolder.getDebuggePort());
                }
                catch (IOException ignored) {
                    ++tryCounter;
                }
                catch (IllegalConnectorArgumentsException | ClientConfigurationException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.context.getDebuggeeVM() == null) {
                this.outputLogger.sendErrorOutput("Failed to attach to the target VM");
                this.terminateDebugSession(false, true);
                int shellProcessId = ((RunInTerminalResponse)response).getShellProcessId();
                ProcessHandle.of(shellProcessId).ifPresent(ProcessHandle::destroyForcibly);
            } else {
                this.outputLogger.sendDebugServerOutput("Attached to target VM");
            }
            return CompletableFuture.completedFuture(null);
        });
        return CompletableFuture.completedFuture(null);
    }

    private void launchInTerminal(BProgramRunner programRunner) throws ClientConfigurationException {
        String sourceProjectRoot = this.context.getSourceProjectRoot();
        RunInTerminalRequestArguments runInTerminalRequestArguments = new RunInTerminalRequestArguments();
        runInTerminalRequestArguments.setKind(this.clientConfigHolder.getRunInTerminalKind());
        runInTerminalRequestArguments.setTitle(TERMINAL_TITLE);
        runInTerminalRequestArguments.setCwd(sourceProjectRoot);
        String[] command = new String[programRunner.getBallerinaCommand(sourceProjectRoot).size()];
        programRunner.getBallerinaCommand(sourceProjectRoot).toArray(command);
        runInTerminalRequestArguments.setArgs(command);
        this.outputLogger.sendDebugServerOutput("Launching debugger in terminal");
        this.context.getAdapter().runInTerminal(runInTerminalRequestArguments);
    }

    void terminateDebugSession(boolean shouldTerminateDebuggee, boolean enableClientLogs) {
        if (this.context.getLaunchedProcess().isPresent() && this.context.getLaunchedProcess().get().isAlive()) {
            JBallerinaDebugServer.killProcessWithDescendants(this.context.getLaunchedProcess().get());
        }
        if (shouldTerminateDebuggee) {
            this.terminateDebuggee();
        }
        if (!this.context.isTerminateRequestReceived()) {
            ExitedEventArguments exitedEventArguments = new ExitedEventArguments();
            exitedEventArguments.setExitCode(0);
            this.context.getClient().exited(exitedEventArguments);
        }
        if (this.executionManager != null && enableClientLogs) {
            this.outputLogger.sendDebugServerOutput(String.format(System.lineSeparator() + "Disconnected from the target VM, address: '%s'", this.executionManager.getRemoteVMAddress()));
        }
        new Thread(() -> {
            JDIUtils.sleepMillis(500L);
            System.exit(0);
        }).start();
    }

    private void terminateDebuggee() {
        if (Objects.isNull(this.context.getDebuggeeVM())) {
            return;
        }
        int exitCode = 0;
        if (this.context.getDebuggeeVM().process() != null) {
            exitCode = JBallerinaDebugServer.killProcessWithDescendants(this.context.getDebuggeeVM().process());
        }
        try {
            this.context.getDebuggeeVM().exit(exitCode);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int killProcessWithDescendants(Process parent) {
        try {
            parent.descendants().forEach(processHandle -> {
                boolean successful = processHandle.destroy();
                if (!successful) {
                    processHandle.destroyForcibly();
                }
            });
            parent.destroyForcibly();
            parent.waitFor();
            return parent.exitValue();
        }
        catch (InterruptedException ignored) {
            return 0;
        }
        catch (Exception e) {
            return 1;
        }
    }

    public void connect(IDebugProtocolClient client) {
        this.client = client;
    }

    private synchronized void updateVariableToStackFrameMap(int parent, int child) {
        Integer parentRef;
        if (!this.variableToStackFrames.containsKey(parent)) {
            this.variableToStackFrames.put(child, parent);
            return;
        }
        while (this.variableToStackFrames.containsKey(parentRef = this.variableToStackFrames.get(parent))) {
        }
        this.variableToStackFrames.put(child, parentRef);
    }

    org.eclipse.lsp4j.debug.Thread toDapThread(ThreadReferenceProxyImpl threadReference) {
        org.eclipse.lsp4j.debug.Thread thread = new org.eclipse.lsp4j.debug.Thread();
        thread.setId((int)threadReference.uniqueID());
        thread.setName(threadReference.name());
        return thread;
    }

    private StackFrame toDapStackFrame(StackFrameProxyImpl stackFrameProxy) {
        try {
            if (!ServerUtils.isBalStackFrame(stackFrameProxy.getStackFrame())) {
                return null;
            }
            int referenceId = this.nextVarReference.getAndIncrement();
            this.stackFrames.put(referenceId, stackFrameProxy);
            BallerinaStackFrame balStackFrame = new BallerinaStackFrame(this.context, referenceId, stackFrameProxy);
            return balStackFrame.getAsDAPStackFrame().orElse(null);
        }
        catch (JdiProxyException e) {
            return null;
        }
    }

    Map<Integer, ThreadReferenceProxyImpl> getAllThreads() {
        if (this.context.getDebuggeeVM() == null) {
            return null;
        }
        List<ThreadReference> threadReferences = this.context.getDebuggeeVM().getVirtualMachine().allThreads();
        HashMap<Integer, ThreadReferenceProxyImpl> threadsMap = new HashMap<Integer, ThreadReferenceProxyImpl>();
        for (ThreadReference threadReference : threadReferences) {
            threadsMap.put((int)threadReference.uniqueID(), new ThreadReferenceProxyImpl(this.context.getDebuggeeVM(), threadReference));
        }
        for (ThreadReference threadReference : this.eventProcessor.getVirtualThreads()) {
            threadsMap.put((int)threadReference.uniqueID(), new ThreadReferenceProxyImpl(this.context.getDebuggeeVM(), threadReference));
        }
        return threadsMap;
    }

    Map<Integer, ThreadReferenceProxyImpl> getActiveStrandThreads() {
        Map<Integer, ThreadReferenceProxyImpl> allThreads = this.getAllThreads();
        if (allThreads == null) {
            return null;
        }
        HashMap<Integer, ThreadReferenceProxyImpl> balStrandThreads = new HashMap<Integer, ThreadReferenceProxyImpl>();
        allThreads.forEach((id, threadProxy) -> {
            ThreadReference threadReference = threadProxy.getThreadReference();
            if (threadReference.status() == 1 && !threadReference.name().equals("Reference Handler") && !threadReference.name().equals("Signal Dispatcher") && threadReference.isSuspended() && ServerUtils.isBalStrand(threadReference)) {
                balStrandThreads.put((Integer)id, new ThreadReferenceProxyImpl(this.context.getDebuggeeVM(), threadReference));
            }
        });
        return balStrandThreads;
    }

    private void startListeningToProgramOutput() {
        CompletableFuture.runAsync(() -> {
            if (this.context.getLaunchedProcess().isEmpty()) {
                return;
            }
            try (BufferedReader errorStream = this.context.getErrorStream();){
                String line;
                while ((line = errorStream.readLine()) != null) {
                    this.outputLogger.sendConsoleOutput(line);
                    if (this.context.getDebuggeeVM() != null || !line.contains(COMPILATION_ERROR_MESSAGE)) continue;
                    this.terminateDebugSession(false, true);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        CompletableFuture.runAsync(() -> {
            if (this.context.getLaunchedProcess().isEmpty()) {
                return;
            }
            try (BufferedReader inputStream = this.context.getInputStream();){
                String line;
                this.outputLogger.sendDebugServerOutput("Waiting for the debug process to start...%s%s".formatted(System.lineSeparator(), System.lineSeparator()));
                while ((line = inputStream.readLine()) != null) {
                    if (line.contains("Listening for transport dt_socket")) {
                        this.attachToRemoteVM("localhost", this.clientConfigHolder.getDebuggePort());
                    } else if (this.context.getDebuggeeVM() == null && line.contains(COMPILATION_ERROR_MESSAGE)) {
                        this.terminateDebugSession(false, true);
                    }
                    this.outputLogger.sendProgramOutput(line);
                }
            }
            catch (Exception e) {
                String portName;
                String string;
                ClientConfigHolder clientConfigHolder = this.clientConfigHolder;
                if (clientConfigHolder instanceof ClientAttachConfigHolder) {
                    ClientAttachConfigHolder clientAttachConfigHolder = (ClientAttachConfigHolder)clientConfigHolder;
                    string = clientAttachConfigHolder.getHostName().orElse("localhost");
                } else {
                    string = "localhost";
                }
                String host = string;
                try {
                    portName = Integer.toString(this.clientConfigHolder.getDebuggePort());
                }
                catch (ClientConfigurationException clientConfigurationException) {
                    portName = VALUE_UNKNOWN;
                }
                LOGGER.error(e.getMessage());
                this.outputLogger.sendDebugServerOutput(String.format("Failed to attach to the target VM, address: '%s:%s'.", host, portName));
                this.terminateDebugSession(this.context.getDebuggeeVM() != null, true);
            }
        });
    }

    private void attachToRemoteVM(String hostName, int portName) throws IOException, IllegalConnectorArgumentsException {
        this.executionManager = new DebugExecutionManager(this);
        VirtualMachine attachedVm = this.executionManager.attach(hostName, portName);
        this.context.setDebuggeeVM(new VirtualMachineProxyImpl(attachedVm));
        EventRequestManager erm = this.context.getEventManager();
        erm.createClassPrepareRequest().enable();
        erm.createThreadStartRequest().enable();
        erm.createThreadDeathRequest().enable();
        this.eventProcessor.startListenAsync();
    }

    private void prepareFor(DebugInstruction instruction, int threadId) {
        this.clearSuspendedState();
        BreakpointProcessor bpProcessor = this.eventProcessor.getBreakpointProcessor();
        DebugInstruction prevInstruction = this.context.getPrevInstruction();
        if (prevInstruction == DebugInstruction.STEP_OVER && instruction == DebugInstruction.CONTINUE) {
            bpProcessor.restoreUserBreakpoints();
        } else if (prevInstruction == DebugInstruction.CONTINUE && instruction == DebugInstruction.STEP_OVER) {
            bpProcessor.activateDynamicBreakPoints(threadId, BreakpointProcessor.DynamicBreakpointMode.CURRENT, false);
        } else if (instruction == DebugInstruction.STEP_OVER) {
            bpProcessor.activateDynamicBreakPoints(threadId, BreakpointProcessor.DynamicBreakpointMode.CURRENT, true);
        }
        this.context.setPrevInstruction(instruction);
    }

    private Variable[] computeGlobalScopeVariables(VariablesArguments requestArgs) {
        int stackFrameReference = requestArgs.getVariablesReference();
        String classQName = PackageUtils.getQualifiedClassName(this.suspendedContext, "$_init");
        List<ReferenceType> cls = this.suspendedContext.getAttachedVm().classesByName(classQName);
        if (cls.size() != 1) {
            return new Variable[0];
        }
        ArrayList<CompletableFuture<Variable>> scheduledVariables = new ArrayList<CompletableFuture<Variable>>();
        ReferenceType initClassReference = cls.get(0);
        for (Field field : initClassReference.allFields()) {
            String fieldName = Utils.decodeIdentifier((String)field.name());
            if (!field.isPublic() || !field.isStatic() || fieldName.startsWith("$")) continue;
            Value fieldValue = initClassReference.getValue(field);
            scheduledVariables.add(this.computeVariableAsync(fieldName, fieldValue, stackFrameReference));
        }
        return (Variable[])scheduledVariables.stream().map(varFuture -> {
            try {
                return (Variable)varFuture.get(2000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                LOGGER.error("Failed to load some debug variables due to runtime exceptions.", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).toArray(Variable[]::new);
    }

    private Variable[] computeLocalScopeVariables(VariablesArguments args) throws Exception {
        StackFrameProxyImpl stackFrame = this.suspendedContext.getFrame();
        ArrayList<CompletableFuture<Variable>> scheduledVariables = new ArrayList<CompletableFuture<Variable>>();
        ArrayList<CompletableFuture<Variable[]>> scheduledLambdaMapVariables = new ArrayList<CompletableFuture<Variable[]>>();
        List<LocalVariableProxyImpl> localVariableProxies = stackFrame.visibleVariables();
        for (LocalVariableProxyImpl var : localVariableProxies) {
            String name = var.name();
            Value value = stackFrame.getValue(var);
            if (VariableUtils.isLambdaParamMap(var)) {
                scheduledLambdaMapVariables.add(this.fetchLocalVariablesFromMap(args, stackFrame, var));
                continue;
            }
            CompletableFuture<Variable> dapVar = this.computeVariableAsync(name, value, args.getVariablesReference());
            scheduledVariables.add(dapVar);
        }
        ArrayList resolvedVariables = new ArrayList();
        scheduledVariables.forEach(varFuture -> {
            try {
                Variable variable = (Variable)varFuture.get(2000L, TimeUnit.MILLISECONDS);
                if (variable != null) {
                    resolvedVariables.add(variable);
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to load some debug variables due to runtime exceptions.", (Throwable)e);
            }
        });
        scheduledLambdaMapVariables.forEach(varFuture -> {
            try {
                Variable[] variables = (Variable[])varFuture.get(2000L, TimeUnit.MILLISECONDS);
                if (variables != null) {
                    resolvedVariables.addAll(Arrays.asList(variables));
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to load some debug variables due to runtime exceptions.", (Throwable)e);
            }
        });
        return resolvedVariables.toArray(new Variable[0]);
    }

    private CompletableFuture<Variable[]> fetchLocalVariablesFromMap(VariablesArguments args, StackFrameProxyImpl stackFrame, LocalVariableProxyImpl lambdaParamMapVar) {
        try {
            Value value = stackFrame.getValue(lambdaParamMapVar);
            CompletableFuture<Variable> scheduledVariable = this.computeVariableAsync("lambdaArgMap", value, args.getVariablesReference());
            Variable dapVariable = scheduledVariable.get();
            if (dapVariable == null || !dapVariable.getType().equals(BVariableType.MAP.getString())) {
                return new CompletableFuture<Variable[]>();
            }
            VariablesArguments childVarRequestArgs = new VariablesArguments();
            childVarRequestArgs.setVariablesReference(dapVariable.getVariablesReference());
            return this.computeChildVariablesAsync(childVarRequestArgs);
        }
        catch (Exception e) {
            return new CompletableFuture<Variable[]>();
        }
    }

    private CompletableFuture<Variable> computeVariableAsync(String name, Value value, Integer stackFrameRef) {
        return CompletableFuture.supplyAsync(() -> {
            BVariable variable = VariableFactory.getVariable(this.suspendedContext, name, value);
            if (variable == null) {
                return null;
            }
            if (variable instanceof BSimpleVariable) {
                variable.getDapVariable().setVariablesReference(0);
            } else if (variable instanceof BCompoundVariable) {
                int variableReference = this.nextVarReference.getAndIncrement();
                variable.getDapVariable().setVariablesReference(variableReference);
                this.loadedCompoundVariables.put(variableReference, (BCompoundVariable)variable);
                this.updateVariableToStackFrameMap(stackFrameRef, variableReference);
            }
            return variable.getDapVariable();
        }, this.variableExecutor);
    }

    private CompletableFuture<Variable[]> computeChildVariablesAsync(VariablesArguments args) {
        return CompletableFuture.supplyAsync(() -> this.computeChildVariables(args), this.variableExecutor);
    }

    private Variable[] computeChildVariables(VariablesArguments args) {
        BCompoundVariable parentVar = this.loadedCompoundVariables.get(args.getVariablesReference());
        Integer stackFrameId = this.variableToStackFrames.get(args.getVariablesReference());
        if (stackFrameId == null) {
            return new Variable[0];
        }
        if (parentVar instanceof IndexedCompoundVariable) {
            int count;
            int startIndex = args.getStart() != null ? args.getStart() : 0;
            Either<Map<String, Value>, List<Value>> childVars = ((IndexedCompoundVariable)parentVar).getIndexedChildVariables(startIndex, count = args.getCount() != null ? args.getCount() : 0);
            if (childVars.isLeft()) {
                return this.createVariableArrayFrom(args, (Map)childVars.getLeft());
            }
            if (childVars.isRight()) {
                return this.createVariableArrayFrom(args, (List)childVars.getRight());
            }
            return new Variable[0];
        }
        if (parentVar instanceof NamedCompoundVariable) {
            Map<String, Value> childVars = ((NamedCompoundVariable)parentVar).getNamedChildVariables();
            return this.createVariableArrayFrom(args, childVars);
        }
        return new Variable[0];
    }

    private Variable[] createVariableArrayFrom(VariablesArguments args, Map<String, Value> varMap) {
        return (Variable[])varMap.entrySet().stream().map(entry -> {
            Value value;
            String name = (String)entry.getKey();
            BVariable variable = VariableFactory.getVariable(this.suspendedContext, name, value = (Value)entry.getValue());
            if (variable == null) {
                return null;
            }
            if (variable instanceof BSimpleVariable) {
                variable.getDapVariable().setVariablesReference(0);
            } else if (variable instanceof BCompoundVariable) {
                int variableReference = this.nextVarReference.getAndIncrement();
                variable.getDapVariable().setVariablesReference(variableReference);
                this.loadedCompoundVariables.put(variableReference, (BCompoundVariable)variable);
                this.updateVariableToStackFrameMap(args.getVariablesReference(), variableReference);
            }
            return variable.getDapVariable();
        }).filter(Objects::nonNull).toArray(Variable[]::new);
    }

    private Variable[] createVariableArrayFrom(VariablesArguments args, List<Value> varMap) {
        int startIndex = args.getStart() != null ? args.getStart() : 0;
        AtomicInteger index = new AtomicInteger(startIndex);
        return (Variable[])varMap.stream().map(value -> {
            String name = String.format("[%d]", index.getAndIncrement());
            BVariable variable = VariableFactory.getVariable(this.suspendedContext, name, value);
            if (variable == null) {
                return null;
            }
            if (variable instanceof BSimpleVariable) {
                variable.getDapVariable().setVariablesReference(0);
            } else if (variable instanceof BCompoundVariable) {
                int variableReference = this.nextVarReference.getAndIncrement();
                variable.getDapVariable().setVariablesReference(variableReference);
                this.loadedCompoundVariables.put(variableReference, (BCompoundVariable)variable);
                this.updateVariableToStackFrameMap(args.getVariablesReference(), variableReference);
            }
            return variable.getDapVariable();
        }).filter(Objects::nonNull).toArray(Variable[]::new);
    }

    private EvaluateResponse constructEvaluateResponse(EvaluateArguments args, BVariable evaluationResult) {
        EvaluateResponse response = new EvaluateResponse();
        if (evaluationResult == null) {
            return response;
        }
        if (evaluationResult instanceof BSimpleVariable) {
            evaluationResult.getDapVariable().setVariablesReference(0);
        } else if (evaluationResult instanceof BCompoundVariable) {
            int variableReference = this.nextVarReference.getAndIncrement();
            evaluationResult.getDapVariable().setVariablesReference(variableReference);
            this.loadedCompoundVariables.put(variableReference, (BCompoundVariable)evaluationResult);
            this.updateVariableToStackFrameMap(args.getFrameId(), variableReference);
        }
        Variable dapVariable = evaluationResult.getDapVariable();
        response.setResult(dapVariable.getValue());
        response.setType(dapVariable.getType());
        response.setIndexedVariables(dapVariable.getIndexedVariables());
        response.setNamedVariables(dapVariable.getNamedVariables());
        response.setVariablesReference(dapVariable.getVariablesReference());
        return response;
    }

    private String getAttachmentErrorMessage(Exception e) {
        String portName;
        String host = ((ClientAttachConfigHolder)this.clientConfigHolder).getHostName().orElse("localhost");
        try {
            portName = Integer.toString(this.clientConfigHolder.getDebuggePort());
        }
        catch (ClientConfigurationException clientConfigurationException) {
            portName = VALUE_UNKNOWN;
        }
        return String.format("Failed to attach to the target VM address: '%s:%s' due to: %s", host, portName, e.getMessage());
    }

    private void clearSuspendedState() {
        this.suspendedContext = null;
        this.evaluator = null;
        this.activeThread = null;
        this.stackFrames.clear();
        this.loadedCompoundVariables.clear();
        this.variableToStackFrames.clear();
        this.scopeIdToFrameIds.clear();
        this.threadStackTraces.clear();
        this.nextVarReference.set(1);
    }

    private void resetServer() {
        this.clearDebugHits();
        Optional.ofNullable(this.eventProcessor).ifPresent(JDIEventProcessor::reset);
        Optional.ofNullable(this.outputLogger).ifPresent(DebugOutputLogger::reset);
        Optional.ofNullable(this.executionManager).ifPresent(DebugExecutionManager::reset);
        this.terminateDebuggee();
        this.clearSuspendedState();
        this.context.reset();
    }

    private void clearDebugHits() {
        ContinuedEventArguments continuedEventArguments = new ContinuedEventArguments();
        continuedEventArguments.setAllThreadsContinued(Boolean.valueOf(true));
        this.context.getClient().continued(continuedEventArguments);
    }
}

