/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.completion.resolver;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.ClassFieldSymbol;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.MapTypeSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ObjectFieldSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Qualifiable;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.AnnotAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.BracedExpressionNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.IndexedExpressionNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.OptionalFieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.Document;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.Package;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.completion.context.CompletionContext;
import org.wso2.ballerinalang.compiler.util.Names;

public class FieldAccessCompletionResolver
extends NodeTransformer<Optional<TypeSymbol>> {
    private final CompletionContext context;

    public FieldAccessCompletionResolver(CompletionContext context) {
        this.context = context;
    }

    public Optional<TypeSymbol> transform(SimpleNameReferenceNode node) {
        SuspendedContext suspendedContext = this.context.getSuspendedContext();
        Optional<Symbol> symbol = this.getSymbolByName(this.context.visibleSymbols(suspendedContext.getLineNumber() - 1, 0), node.name().text());
        if (symbol.isEmpty()) {
            return Optional.empty();
        }
        return this.getTypeDescriptor(symbol.get());
    }

    public Optional<TypeSymbol> transform(FieldAccessExpressionNode node) {
        Optional typeSymbol = (Optional)node.expression().apply((NodeTransformer)this);
        NameReferenceNode fieldName = node.fieldName();
        if (fieldName.kind() != SyntaxKind.SIMPLE_NAME_REFERENCE || typeSymbol.isEmpty()) {
            return Optional.empty();
        }
        String name = ((SimpleNameReferenceNode)fieldName).name().text();
        List<Symbol> visibleEntries = this.getVisibleEntries((TypeSymbol)typeSymbol.get(), (Node)node.expression());
        Optional<Symbol> filteredSymbol = this.getSymbolByName(visibleEntries, name);
        if (filteredSymbol.isEmpty()) {
            return Optional.empty();
        }
        return this.getTypeDescriptor(filteredSymbol.get());
    }

    public Optional<TypeSymbol> transform(OptionalFieldAccessExpressionNode node) {
        Optional resolvedType = this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)node));
        if (resolvedType.isPresent() && ((TypeSymbol)resolvedType.get()).typeKind() != TypeDescKind.COMPILATION_ERROR) {
            return this.getTypeDescriptor((Symbol)resolvedType.get());
        }
        Optional typeSymbol = (Optional)node.expression().apply((NodeTransformer)this);
        NameReferenceNode fieldName = node.fieldName();
        if (fieldName.kind() != SyntaxKind.SIMPLE_NAME_REFERENCE || typeSymbol.isEmpty()) {
            return Optional.empty();
        }
        String name = ((SimpleNameReferenceNode)fieldName).name().text();
        List<Symbol> visibleEntries = this.getVisibleEntries((TypeSymbol)typeSymbol.get(), (Node)node.expression());
        Optional<Symbol> filteredSymbol = this.getSymbolByName(visibleEntries, name);
        if (filteredSymbol.isEmpty()) {
            return Optional.empty();
        }
        return this.getTypeDescriptor(filteredSymbol.get());
    }

    public Optional<TypeSymbol> transform(MethodCallExpressionNode node) {
        Optional exprTypeSymbol = (Optional)node.expression().apply((NodeTransformer)this);
        NameReferenceNode nameRef = node.methodName();
        if (nameRef.kind() != SyntaxKind.SIMPLE_NAME_REFERENCE) {
            return Optional.empty();
        }
        Predicate<Symbol> predicate = symbol -> symbol.kind() == SymbolKind.METHOD || symbol.kind() == SymbolKind.FUNCTION;
        String methodName = ((SimpleNameReferenceNode)nameRef).name().text();
        List<Symbol> visibleEntries = this.getVisibleEntries((TypeSymbol)exprTypeSymbol.orElseThrow(), (Node)node.expression());
        FunctionSymbol symbol2 = (FunctionSymbol)this.getSymbolByName(visibleEntries, methodName, predicate);
        FunctionTypeSymbol functionTypeSymbol = (FunctionTypeSymbol)this.getTypeDescriptor((Symbol)symbol2).orElseThrow();
        return functionTypeSymbol.returnTypeDescriptor();
    }

    public Optional<TypeSymbol> transform(FunctionCallExpressionNode node) {
        return Optional.empty();
    }

    public Optional<TypeSymbol> transform(IndexedExpressionNode node) {
        Optional containerType = (Optional)node.containerExpression().apply((NodeTransformer)this);
        TypeSymbol rawType = this.getRawType((TypeSymbol)containerType.orElseThrow());
        if (rawType.typeKind() == TypeDescKind.ARRAY) {
            return Optional.of(((ArrayTypeSymbol)rawType).memberTypeDescriptor());
        }
        if (rawType.typeKind() == TypeDescKind.MAP) {
            return Optional.of(((MapTypeSymbol)rawType).typeParam());
        }
        return Optional.empty();
    }

    public Optional<TypeSymbol> transform(AnnotAccessExpressionNode node) {
        return this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)node));
    }

    public Optional<TypeSymbol> transform(BasicLiteralNode node) {
        return this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)node));
    }

    public Optional<TypeSymbol> transform(BracedExpressionNode node) {
        return (Optional)node.expression().apply((NodeTransformer)this);
    }

    protected Optional<TypeSymbol> transformSyntaxNode(Node node) {
        return Optional.empty();
    }

    public List<Symbol> getVisibleEntries(Node node) {
        Optional<TypeSymbol> typeSymbol = this.getTypeSymbol(node);
        return this.getVisibleEntries(typeSymbol.get(), node);
    }

    public Optional<TypeSymbol> getTypeSymbol(Node node) {
        return (Optional)node.apply((NodeTransformer)this);
    }

    private Optional<Symbol> getSymbolByName(List<Symbol> visibleSymbols, String name) {
        return visibleSymbols.stream().filter(symbol -> symbol.nameEquals(name)).findFirst();
    }

    private Symbol getSymbolByName(List<Symbol> visibleSymbols, String name, Predicate<Symbol> predicate) {
        Predicate<Symbol> namePredicate = symbol -> symbol.nameEquals(name);
        return visibleSymbols.stream().filter(namePredicate.and(predicate)).findFirst().orElseThrow();
    }

    private List<Symbol> getVisibleEntries(TypeSymbol typeSymbol, Node node) {
        ArrayList<Symbol> visibleEntries = new ArrayList<Symbol>();
        TypeSymbol rawType = this.getRawType(typeSymbol);
        switch (rawType.typeKind()) {
            case RECORD: {
                ArrayList filteredEntries = new ArrayList(((RecordTypeSymbol)rawType).fieldDescriptors().values());
                visibleEntries.addAll(filteredEntries);
                break;
            }
            case OBJECT: {
                Package currentPkg = this.context.getSuspendedContext().getProject().currentPackage();
                Document currentModule = this.context.getSuspendedContext().getDocument();
                ObjectTypeSymbol objTypeDesc = (ObjectTypeSymbol)rawType;
                visibleEntries.addAll(objTypeDesc.fieldDescriptors().values().stream().filter(objectFieldSymbol -> this.withValidAccessModifiers(node, (Symbol)objectFieldSymbol, currentPkg, currentModule.module().moduleId())).toList());
                boolean isClient = this.isClient((Symbol)objTypeDesc);
                boolean isService = this.getTypeDescForObjectSymbol((Symbol)objTypeDesc).qualifiers().contains(Qualifier.SERVICE);
                List<MethodSymbol> methodSymbols = objTypeDesc.methods().values().stream().filter(methodSymbol -> (!isClient && !isService || !methodSymbol.qualifiers().contains(Qualifier.REMOTE)) && !methodSymbol.qualifiers().contains(Qualifier.RESOURCE) && this.withValidAccessModifiers(node, (Symbol)methodSymbol, currentPkg, currentModule.module().moduleId())).toList();
                visibleEntries.addAll(methodSymbols);
                break;
            }
        }
        visibleEntries.addAll(typeSymbol.langLibMethods());
        return visibleEntries;
    }

    private boolean withValidAccessModifiers(Node exprNode, Symbol symbol, Package currentPackage, ModuleId currentModule) {
        Optional symbolModule = symbol.getModule();
        boolean isPrivate = false;
        boolean isPublic = false;
        boolean isResource = false;
        if (symbol instanceof Qualifiable) {
            Qualifiable qSymbol = (Qualifiable)symbol;
            isPrivate = qSymbol.qualifiers().contains(Qualifier.PRIVATE);
            isPublic = qSymbol.qualifiers().contains(Qualifier.PUBLIC);
            isResource = qSymbol.qualifiers().contains(Qualifier.RESOURCE);
        }
        if (exprNode.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE && ((SimpleNameReferenceNode)exprNode).name().text().equals(Names.SELF.getValue()) && !isResource) {
            return true;
        }
        ModuleID objModuleId = ((ModuleSymbol)symbolModule.get()).id();
        return isPublic || !isPrivate && objModuleId.moduleName().equals(currentModule.moduleName()) && objModuleId.orgName().equals(currentPackage.packageOrg().value());
    }

    private boolean isObject(Symbol symbol) {
        ClassSymbol typeDescriptor;
        switch (symbol.kind()) {
            case TYPE_DEFINITION: {
                typeDescriptor = ((TypeDefinitionSymbol)symbol).typeDescriptor();
                break;
            }
            case VARIABLE: {
                typeDescriptor = ((VariableSymbol)symbol).typeDescriptor();
                break;
            }
            case PARAMETER: {
                typeDescriptor = ((ParameterSymbol)symbol).typeDescriptor();
                break;
            }
            case CLASS: {
                typeDescriptor = (ClassSymbol)symbol;
                break;
            }
            case TYPE: {
                typeDescriptor = (TypeSymbol)symbol;
                break;
            }
            default: {
                return false;
            }
        }
        return this.getRawType((TypeSymbol)typeDescriptor).typeKind() == TypeDescKind.OBJECT;
    }

    private Optional<TypeSymbol> getTypeDescriptor(Symbol symbol) {
        if (symbol == null) {
            return Optional.empty();
        }
        return switch (symbol.kind()) {
            case SymbolKind.TYPE_DEFINITION -> Optional.ofNullable(((TypeDefinitionSymbol)symbol).typeDescriptor());
            case SymbolKind.VARIABLE -> Optional.ofNullable(((VariableSymbol)symbol).typeDescriptor());
            case SymbolKind.PARAMETER -> Optional.ofNullable(((ParameterSymbol)symbol).typeDescriptor());
            case SymbolKind.ANNOTATION -> ((AnnotationSymbol)symbol).typeDescriptor();
            case SymbolKind.FUNCTION, SymbolKind.METHOD -> Optional.ofNullable(((FunctionSymbol)symbol).typeDescriptor());
            case SymbolKind.CONSTANT, SymbolKind.ENUM_MEMBER -> Optional.ofNullable(((ConstantSymbol)symbol).typeDescriptor());
            case SymbolKind.CLASS -> Optional.of((ClassSymbol)symbol);
            case SymbolKind.RECORD_FIELD -> Optional.ofNullable(((RecordFieldSymbol)symbol).typeDescriptor());
            case SymbolKind.OBJECT_FIELD -> Optional.of(((ObjectFieldSymbol)symbol).typeDescriptor());
            case SymbolKind.CLASS_FIELD -> Optional.of(((ClassFieldSymbol)symbol).typeDescriptor());
            case SymbolKind.TYPE -> Optional.of((TypeSymbol)symbol);
            default -> Optional.empty();
        };
    }

    private ObjectTypeSymbol getTypeDescForObjectSymbol(Symbol symbol) {
        Optional<TypeSymbol> typeDescriptor = this.getTypeDescriptor(symbol);
        if (typeDescriptor.isEmpty() || !this.isObject(symbol)) {
            throw new UnsupportedOperationException("Cannot find a valid type descriptor");
        }
        return (ObjectTypeSymbol)this.getRawType(typeDescriptor.get());
    }

    private boolean isClient(Symbol symbol) {
        if (!this.isObject(symbol)) {
            return false;
        }
        ObjectTypeSymbol typeDesc = this.getTypeDescForObjectSymbol(symbol);
        return typeDesc.qualifiers().contains(Qualifier.CLIENT);
    }

    private TypeSymbol getRawType(TypeSymbol typeDescriptor) {
        if (typeDescriptor.typeKind() == TypeDescKind.INTERSECTION) {
            return this.getRawType(((IntersectionTypeSymbol)typeDescriptor).effectiveTypeDescriptor());
        }
        if (typeDescriptor.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            TypeReferenceTypeSymbol typeRef = (TypeReferenceTypeSymbol)typeDescriptor;
            if (typeRef.typeDescriptor().typeKind() == TypeDescKind.INTERSECTION) {
                return this.getRawType(((IntersectionTypeSymbol)typeRef.typeDescriptor()).effectiveTypeDescriptor());
            }
            return typeRef.typeDescriptor();
        }
        return typeDescriptor;
    }
}

