/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.completion.util;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.RemoteMethodCallActionNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.Document;
import io.ballerina.projects.Module;
import io.ballerina.projects.Project;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.ballerinalang.debugadapter.completion.context.CompletionContext;
import org.ballerinalang.debugadapter.completion.util.SymbolUtil;
import org.wso2.ballerinalang.compiler.util.Names;

public final class CommonUtil {
    private static final Pattern TYPE_NAME_DECOMPOSE_PATTERN = Pattern.compile("([\\w_.]*)/([\\w._]*):([\\w.-]*)");

    private CommonUtil() {
    }

    public static Optional<ModuleSymbol> searchModuleForAlias(CompletionContext context, String alias) {
        List<Symbol> visibleSymbols = context.visibleSymbols(context.getSuspendedContext().getLineNumber() - 1, 0);
        for (Symbol symbol : visibleSymbols) {
            if (symbol.kind() != SymbolKind.MODULE || !Objects.equals(symbol.getName().orElse(null), alias)) continue;
            return Optional.of((ModuleSymbol)symbol);
        }
        return Optional.empty();
    }

    public static String getPackageNameComponentsCombined(ImportDeclarationNode importNode) {
        return importNode.moduleName().stream().map(Token::text).collect(Collectors.joining("."));
    }

    public static boolean isLangLib(ModuleID moduleID) {
        return CommonUtil.isLangLib(moduleID.orgName(), moduleID.moduleName());
    }

    public static boolean isLangLib(String orgName, String moduleName) {
        return orgName.equals("ballerina") && moduleName.startsWith("lang.");
    }

    public static TypeSymbol getRawType(TypeSymbol typeDescriptor) {
        if (typeDescriptor.typeKind() == TypeDescKind.INTERSECTION) {
            return CommonUtil.getRawType(((IntersectionTypeSymbol)typeDescriptor).effectiveTypeDescriptor());
        }
        if (typeDescriptor.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            TypeReferenceTypeSymbol typeRef = (TypeReferenceTypeSymbol)typeDescriptor;
            if (typeRef.typeDescriptor().typeKind() == TypeDescKind.INTERSECTION) {
                return CommonUtil.getRawType(((IntersectionTypeSymbol)typeRef.typeDescriptor()).effectiveTypeDescriptor());
            }
            return typeRef.typeDescriptor();
        }
        return typeDescriptor;
    }

    public static Optional<ImportDeclarationNode> matchingImportedModule(CompletionContext context, String orgName, String modName) {
        Map<ImportDeclarationNode, ModuleSymbol> currentDocImports = CommonUtil.currentDocImportsMap(context);
        return currentDocImports.keySet().stream().filter(importPkg -> (importPkg.orgName().isEmpty() || ((ImportOrgNameNode)importPkg.orgName().get()).orgName().text().equals(orgName)) && CommonUtil.getPackageNameComponentsCombined(importPkg).equals(modName)).findFirst();
    }

    public static String getModifiedTypeName(CompletionContext context, TypeSymbol typeSymbol) {
        String typeSignature = typeSymbol.signature();
        return CommonUtil.getModifiedSignature(context, typeSignature);
    }

    public static String getModifiedSignature(CompletionContext context, String signature) {
        Matcher matcher = TYPE_NAME_DECOMPOSE_PATTERN.matcher(signature);
        while (matcher.find()) {
            String orgName = matcher.group(1);
            String moduleName = matcher.group(2);
            String matchedString = matcher.group();
            String modulePrefix = CommonUtil.getModulePrefix(context, orgName, moduleName);
            String replaceText = modulePrefix.isEmpty() ? matchedString + String.valueOf(Names.VERSION_SEPARATOR) : matchedString;
            signature = signature.replace(replaceText, modulePrefix);
        }
        return signature;
    }

    public static String getModulePrefix(CompletionContext context, String orgName, String modName) {
        Project project = context.getSuspendedContext().getProject();
        String currentProjectOrg = project.currentPackage().packageOrg().value();
        boolean isCurrentOrg = currentProjectOrg.equals(orgName);
        Optional<Module> currentModule = Optional.ofNullable(context.getSuspendedContext().getModule());
        String evalOrgName = isCurrentOrg ? "" : orgName;
        Optional<ImportDeclarationNode> matchedImport = CommonUtil.matchingImportedModule(context, evalOrgName, modName);
        if (currentModule.isPresent() && modName.equals(CommonUtil.getQualifiedModuleName(currentModule.get()))) {
            return "";
        }
        if (matchedImport.isPresent()) {
            Optional prefix = matchedImport.get().prefix();
            if (prefix.isPresent()) {
                return ((ImportPrefixNode)prefix.get()).prefix().text();
            }
            SeparatedNodeList moduleComponents = matchedImport.get().moduleName();
            return ((IdentifierToken)moduleComponents.get(moduleComponents.size() - 1)).text();
        }
        String[] modNameComponents = modName.split("\\.");
        return modNameComponents[modNameComponents.length - 1];
    }

    private static String getQualifiedModuleName(Module module) {
        if (module.isDefaultModule()) {
            return module.moduleName().packageName().value();
        }
        return module.moduleName().packageName().value() + Names.DOT.getValue() + module.moduleName().moduleNamePart();
    }

    public static Optional<ParameterSymbol> resolveFunctionParameterSymbol(FunctionTypeSymbol functionTypeSymbol, CompletionContext ctx, FunctionCallExpressionNode node) {
        return CommonUtil.resolveParameterSymbol(functionTypeSymbol, ctx, (SeparatedNodeList<FunctionArgumentNode>)node.arguments());
    }

    public static Optional<ParameterSymbol> resolveFunctionParameterSymbol(FunctionTypeSymbol functionTypeSymbol, CompletionContext ctx, RemoteMethodCallActionNode node) {
        return CommonUtil.resolveParameterSymbol(functionTypeSymbol, ctx, (SeparatedNodeList<FunctionArgumentNode>)node.arguments());
    }

    public static Optional<ParameterSymbol> resolveFunctionParameterSymbol(FunctionTypeSymbol functionTypeSymbol, CompletionContext ctx, MethodCallExpressionNode node) {
        return CommonUtil.resolveParameterSymbol(functionTypeSymbol, ctx, (SeparatedNodeList<FunctionArgumentNode>)node.arguments());
    }

    public static Optional<ParameterSymbol> resolveFunctionParameterSymbol(FunctionTypeSymbol functionTypeSymbol, CompletionContext ctx, ImplicitNewExpressionNode node) {
        Optional args = node.parenthesizedArgList();
        if (args.isEmpty()) {
            return Optional.empty();
        }
        return CommonUtil.resolveParameterSymbol(functionTypeSymbol, ctx, (SeparatedNodeList<FunctionArgumentNode>)((ParenthesizedArgList)args.get()).arguments());
    }

    public static Optional<ParameterSymbol> resolveFunctionParameterSymbol(FunctionTypeSymbol functionTypeSymbol, CompletionContext ctx, ExplicitNewExpressionNode node) {
        ParenthesizedArgList args = node.parenthesizedArgList();
        return CommonUtil.resolveParameterSymbol(functionTypeSymbol, ctx, (SeparatedNodeList<FunctionArgumentNode>)args.arguments());
    }

    public static Boolean isInFunctionCallParameterContext(CompletionContext ctx, FunctionCallExpressionNode node) {
        return CommonUtil.isWithinParenthesis(ctx, node.openParenToken(), node.closeParenToken());
    }

    public static Boolean isInMethodCallParameterContext(CompletionContext ctx, MethodCallExpressionNode node) {
        return CommonUtil.isWithinParenthesis(ctx, node.openParenToken(), node.closeParenToken());
    }

    public static Boolean isInMethodCallParameterContext(CompletionContext ctx, RemoteMethodCallActionNode node) {
        return CommonUtil.isWithinParenthesis(ctx, node.openParenToken(), node.closeParenToken());
    }

    public static Boolean isInNewExpressionParameterContext(CompletionContext ctx, ImplicitNewExpressionNode node) {
        Optional argList = node.parenthesizedArgList();
        if (argList.isEmpty()) {
            return false;
        }
        return CommonUtil.isWithinParenthesis(ctx, ((ParenthesizedArgList)argList.get()).openParenToken(), ((ParenthesizedArgList)argList.get()).closeParenToken());
    }

    public static Boolean isInNewExpressionParameterContext(CompletionContext ctx, ExplicitNewExpressionNode node) {
        ParenthesizedArgList argList = node.parenthesizedArgList();
        return CommonUtil.isWithinParenthesis(ctx, argList.openParenToken(), argList.closeParenToken());
    }

    private static boolean isWithinParenthesis(CompletionContext ctx, Token openParen, Token closedParen) {
        int cursorPosition = ctx.getCursorPositionInTree();
        return !openParen.isMissing() && openParen.textRange().endOffset() <= cursorPosition && !closedParen.isMissing() && cursorPosition <= closedParen.textRange().startOffset();
    }

    private static Optional<ParameterSymbol> resolveParameterSymbol(FunctionTypeSymbol functionTypeSymbol, CompletionContext ctx, SeparatedNodeList<FunctionArgumentNode> arguments) {
        int cursorPosition = ctx.getCursorPositionInTree();
        int argIndex = -1;
        for (Node child : arguments) {
            if (child.textRange().endOffset() >= cursorPosition) continue;
            ++argIndex;
        }
        Optional params = functionTypeSymbol.params();
        if (params.isEmpty() || ((List)params.get()).size() < argIndex + 2) {
            return Optional.empty();
        }
        return Optional.of((ParameterSymbol)((List)params.get()).get(argIndex + 1));
    }

    public static Map<ImportDeclarationNode, ModuleSymbol> currentDocImportsMap(CompletionContext context) {
        LinkedHashMap<ImportDeclarationNode, ModuleSymbol> currentDocImportsMap = new LinkedHashMap<ImportDeclarationNode, ModuleSymbol>();
        Optional<Document> document = Optional.ofNullable(context.getSuspendedContext().getDocument());
        if (document.isEmpty()) {
            throw new RuntimeException("Cannot find a valid document");
        }
        Optional<SemanticModel> semanticModel = Optional.ofNullable(context.getSuspendedContext().getSemanticInfo());
        if (semanticModel.isEmpty()) {
            throw new RuntimeException("Semantic Model Cannot be Empty");
        }
        ModulePartNode modulePartNode = (ModulePartNode)document.get().syntaxTree().rootNode();
        for (ImportDeclarationNode importDeclaration : modulePartNode.imports()) {
            Optional symbol = semanticModel.get().symbol((Node)importDeclaration);
            if (symbol.isEmpty() || ((Symbol)symbol.get()).kind() != SymbolKind.MODULE) continue;
            currentDocImportsMap.put(importDeclaration, (ModuleSymbol)symbol.get());
        }
        return currentDocImportsMap;
    }

    public static List<MethodSymbol> getClientActions(Symbol symbol) {
        if (!SymbolUtil.isObject(symbol)) {
            return new ArrayList<MethodSymbol>();
        }
        TypeSymbol typeDescriptor = CommonUtil.getRawType(SymbolUtil.getTypeDescriptor(symbol).orElseThrow());
        return ((ObjectTypeSymbol)typeDescriptor).methods().values().stream().filter(method -> method.qualifiers().contains(Qualifier.REMOTE)).toList();
    }
}

