/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.completion.util;

import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ClassFieldSymbol;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.ObjectFieldSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import java.util.Optional;
import org.ballerinalang.debugadapter.completion.util.CommonUtil;

public final class SymbolUtil {
    private SymbolUtil() {
    }

    public static boolean isObject(Symbol symbol) {
        ClassSymbol typeDescriptor;
        switch (symbol.kind()) {
            case TYPE_DEFINITION: {
                typeDescriptor = ((TypeDefinitionSymbol)symbol).typeDescriptor();
                break;
            }
            case VARIABLE: {
                typeDescriptor = ((VariableSymbol)symbol).typeDescriptor();
                break;
            }
            case PARAMETER: {
                typeDescriptor = ((ParameterSymbol)symbol).typeDescriptor();
                break;
            }
            case CLASS: {
                typeDescriptor = (ClassSymbol)symbol;
                break;
            }
            case TYPE: {
                typeDescriptor = (TypeSymbol)symbol;
                break;
            }
            default: {
                return false;
            }
        }
        return CommonUtil.getRawType((TypeSymbol)typeDescriptor).typeKind() == TypeDescKind.OBJECT;
    }

    public static Optional<TypeSymbol> getTypeDescriptor(Symbol symbol) {
        if (symbol == null) {
            return Optional.empty();
        }
        return switch (symbol.kind()) {
            case SymbolKind.TYPE_DEFINITION -> Optional.ofNullable(((TypeDefinitionSymbol)symbol).typeDescriptor());
            case SymbolKind.VARIABLE -> Optional.ofNullable(((VariableSymbol)symbol).typeDescriptor());
            case SymbolKind.PARAMETER -> Optional.ofNullable(((ParameterSymbol)symbol).typeDescriptor());
            case SymbolKind.ANNOTATION -> ((AnnotationSymbol)symbol).typeDescriptor();
            case SymbolKind.FUNCTION, SymbolKind.METHOD -> Optional.ofNullable(((FunctionSymbol)symbol).typeDescriptor());
            case SymbolKind.CONSTANT, SymbolKind.ENUM_MEMBER -> Optional.ofNullable(((ConstantSymbol)symbol).typeDescriptor());
            case SymbolKind.CLASS -> Optional.of((ClassSymbol)symbol);
            case SymbolKind.RECORD_FIELD -> Optional.ofNullable(((RecordFieldSymbol)symbol).typeDescriptor());
            case SymbolKind.OBJECT_FIELD -> Optional.of(((ObjectFieldSymbol)symbol).typeDescriptor());
            case SymbolKind.CLASS_FIELD -> Optional.of(((ClassFieldSymbol)symbol).typeDescriptor());
            case SymbolKind.TYPE -> Optional.of((TypeSymbol)symbol);
            default -> Optional.empty();
        };
    }

    public static ObjectTypeSymbol getTypeDescForObjectSymbol(Symbol symbol) {
        Optional<TypeSymbol> typeDescriptor = SymbolUtil.getTypeDescriptor(symbol);
        if (typeDescriptor.isEmpty() || !SymbolUtil.isObject(symbol)) {
            throw new UnsupportedOperationException("Cannot find a valid type descriptor");
        }
        return (ObjectTypeSymbol)CommonUtil.getRawType(typeDescriptor.get());
    }

    public static boolean isClient(Symbol symbol) {
        if (!SymbolUtil.isObject(symbol)) {
            return false;
        }
        ObjectTypeSymbol typeDesc = SymbolUtil.getTypeDescForObjectSymbol(symbol);
        return typeDesc.qualifiers().contains(Qualifier.CLIENT);
    }
}

