/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.config;

import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.debugadapter.config.ClientConfigurationException;
import org.eclipse.lsp4j.debug.RunInTerminalRequestArgumentsKind;

public class ClientConfigHolder {
    protected Map<String, Object> clientRequestArgs;
    private final ClientConfigKind kind;
    private String sourcePath;
    private Integer debuggePort;
    private Boolean isLowCodeMode;
    private ExtendedClientCapabilities extendedClientCapabilities;
    protected static final String ARG_FILE_PATH = "script";
    protected static final String ARG_DEBUGGEE_HOST = "debuggeeHost";
    protected static final String ARG_DEBUGGEE_PORT = "debuggeePort";
    private static final String ARG_CAPABILITIES = "capabilities";
    private static final String ARG_SUPPORT_READONLY_EDITOR = "supportsReadOnlyEditors";
    private static final String ARG_SUPPORT_BP_VERIFICATION = "supportsBreakpointVerification";
    private static final String ARG_SUPPORT_FAST_RUN = "supportsFastRun";
    private static final String ARG_TERMINAL_KIND = "terminal";
    private static final String ARG_LOW_CODE_MODE = "lowCodeMode";
    private static final String INTEGRATED_TERMINAL_KIND = "INTEGRATED";
    private static final String EXTERNAL_TERMINAL_KIND = "EXTERNAL";

    protected ClientConfigHolder(Map<String, Object> clientRequestArgs, ClientConfigKind kind) {
        this.clientRequestArgs = clientRequestArgs;
        this.kind = kind;
    }

    public ClientConfigKind getKind() {
        return this.kind;
    }

    public String getSourcePath() throws ClientConfigurationException {
        if (this.sourcePath == null) {
            this.failIfConfigMissing(ARG_FILE_PATH);
            this.sourcePath = this.clientRequestArgs.get(ARG_FILE_PATH).toString();
        }
        return this.sourcePath;
    }

    public int getDebuggePort() throws ClientConfigurationException {
        if (this.debuggePort == null) {
            this.failIfConfigMissing(ARG_DEBUGGEE_PORT);
            this.debuggePort = Integer.parseInt(this.clientRequestArgs.get(ARG_DEBUGGEE_PORT).toString());
        }
        return this.debuggePort;
    }

    public Optional<ExtendedClientCapabilities> getExtendedCapabilities() {
        if (this.extendedClientCapabilities != null) {
            return Optional.of(this.extendedClientCapabilities);
        }
        Object capabilitiesObj = this.clientRequestArgs.get(ARG_CAPABILITIES);
        if (!(capabilitiesObj instanceof Map)) {
            return Optional.empty();
        }
        Map capabilities = (Map)capabilitiesObj;
        this.extendedClientCapabilities = new ExtendedClientCapabilities();
        Object readOnlyEditorConfig = capabilities.get(ARG_SUPPORT_READONLY_EDITOR);
        if (readOnlyEditorConfig instanceof Boolean) {
            Boolean b = (Boolean)readOnlyEditorConfig;
            this.extendedClientCapabilities.setSupportsReadOnlyEditors(b);
        } else if (readOnlyEditorConfig instanceof String) {
            String s = (String)readOnlyEditorConfig;
            this.extendedClientCapabilities.setSupportsReadOnlyEditors(Boolean.parseBoolean(s));
        } else {
            this.extendedClientCapabilities.setSupportsReadOnlyEditors(false);
        }
        Object bpVerificationConfig = capabilities.get(ARG_SUPPORT_BP_VERIFICATION);
        if (bpVerificationConfig instanceof Boolean) {
            Boolean b = (Boolean)bpVerificationConfig;
            this.extendedClientCapabilities.setSupportsBreakpointVerification(b);
        } else if (bpVerificationConfig instanceof String) {
            String s = (String)bpVerificationConfig;
            this.extendedClientCapabilities.setSupportsBreakpointVerification(Boolean.parseBoolean(s));
        } else {
            this.extendedClientCapabilities.setSupportsBreakpointVerification(false);
        }
        Object fastRunConfig = capabilities.get(ARG_SUPPORT_FAST_RUN);
        if (fastRunConfig instanceof Boolean) {
            Boolean b = (Boolean)fastRunConfig;
            this.extendedClientCapabilities.setSupportsFastRun(b);
        } else if (fastRunConfig instanceof String) {
            String s = (String)fastRunConfig;
            this.extendedClientCapabilities.setSupportsFastRun(Boolean.parseBoolean(s));
        } else {
            this.extendedClientCapabilities.setSupportsFastRun(false);
        }
        return Optional.ofNullable(this.extendedClientCapabilities);
    }

    public RunInTerminalRequestArgumentsKind getRunInTerminalKind() {
        String terminalConfig;
        if (this.clientRequestArgs.get(ARG_TERMINAL_KIND) != null && ((terminalConfig = this.clientRequestArgs.get(ARG_TERMINAL_KIND).toString().toUpperCase(Locale.ENGLISH)).equals(INTEGRATED_TERMINAL_KIND) || terminalConfig.equals(EXTERNAL_TERMINAL_KIND))) {
            return RunInTerminalRequestArgumentsKind.INTEGRATED;
        }
        return null;
    }

    public boolean isLowCodeMode() {
        if (this.isLowCodeMode == null) {
            Object isLowCodeMode = this.clientRequestArgs.get(ARG_LOW_CODE_MODE);
            if (isLowCodeMode instanceof Boolean) {
                Boolean b;
                this.isLowCodeMode = b = (Boolean)isLowCodeMode;
            } else if (isLowCodeMode instanceof String) {
                String s = (String)isLowCodeMode;
                this.isLowCodeMode = Boolean.parseBoolean(s);
            } else {
                this.isLowCodeMode = false;
            }
        }
        return this.isLowCodeMode;
    }

    protected void failIfConfigMissing(String configName) throws ClientConfigurationException {
        if (this.clientRequestArgs.get(configName) == null) {
            throw new ClientConfigurationException("Required client configuration missing: '" + configName + "'");
        }
    }

    public static enum ClientConfigKind {
        ATTACH_CONFIG,
        LAUNCH_CONFIG;

    }

    public static class ExtendedClientCapabilities {
        private boolean supportsReadOnlyEditors = false;
        private boolean supportsBreakpointVerification = false;
        private boolean supportsFastRun = false;

        public boolean supportsReadOnlyEditors() {
            return this.supportsReadOnlyEditors;
        }

        public void setSupportsReadOnlyEditors(boolean supportsReadOnlyEditors) {
            this.supportsReadOnlyEditors = supportsReadOnlyEditors;
        }

        public boolean supportsBreakpointVerification() {
            return this.supportsBreakpointVerification;
        }

        public void setSupportsBreakpointVerification(boolean supportsBreakpointVerification) {
            this.supportsBreakpointVerification = supportsBreakpointVerification;
        }

        public boolean supportsFastRun() {
            return this.supportsFastRun;
        }

        public void setSupportsFastRun(boolean supportsFastRun) {
            this.supportsFastRun = supportsFastRun;
        }
    }
}

