/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.debugadapter.config.ClientConfigHolder;
import org.ballerinalang.debugadapter.config.ClientConfigurationException;

public class ClientLaunchConfigHolder
extends ClientConfigHolder {
    private Boolean noDebug;
    private String ballerinaHome;
    private String ballerinaCommand;
    private Boolean testDebug;
    private Boolean networkLogsEnabled;
    private Integer networkLogsPort;
    private List<String> commandOptions;
    private List<String> programArgs;
    private List<String> testArgs;
    private Map<String, String> env;
    private static final String ARG_BALLERINA_HOME = "ballerina.home";
    private static final String ARG_BALLERINA_COMMAND = "ballerina.command";
    private static final String ARG_TEST_DEBUG = "debugTests";
    private static final String ARG_NETWORK_LOGS = "networkLogs";
    private static final String ARG_NETWORK_LOGS_PORT = "networkLogsPort";
    private static final String ARG_COMMAND_OPTIONS = "commandOptions";
    private static final String ARG_SCRIPT_ARGUMENTS = "scriptArguments";
    private static final String ARG_TEST_ARGUMENTS = "tests";
    private static final String ARG_NO_DEBUG = "noDebug";
    private static final String ARG_ENV = "env";

    public ClientLaunchConfigHolder(Map<String, Object> args) {
        super(args, ClientConfigHolder.ClientConfigKind.LAUNCH_CONFIG);
    }

    public String getBallerinaHome() throws ClientConfigurationException {
        if (this.ballerinaHome == null) {
            this.failIfConfigMissing(ARG_BALLERINA_HOME);
            this.ballerinaHome = this.clientRequestArgs.get(ARG_BALLERINA_HOME).toString();
        }
        return this.ballerinaHome;
    }

    public Optional<String> getBallerinaCommand() {
        if (this.ballerinaCommand == null) {
            if (!this.clientRequestArgs.containsKey(ARG_BALLERINA_COMMAND)) {
                return Optional.empty();
            }
            this.ballerinaCommand = this.clientRequestArgs.get(ARG_BALLERINA_COMMAND).toString();
        }
        return Optional.ofNullable(this.ballerinaCommand);
    }

    public boolean isNoDebugMode() {
        if (this.noDebug == null) {
            Object noDebugObject = this.clientRequestArgs.get(ARG_NO_DEBUG);
            if (noDebugObject instanceof Boolean) {
                Boolean b;
                this.noDebug = b = (Boolean)noDebugObject;
            } else if (noDebugObject instanceof String) {
                String s = (String)noDebugObject;
                this.noDebug = Boolean.parseBoolean(s);
            } else {
                this.noDebug = false;
            }
        }
        return this.noDebug;
    }

    public boolean isTestDebug() {
        if (this.testDebug == null) {
            Object testDebugObj = this.clientRequestArgs.get(ARG_TEST_DEBUG);
            if (testDebugObj instanceof Boolean) {
                Boolean b;
                this.testDebug = b = (Boolean)testDebugObj;
            } else if (testDebugObj instanceof String) {
                String s = (String)testDebugObj;
                this.testDebug = Boolean.parseBoolean(s);
            } else {
                this.testDebug = false;
            }
        }
        return this.testDebug;
    }

    public boolean isNetworkLogsEnabled() {
        if (this.networkLogsEnabled == null) {
            Object networkLogs = this.clientRequestArgs.get(ARG_NETWORK_LOGS);
            if (networkLogs instanceof Boolean) {
                Boolean b;
                this.networkLogsEnabled = b = (Boolean)networkLogs;
            } else if (networkLogs instanceof String) {
                String s = (String)networkLogs;
                this.networkLogsEnabled = Boolean.parseBoolean(s);
            } else {
                this.networkLogsEnabled = false;
            }
        }
        return this.networkLogsEnabled;
    }

    public Optional<Integer> getNetworkLogsPort() {
        if (this.networkLogsPort == null) {
            if (this.clientRequestArgs.containsKey(ARG_NETWORK_LOGS_PORT)) {
                return Optional.empty();
            }
            this.networkLogsPort = Integer.getInteger(this.clientRequestArgs.get(ARG_NETWORK_LOGS_PORT).toString());
        }
        return Optional.ofNullable(this.networkLogsPort);
    }

    public List<String> getCommandOptions() {
        if (this.commandOptions == null) {
            this.commandOptions = new ArrayList<String>();
            if (this.clientRequestArgs.get(ARG_COMMAND_OPTIONS) instanceof ArrayList) {
                this.commandOptions.addAll((ArrayList)this.clientRequestArgs.get(ARG_COMMAND_OPTIONS));
            }
        }
        return this.commandOptions;
    }

    public List<String> getProgramArgs() {
        if (this.programArgs == null) {
            this.programArgs = new ArrayList<String>();
            if (this.clientRequestArgs.get(ARG_SCRIPT_ARGUMENTS) instanceof ArrayList) {
                this.programArgs.addAll((ArrayList)this.clientRequestArgs.get(ARG_SCRIPT_ARGUMENTS));
            }
        }
        return this.programArgs;
    }

    public List<String> getTestArgs() {
        if (this.testArgs == null) {
            this.testArgs = new ArrayList<String>();
            if (this.clientRequestArgs.get(ARG_TEST_ARGUMENTS) instanceof ArrayList) {
                this.testArgs.addAll((ArrayList)this.clientRequestArgs.get(ARG_TEST_ARGUMENTS));
            }
        }
        return this.testArgs;
    }

    public Optional<Map<String, String>> getEnv() {
        Object envObject;
        if (this.env == null && (envObject = this.clientRequestArgs.get(ARG_ENV)) instanceof Map) {
            this.env = (Map)envObject;
        }
        return Optional.ofNullable(this.env);
    }
}

