/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation;

import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import java.util.Map;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.BImport;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationImportResolver;
import org.ballerinalang.debugadapter.evaluation.EvaluatorBuilder;
import org.ballerinalang.debugadapter.evaluation.IdentifierModifier;
import org.ballerinalang.debugadapter.evaluation.engine.Evaluator;
import org.ballerinalang.debugadapter.evaluation.validator.SerialExpressionValidator;

public class DebugExpressionEvaluator
extends Evaluator {
    private final EvaluationContext evaluationContext;
    private String expression;

    public DebugExpressionEvaluator(EvaluationContext context) {
        super(context);
        this.evaluationContext = context;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Override
    public BExpressionValue evaluate() throws EvaluationException {
        try {
            SerialExpressionValidator expressionValidator = new SerialExpressionValidator();
            ExpressionNode parsedExpression = expressionValidator.validateAndParse(this.expression);
            EvaluationImportResolver importResolver = new EvaluationImportResolver(this.context);
            Map<String, BImport> resolvedImports = importResolver.getAllImports();
            this.evaluationContext.setResolvedImports(resolvedImports);
            this.evaluationContext.setExpression(this.expression);
            importResolver.detectUsedImports((NonTerminalNode)parsedExpression);
            parsedExpression = (ExpressionNode)parsedExpression.apply((NodeTransformer)new IdentifierModifier());
            EvaluatorBuilder evaluatorBuilder = new EvaluatorBuilder(this.evaluationContext);
            Evaluator evaluator = evaluatorBuilder.build(parsedExpression);
            return evaluator.evaluate();
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw EvaluationException.createEvaluationException("internal error");
        }
    }
}

