/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.tools.text.LinePosition;
import java.util.Optional;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;

public class ClassDefinitionResolver {
    private final SuspendedContext context;

    public ClassDefinitionResolver(SuspendedContext context) {
        this.context = context;
    }

    public Optional<ClassSymbol> findBalClassDefWithinModule(String className) {
        SemanticModel semanticContext = this.context.getDebugCompiler().getSemanticInfo();
        return semanticContext.moduleSymbols().stream().filter(symbol -> symbol.kind() == SymbolKind.CLASS && EvaluationUtils.modifyName(symbol.getName().orElse("")).equals(className)).findFirst().map(symbol -> (ClassSymbol)symbol);
    }

    public Optional<ClassSymbol> findBalClassDefWithinModule(ModuleSymbol moduleSymbol, String className) {
        return moduleSymbol.classes().stream().filter(symbol -> EvaluationUtils.modifyName(symbol.getName().orElse("")).equals(className)).findFirst();
    }

    public Optional<ClassSymbol> findBalClassDefWithinDependencies(String orgName, String packageName, String className) {
        SemanticModel semanticContext = this.context.getDebugCompiler().getSemanticInfo();
        Optional<ModuleSymbol> moduleSymbol = semanticContext.visibleSymbols(this.context.getDocument(), LinePosition.from((int)this.context.getLineNumber(), (int)0)).stream().filter(symbol -> symbol.kind() == SymbolKind.MODULE).map(symbol -> (ModuleSymbol)symbol).filter(symbol -> symbol.id().orgName().equals(orgName) && symbol.id().modulePrefix().equals(packageName)).findAny();
        if (moduleSymbol.isEmpty()) {
            return Optional.empty();
        }
        return moduleSymbol.get().classes().stream().filter(symbol -> ((String)symbol.getName().get()).equals(className)).findAny();
    }
}

