/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine;

import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import java.util.Optional;

public class FunctionNodeFinder
extends NodeVisitor {
    private final String functionName;
    private FunctionDefinitionNode result;

    public FunctionNodeFinder(String functionName) {
        this.functionName = functionName;
    }

    public Optional<FunctionDefinitionNode> searchInModule(Module module) {
        for (DocumentId documentId : module.documentIds()) {
            if (this.result != null) break;
            Optional<FunctionDefinitionNode> result = this.searchInFile(module.document(documentId));
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.ofNullable(this.result);
    }

    public Optional<FunctionDefinitionNode> searchInFile(Document document) {
        document.syntaxTree().rootNode().accept((NodeVisitor)this);
        return Optional.ofNullable(this.result);
    }

    public void visit(FunctionDefinitionNode functionDefinitionNode) {
        if (functionDefinitionNode.functionName().toSourceCode().equals(this.functionName)) {
            this.result = functionDefinitionNode;
        }
    }

    protected void visitSyntaxNode(Node node) {
        if (this.result != null) {
            return;
        }
        if (node instanceof Token) {
            node.accept((NodeVisitor)this);
            return;
        }
        NonTerminalNode nonTerminalNode = (NonTerminalNode)node;
        for (Node child : nonTerminalNode.children()) {
            child.accept((NodeVisitor)this);
        }
    }
}

