/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine;

import com.sun.jdi.Field;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.ArrayTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.UnionTypeDescriptorNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.engine.EvaluationTypeResolver;
import org.ballerinalang.debugadapter.utils.PackageUtils;

public class NodeBasedTypeResolver
extends EvaluationTypeResolver<Node> {
    public NodeBasedTypeResolver(EvaluationContext context) {
        super(context);
    }

    @Override
    public List<Value> resolve(Node typeDescriptor) throws EvaluationException {
        ArrayList<Value> resolvedTypes = new ArrayList<Value>();
        if (typeDescriptor instanceof UnionTypeDescriptorNode) {
            UnionTypeDescriptorNode unionTypeDesc = (UnionTypeDescriptorNode)typeDescriptor;
            resolvedTypes.addAll(this.resolve((Node)unionTypeDesc.leftTypeDesc()));
            resolvedTypes.addAll(this.resolve((Node)unionTypeDesc.rightTypeDesc()));
        } else if (typeDescriptor instanceof ArrayTypeDescriptorNode) {
            ArrayTypeDescriptorNode arrayTypeDesc = (ArrayTypeDescriptorNode)typeDescriptor;
            Value elementType = this.resolveSingleType((Node)arrayTypeDesc.memberTypeDesc());
            resolvedTypes.add(this.createBArrayType(elementType));
        } else {
            resolvedTypes.add(this.resolveSingleType(typeDescriptor));
        }
        return resolvedTypes;
    }

    private Value resolveSingleType(Node type) throws EvaluationException {
        if (type.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            return this.resolveUserDefinedType((SimpleNameReferenceNode)type);
        }
        if (type.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            return this.resolveQualifiedType((QualifiedNameReferenceNode)type);
        }
        Optional<Value> result = this.resolveInbuiltType(type.toSourceCode().trim());
        if (result.isPresent()) {
            return result.get();
        }
        throw EvaluationException.createEvaluationException(EvaluationExceptionKind.TYPE_RESOLVING_ERROR, type.toSourceCode().trim());
    }

    private Value resolveUserDefinedType(SimpleNameReferenceNode node) throws EvaluationException {
        String typeName = node.name().text().trim();
        Optional<Symbol> typeDefinition = this.getModuleTypeDefinitionSymbol(typeName);
        if (typeDefinition.isEmpty()) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.TYPE_RESOLVING_ERROR, typeName);
        }
        String packageInitClass = PackageUtils.getQualifiedClassName(this.context, "$_init");
        List<ReferenceType> classRef = this.context.getAttachedVm().classesByName(packageInitClass);
        if (classRef.isEmpty()) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.TYPE_RESOLVING_ERROR, typeName);
        }
        Field typeField = classRef.get(0).fieldByName("$type$" + typeName);
        if (typeField == null) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.TYPE_RESOLVING_ERROR, typeName);
        }
        return classRef.get(0).getValue(typeField);
    }

    private Value resolveQualifiedType(QualifiedNameReferenceNode qualifiedNameRef) throws EvaluationException {
        String typeName;
        String modulePrefix = qualifiedNameRef.modulePrefix().text().trim();
        Optional<Value> qualifiedType = this.resolveQualifiedType(modulePrefix, typeName = qualifiedNameRef.identifier().text().trim());
        if (qualifiedType.isEmpty()) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.TYPE_RESOLVING_ERROR, qualifiedNameRef.toSourceCode().trim());
        }
        return qualifiedType.get();
    }
}

