/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine.expression;

import com.sun.jdi.Value;
import io.ballerina.compiler.syntax.tree.ErrorConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.engine.Evaluator;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.RuntimeStaticMethod;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;
import org.ballerinalang.debugadapter.evaluation.utils.VMUtils;
import org.ballerinalang.debugadapter.variable.VariableFactory;
import org.ballerinalang.debugadapter.variable.VariableUtils;

public class ErrorConstructorExpressionEvaluator
extends Evaluator {
    private final ErrorConstructorExpressionNode syntaxNode;
    private final List<Map.Entry<String, Evaluator>> argEvaluators;

    public ErrorConstructorExpressionEvaluator(EvaluationContext context, ErrorConstructorExpressionNode expressionNode, List<Map.Entry<String, Evaluator>> argEvaluators) {
        super(context);
        this.syntaxNode = expressionNode;
        this.argEvaluators = argEvaluators;
    }

    @Override
    public BExpressionValue evaluate() throws EvaluationException {
        try {
            if (this.syntaxNode.typeReference().isPresent()) {
                throw EvaluationException.createEvaluationException("Error constructor expressions with type references (e.g. '" + ((TypeDescriptorNode)this.syntaxNode.typeReference().get()).toSourceCode() + "') are not supported by the evaluator.");
            }
            ArrayList<String> argTypeNames = new ArrayList<String>();
            argTypeNames.add("java.lang.Object");
            argTypeNames.add("java.lang.Object");
            argTypeNames.add("java.lang.Object[]");
            RuntimeStaticMethod createErrorValueMethod = EvaluationUtils.getRuntimeMethod(this.context, "org.ballerinalang.debugadapter.runtime.DebuggerRuntime", "createErrorValue", argTypeNames);
            ArrayList<Value> argValues = new ArrayList<Value>();
            if (this.argEvaluators.isEmpty()) {
                throw EvaluationException.createEvaluationException(EvaluationExceptionKind.MISSING_MESSAGE_IN_ERROR, new Object[0]);
            }
            for (int i = 0; i < this.argEvaluators.size(); ++i) {
                if (i == 0) {
                    if (!this.argEvaluators.get(i).getKey().isEmpty()) {
                        throw EvaluationException.createEvaluationException(EvaluationExceptionKind.MISSING_MESSAGE_IN_ERROR.getString());
                    }
                    Value messageValue = this.argEvaluators.get(i).getValue().evaluate().getJdiValue();
                    messageValue = EvaluationUtils.getValueAsObject(this.context, messageValue);
                    argValues.add(messageValue);
                    if (this.argEvaluators.size() != 1) continue;
                    argValues.add(null);
                    continue;
                }
                if (i == 1) {
                    if (this.argEvaluators.get(i).getKey().equals("...")) {
                        throw EvaluationException.createEvaluationException(EvaluationExceptionKind.REST_ARG_IN_ERROR, new Object[0]);
                    }
                    if (!this.argEvaluators.get(i).getKey().isEmpty()) {
                        argValues.add(null);
                        continue;
                    }
                    Value causeValue = this.argEvaluators.get(i).getValue().evaluate().getJdiValue();
                    causeValue = EvaluationUtils.getValueAsObject(this.context, causeValue);
                    argValues.add(causeValue);
                    continue;
                }
                if (this.argEvaluators.get(i).getKey().isEmpty()) {
                    throw EvaluationException.createEvaluationException(EvaluationExceptionKind.ADDITIONAL_ARG_IN_ERROR, new Object[0]);
                }
                if (this.argEvaluators.get(i).getKey().equals("...")) {
                    throw EvaluationException.createEvaluationException(EvaluationExceptionKind.REST_ARG_IN_ERROR.getString());
                }
                argValues.add(VMUtils.make(this.context, this.argEvaluators.get(i).getKey()).getJdiValue());
                Value detailValue = this.argEvaluators.get(i).getValue().evaluate().getJdiValue();
                detailValue = EvaluationUtils.getValueAsObject(this.context, detailValue);
                argValues.add(detailValue);
            }
            createErrorValueMethod.setArgValues(argValues);
            Value returnValue = createErrorValueMethod.invokeSafely();
            this.validateForErrors(returnValue);
            return new BExpressionValue(this.context, returnValue);
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.INTERNAL_ERROR, this.syntaxNode.toSourceCode().trim());
        }
    }

    private void validateForErrors(Value returnValue) throws EvaluationException {
        if (returnValue.type().name().equals("java.lang.String")) {
            String errorMessage = VariableUtils.removeRedundantQuotes(VariableFactory.getVariable(this.context, returnValue).computeValue());
            throw EvaluationException.createEvaluationException(errorMessage);
        }
    }
}

