/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine.expression;

import com.sun.jdi.Value;
import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.JBallerinaBackend;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.internal.model.Target;
import io.ballerina.projects.util.ProjectUtils;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.BImport;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.EvaluationImportResolver;
import org.ballerinalang.debugadapter.evaluation.IdentifierModifier;
import org.ballerinalang.debugadapter.evaluation.engine.Evaluator;
import org.ballerinalang.debugadapter.evaluation.engine.ExternalVariableReferenceFinder;
import org.ballerinalang.debugadapter.evaluation.engine.ModuleLevelDefinitionFinder;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.RuntimeStaticMethod;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;
import org.ballerinalang.debugadapter.evaluation.utils.FileUtils;
import org.ballerinalang.debugadapter.evaluation.utils.VariableUtils;
import org.ballerinalang.debugadapter.variable.BVariable;
import org.ballerinalang.debugadapter.variable.BVariableType;
import org.ballerinalang.debugadapter.variable.VariableFactory;

public class ExpressionAsProgramEvaluator
extends Evaluator {
    private Path tempProjectDir;
    protected final ExpressionNode syntaxNode;
    private final List<String> externalVariableNames = new ArrayList<String>();
    private final List<Value> externalVariableValues = new ArrayList<Value>();
    private final List<BImport> capturedImports = new ArrayList<BImport>();
    private static final String TEMP_DIR_PREFIX = "evaluation-executable-dir-";
    private static final String MAIN_FILE_PREFIX = "main-";
    private static final String EVALUATION_PACKAGE_ORG = "jballerina_debugger";
    private static final String EVALUATION_PACKAGE_NAME = "evaluation_executor";
    private static final String EVALUATION_PACKAGE_VERSION = "1.0.0";
    public static final String EVALUATION_FUNCTION_NAME = "__getEvaluationResult";
    private static final String EVALUATION_IMPORT_TEMPLATE = "import %s/%s as %s;";
    private static final String EVALUATION_FUNCTION_TEMPLATE = "function %s(%s) returns any|error { return %s; }";
    private static final String EVALUATION_SNIPPET_TEMPLATE = String.format("%%s %1$s %%s %1$s %%s", System.lineSeparator());

    public ExpressionAsProgramEvaluator(EvaluationContext evaluationContext, ExpressionNode syntaxNode) {
        super(evaluationContext);
        this.syntaxNode = syntaxNode;
    }

    @Override
    public BExpressionValue evaluate() throws EvaluationException {
        try {
            String evaluationSnippet = this.generateEvaluationSnippet();
            BuildProject project = this.createProject(evaluationSnippet);
            Path executablePath = this.createExecutables(project);
            String mainClassName = this.constructMainClassName(project);
            BExpressionValue bExpressionValue = this.classAndInvokeExecutable(executablePath, mainClassName);
            return bExpressionValue;
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.INTERNAL_ERROR, this.syntaxNode.toSourceCode().trim());
        }
        finally {
            this.dispose();
        }
    }

    private String generateEvaluationSnippet() throws EvaluationException {
        String moduleDeclarations = this.extractModuleDefinitions(this.context.getModule(), false);
        this.processSnippetFunctionParameters();
        StringJoiner parameters = new StringJoiner(",");
        this.externalVariableNames.forEach(parameters::add);
        String functionSnippet = String.format(EVALUATION_FUNCTION_TEMPLATE, EVALUATION_FUNCTION_NAME, parameters, this.evaluationContext.getExpression());
        String importDeclarations = this.generateImportDeclarations(functionSnippet);
        return String.format(EVALUATION_SNIPPET_TEMPLATE, importDeclarations, moduleDeclarations, functionSnippet);
    }

    private BuildProject createProject(String mainBalContent) throws EvaluationException {
        try {
            this.tempProjectDir = Files.createTempDirectory(TEMP_DIR_PREFIX + System.currentTimeMillis(), new FileAttribute[0]);
            this.tempProjectDir.toFile().deleteOnExit();
            this.createMainBalFile(mainBalContent);
            this.createBallerinaToml();
            if (this.containsOtherModuleImports()) {
                this.fillOtherModuleDefinitions();
            }
            BuildOptions buildOptions = BuildOptions.builder().setOffline(Boolean.valueOf(true)).targetDir(ProjectUtils.getTemporaryTargetPath()).build();
            return BuildProject.load((Path)this.tempProjectDir, (BuildOptions)buildOptions);
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw EvaluationException.createEvaluationException(String.format("error occurred while creating the temporary evaluation project due to: %s", e.getMessage()));
        }
    }

    private boolean containsOtherModuleImports() {
        return this.capturedImports.stream().anyMatch(bImport -> this.context.getPackageOrg().isPresent() && bImport.orgName().equals(this.context.getPackageOrg().get()) && bImport.packageName().equals(this.context.getModule().packageInstance().packageName().value()));
    }

    private Path createExecutables(BuildProject project) throws EvaluationException {
        Path executablePath;
        Target target;
        try {
            target = new Target(project.sourceRoot());
        }
        catch (ProjectException | IOException e) {
            throw EvaluationException.createEvaluationException("failed to resolve target path while evaluating expression: " + e.getMessage());
        }
        try {
            executablePath = target.getExecutablePath(project.currentPackage()).toAbsolutePath().normalize();
        }
        catch (IOException e) {
            throw EvaluationException.createEvaluationException("failed to create executables while evaluating expression: " + e.getMessage());
        }
        try {
            PackageCompilation pkgCompilation = project.currentPackage().getCompilation();
            this.validateForCompilationErrors(pkgCompilation);
            JBallerinaBackend jBallerinaBackend = JBallerinaBackend.from((PackageCompilation)pkgCompilation, (JvmTarget)JvmTarget.JAVA_21);
            jBallerinaBackend.emit(JBallerinaBackend.OutputType.EXEC, executablePath);
        }
        catch (ProjectException e) {
            throw EvaluationException.createEvaluationException("failed to create executables while evaluating expression: " + e.getMessage());
        }
        return executablePath;
    }

    private String constructMainClassName(BuildProject project) {
        Optional docId = project.currentPackage().getDefaultModule().documentIds().stream().findFirst();
        Document document = project.currentPackage().getDefaultModule().document((DocumentId)docId.get());
        StringJoiner classNameJoiner = new StringJoiner(".");
        classNameJoiner.add(EVALUATION_PACKAGE_ORG);
        classNameJoiner.add(EVALUATION_PACKAGE_NAME);
        classNameJoiner.add(EVALUATION_PACKAGE_VERSION.split("\\.")[0]);
        classNameJoiner.add(ExpressionAsProgramEvaluator.getFileNameWithoutExtension(document.name()));
        return classNameJoiner.toString();
    }

    private BExpressionValue classAndInvokeExecutable(Path executablePath, String mainClassName) throws EvaluationException {
        ArrayList<String> argTypes = new ArrayList<String>();
        argTypes.add("java.lang.String");
        argTypes.add("java.lang.String");
        argTypes.add("java.lang.String");
        argTypes.add("java.lang.Object[]");
        RuntimeStaticMethod classLoadAndInvokeMethod = EvaluationUtils.getRuntimeMethod(this.context, "org.ballerinalang.debugadapter.runtime.DebuggerRuntime", "classloadAndInvokeFunction", argTypes);
        ArrayList<Value> argList = new ArrayList<Value>();
        argList.add(EvaluationUtils.getAsJString(this.context, executablePath.toAbsolutePath().toString()));
        argList.add(EvaluationUtils.getAsJString(this.context, mainClassName));
        argList.add(EvaluationUtils.getAsJString(this.context, EVALUATION_FUNCTION_NAME));
        argList.addAll(this.externalVariableValues);
        classLoadAndInvokeMethod.setArgValues(argList);
        Value expressionResult = classLoadAndInvokeMethod.invokeSafely();
        return new BExpressionValue(this.context, expressionResult);
    }

    private static String getFileNameWithoutExtension(String fileName) {
        return fileName.endsWith(".bal") ? fileName.replaceAll(".bal$", "") : fileName;
    }

    private void createMainBalFile(String content) throws Exception {
        File mainBalFile = File.createTempFile(MAIN_FILE_PREFIX, ".bal", this.tempProjectDir.toFile());
        mainBalFile.deleteOnExit();
        FileUtils.writeToFile(mainBalFile, content);
    }

    private void createBallerinaToml() throws Exception {
        Path ballerinaTomlPath = this.tempProjectDir.resolve("Ballerina.toml");
        File balTomlFile = Files.createFile(ballerinaTomlPath, new FileAttribute[0]).toFile();
        balTomlFile.deleteOnExit();
        StringJoiner balTomlContent = new StringJoiner(System.lineSeparator());
        balTomlContent.add("[package]");
        balTomlContent.add(String.format("org = \"%s\"", EVALUATION_PACKAGE_ORG));
        balTomlContent.add(String.format("name = \"%s\"", EVALUATION_PACKAGE_NAME));
        balTomlContent.add(String.format("version = \"%s\"", EVALUATION_PACKAGE_VERSION));
        FileUtils.writeToFile(balTomlFile, balTomlContent.toString());
    }

    private String generateImportDeclarations(String functionSnippet) throws EvaluationException {
        ModuleMemberDeclarationNode functionNode = NodeParser.parseModuleMemberDeclaration((String)functionSnippet);
        if (functionNode.kind() != SyntaxKind.FUNCTION_DEFINITION) {
            return null;
        }
        EvaluationImportResolver importResolver = new EvaluationImportResolver(this.context);
        Map<String, BImport> usedImports = importResolver.detectUsedImports((NonTerminalNode)functionNode, this.resolvedImports);
        this.capturedImports.addAll(usedImports.values());
        StringBuilder importBuilder = new StringBuilder(System.lineSeparator());
        for (Map.Entry<String, BImport> importEntry : usedImports.entrySet()) {
            importBuilder.append(this.constructImportStatement(importEntry));
        }
        return importBuilder.append(System.lineSeparator()).toString();
    }

    private String constructImportStatement(Map.Entry<String, BImport> importEntry) {
        String orgName = importEntry.getValue().getResolvedSymbol().id().orgName();
        if (this.context.getPackageOrg().isPresent() && orgName.equals(this.context.getPackageOrg().get())) {
            orgName = EVALUATION_PACKAGE_ORG;
        }
        String moduleName = this.getModuleName(importEntry.getValue().getResolvedSymbol().id());
        String[] moduleNameParts = moduleName.split("\\.");
        if (this.context.getPackageName().isPresent() && moduleNameParts[0].equals(this.context.getPackageName().get())) {
            StringJoiner newModuleName = new StringJoiner(".");
            newModuleName.add(EVALUATION_PACKAGE_NAME);
            int copyOfRangeLength = moduleNameParts.length;
            for (int i = 1; i < copyOfRangeLength; ++i) {
                newModuleName.add(moduleNameParts[i]);
            }
            moduleName = newModuleName.toString();
        }
        String alias = importEntry.getKey();
        return String.format(EVALUATION_IMPORT_TEMPLATE, orgName, moduleName, alias);
    }

    private String getModuleName(ModuleID moduleId) {
        if (moduleId.orgName().equals("ballerina") && moduleId.moduleName().startsWith("lang.")) {
            CharSequence[] moduleNameParts = moduleId.moduleName().split("\\.");
            moduleNameParts = Arrays.copyOfRange(moduleNameParts, 1, moduleNameParts.length);
            return "lang.'" + String.join((CharSequence)".", moduleNameParts);
        }
        return moduleId.moduleName();
    }

    private void fillOtherModuleDefinitions() throws Exception {
        ModuleId currentModuleId = this.context.getModule().moduleId();
        ModuleId defaultModuleId = this.context.getModule().packageInstance().getDefaultModule().moduleId();
        for (Module module : this.context.getModule().packageInstance().modules()) {
            if (module.moduleId() == defaultModuleId || module.moduleId() == currentModuleId) continue;
            this.generateModuleDefinitions(module);
        }
    }

    private void generateModuleDefinitions(Module module) throws Exception {
        String[] moduleNameParts = module.moduleId().moduleName().split("\\.");
        if ((moduleNameParts = Arrays.copyOfRange(moduleNameParts, 1, moduleNameParts.length)).length == 0) {
            return;
        }
        Path filePath = this.tempProjectDir.resolve("modules");
        for (String moduleNamePart : moduleNameParts) {
            filePath = filePath.resolve(moduleNamePart);
        }
        if (!Files.exists(filePath, new LinkOption[0])) {
            Files.createDirectories(filePath, new FileAttribute[0]);
        }
        File moduleMainFile = Files.createTempFile(filePath, MAIN_FILE_PREFIX, ".bal", new FileAttribute[0]).toFile();
        moduleMainFile.deleteOnExit();
        String moduleDefinitions = this.extractModuleDefinitions(module, true);
        FileUtils.writeToFile(moduleMainFile, moduleDefinitions);
    }

    private String extractModuleDefinitions(Module module, boolean includeImports) {
        ModuleLevelDefinitionFinder moduleDefinitionFinder = new ModuleLevelDefinitionFinder(this.context);
        moduleDefinitionFinder.addInclusiveFilter(SyntaxKind.FUNCTION_DEFINITION);
        moduleDefinitionFinder.addInclusiveFilter(SyntaxKind.TYPE_DEFINITION);
        moduleDefinitionFinder.addInclusiveFilter(SyntaxKind.LISTENER_DECLARATION);
        moduleDefinitionFinder.addInclusiveFilter(SyntaxKind.ANNOTATION_DECLARATION);
        moduleDefinitionFinder.addInclusiveFilter(SyntaxKind.MODULE_XML_NAMESPACE_DECLARATION);
        moduleDefinitionFinder.addInclusiveFilter(SyntaxKind.ENUM_DECLARATION);
        moduleDefinitionFinder.addInclusiveFilter(SyntaxKind.CLASS_DEFINITION);
        moduleDefinitionFinder.addInclusiveFilter(SyntaxKind.CONST_DECLARATION);
        moduleDefinitionFinder.addInclusiveFilter(SyntaxKind.MODULE_VAR_DECL);
        if (includeImports) {
            moduleDefinitionFinder.addInclusiveFilter(SyntaxKind.IMPORT_DECLARATION);
        }
        List<NonTerminalNode> declarationList = moduleDefinitionFinder.getModuleDeclarations(module);
        if (includeImports) {
            declarationList = this.convertImports(declarationList);
        }
        return declarationList.stream().map(Node::toSourceCode).reduce((s, s2) -> s + System.lineSeparator() + s2).map(s -> s + System.lineSeparator()).orElse("");
    }

    private List<NonTerminalNode> convertImports(List<NonTerminalNode> declarationList) {
        return declarationList.stream().map(nonTerminalNode -> {
            if (nonTerminalNode.kind() != SyntaxKind.IMPORT_DECLARATION) {
                return nonTerminalNode;
            }
            ImportDeclarationNode importDeclarationNode = (ImportDeclarationNode)nonTerminalNode;
            if (importDeclarationNode.orgName().isPresent() && (this.context.getPackageOrg().isEmpty() || !this.context.getPackageOrg().get().equals(((ImportOrgNameNode)importDeclarationNode.orgName().get()).orgName().text()))) {
                return nonTerminalNode;
            }
            if (this.context.getPackageName().isEmpty() || !this.context.getPackageName().get().equals(((IdentifierToken)importDeclarationNode.moduleName().get(0)).text())) {
                return nonTerminalNode;
            }
            ImportDeclarationNode.ImportDeclarationNodeModifier modifier = importDeclarationNode.modify();
            if (importDeclarationNode.orgName().isPresent()) {
                IdentifierToken orgToken = NodeFactory.createIdentifierToken((String)EVALUATION_PACKAGE_ORG);
                ImportOrgNameNode newOrgName = NodeFactory.createImportOrgNameNode((Token)orgToken, (Token)((ImportOrgNameNode)importDeclarationNode.orgName().get()).slashToken());
                modifier.withOrgName(newOrgName);
            }
            List moduleParts = importDeclarationNode.moduleName().stream().collect(Collectors.toList());
            IdentifierToken packageToken = NodeFactory.createIdentifierToken((String)EVALUATION_PACKAGE_NAME);
            moduleParts.remove(0);
            moduleParts.add(0, packageToken);
            IdentifierToken moduleNameSeparatorToken = NodeFactory.createIdentifierToken((String)".");
            int size = moduleParts.size();
            for (int i = 0; i < size - 1; ++i) {
                moduleParts.add(2 * i + 1, moduleNameSeparatorToken);
            }
            SeparatedNodeList newModuleName = NodeFactory.createSeparatedNodeList(moduleParts);
            modifier = modifier.withModuleName(newModuleName);
            return modifier.apply();
        }).toList();
    }

    private void processSnippetFunctionParameters() throws EvaluationException {
        ArrayList<String> capturedVarNames = new ArrayList<String>(new ExternalVariableReferenceFinder(this.syntaxNode).getCapturedVariables());
        ArrayList<String> capturedTypes = new ArrayList<String>();
        for (String name : capturedVarNames) {
            Optional<BExpressionValue> variableValue = EvaluationUtils.fetchVariableReferenceValue(this.evaluationContext, name);
            if (variableValue.isEmpty()) {
                throw EvaluationException.createEvaluationException(EvaluationExceptionKind.VARIABLE_NOT_FOUND, name);
            }
            BVariable bVar = VariableFactory.getVariable(this.context, variableValue.get().getJdiValue());
            capturedTypes.add(this.getTypeNameString(bVar));
            this.externalVariableValues.add(EvaluationUtils.getValueAsObject(this.context, variableValue.get().getJdiValue()));
        }
        for (int index = 0; index < capturedVarNames.size(); ++index) {
            this.externalVariableNames.add((String)capturedTypes.get(index) + " " + (String)capturedVarNames.get(index));
        }
    }

    private void validateForCompilationErrors(PackageCompilation packageCompilation) throws EvaluationException {
        if (packageCompilation.diagnosticResult().hasErrors()) {
            StringJoiner errors = new StringJoiner(System.lineSeparator());
            errors.add("compilation error(s) found while creating executables for evaluation: ");
            packageCompilation.diagnosticResult().errors().forEach(error -> {
                if (error.diagnosticInfo().severity() == DiagnosticSeverity.ERROR) {
                    errors.add(error.message());
                }
            });
            throw EvaluationException.createEvaluationException(errors.toString());
        }
    }

    private String getTypeNameString(BVariable bVar) {
        return switch (bVar.getBType()) {
            case BVariableType.BOOLEAN, BVariableType.INT, BVariableType.FLOAT, BVariableType.DECIMAL, BVariableType.STRING, BVariableType.XML, BVariableType.TABLE, BVariableType.ERROR, BVariableType.FUNCTION, BVariableType.FUTURE, BVariableType.TYPE_DESC, BVariableType.HANDLE, BVariableType.STREAM, BVariableType.SINGLETON, BVariableType.ANY, BVariableType.ANYDATA, BVariableType.NEVER, BVariableType.BYTE, BVariableType.SERVICE -> bVar.getBType().getString();
            case BVariableType.JSON -> "map<json>";
            case BVariableType.MAP -> VariableUtils.getMapType(this.context, bVar.getJvmValue());
            case BVariableType.NIL -> "()";
            case BVariableType.ARRAY -> bVar.computeValue().substring(0, bVar.computeValue().indexOf("[")) + "[]";
            case BVariableType.TUPLE -> bVar.computeValue();
            case BVariableType.RECORD, BVariableType.OBJECT -> this.resolveObjectType(bVar);
            default -> "unknown";
        };
    }

    private String resolveObjectType(BVariable bVar) {
        Map.Entry<String, String> packageOrgAndName = org.ballerinalang.debugadapter.variable.VariableUtils.getPackageOrgAndName(bVar.getJvmValue());
        if (packageOrgAndName == null) {
            return bVar.computeValue();
        }
        for (Map.Entry entry : this.resolvedImports.entrySet()) {
            String alias = (String)entry.getKey();
            BImport bImport = (BImport)entry.getValue();
            if (!bImport.orgName().equals(packageOrgAndName.getKey()) || !bImport.moduleName().equals(packageOrgAndName.getValue())) continue;
            return alias + ":" + IdentifierModifier.decodeAndEscapeIdentifier(bVar.computeValue());
        }
        return IdentifierModifier.decodeAndEscapeIdentifier(bVar.computeValue());
    }

    private void dispose() {
        FileUtils.deleteDirectory(this.tempProjectDir);
    }
}

