/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine.expression;

import com.sun.jdi.Value;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.OptionalFieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.engine.Evaluator;
import org.ballerinalang.debugadapter.variable.BVariable;
import org.ballerinalang.debugadapter.variable.BVariableType;
import org.ballerinalang.debugadapter.variable.DebugVariableException;
import org.ballerinalang.debugadapter.variable.VariableFactory;
import org.ballerinalang.debugadapter.variable.VariableUtils;
import org.ballerinalang.debugadapter.variable.types.BXmlComment;
import org.ballerinalang.debugadapter.variable.types.BXmlPi;
import org.ballerinalang.debugadapter.variable.types.BXmlSequence;
import org.ballerinalang.debugadapter.variable.types.BXmlText;

public class FieldAccessExpressionEvaluator
extends Evaluator {
    private final ExpressionNode syntaxNode;
    private final Evaluator objectExpressionEvaluator;
    private String expression;
    private String fieldName;
    private static final String FIELD_NAME_ATTRIBUTES = "attributes";

    public FieldAccessExpressionEvaluator(EvaluationContext context, Evaluator expression, ExpressionNode fieldAccessExpressionNode) {
        super(context);
        this.syntaxNode = fieldAccessExpressionNode;
        this.objectExpressionEvaluator = expression;
    }

    @Override
    public BExpressionValue evaluate() throws EvaluationException {
        if (this.syntaxNode.kind() == SyntaxKind.FIELD_ACCESS) {
            this.expression = ((FieldAccessExpressionNode)this.syntaxNode).expression().toSourceCode().trim();
            this.fieldName = ((FieldAccessExpressionNode)this.syntaxNode).fieldName().toSourceCode().trim();
        } else if (this.syntaxNode.kind() == SyntaxKind.OPTIONAL_FIELD_ACCESS) {
            this.expression = ((OptionalFieldAccessExpressionNode)this.syntaxNode).expression().toSourceCode().trim();
            this.fieldName = ((OptionalFieldAccessExpressionNode)this.syntaxNode).fieldName().toSourceCode().trim();
        } else {
            throw EvaluationException.createEvaluationException(String.format("Field access is not supported on type '%s'.", this.syntaxNode.kind().stringValue()));
        }
        try {
            BExpressionValue result = this.objectExpressionEvaluator.evaluate();
            BVariable resultVar = VariableFactory.getVariable(this.context, result.getJdiValue());
            if (resultVar.getBType() != BVariableType.OBJECT && resultVar.getBType() != BVariableType.CLIENT_OBJECT && resultVar.getBType() != BVariableType.SERVICE && resultVar.getBType() != BVariableType.RECORD && resultVar.getBType() != BVariableType.JSON && result.getType() != BVariableType.XML) {
                throw EvaluationException.createEvaluationException(String.format("Field access is not supported on type '%s'.", resultVar.getBType().getString()));
            }
            Value fieldValue = result.getType() == BVariableType.XML ? this.getXmlAttributeValue(resultVar) : VariableUtils.getChildVarByName(resultVar, this.fieldName);
            return new BExpressionValue(this.context, fieldValue);
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (DebugVariableException e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.FIELD_NOT_FOUND, this.fieldName, this.expression);
        }
        catch (Exception e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.INTERNAL_ERROR, this.syntaxNode.toSourceCode().trim());
        }
    }

    private Value getXmlAttributeValue(BVariable variable) throws EvaluationException {
        if (variable instanceof BXmlSequence) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.INVALID_XML_ATTRIBUTE, "xml sequence");
        }
        if (variable instanceof BXmlText) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.INVALID_XML_ATTRIBUTE, "xml text");
        }
        if (variable instanceof BXmlComment) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.INVALID_XML_ATTRIBUTE, "xml comment");
        }
        if (variable instanceof BXmlPi) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.INVALID_XML_ATTRIBUTE, "xml pi");
        }
        try {
            Value attributes = VariableUtils.getChildVarByName(variable, FIELD_NAME_ATTRIBUTES);
            BVariable attributesVar = VariableFactory.getVariable(this.context, attributes);
            return VariableUtils.getChildVarByName(attributesVar, this.fieldName);
        }
        catch (Exception e) {
            throw EvaluationException.createEvaluationException(String.format("Undefined attribute `%s' in: '%s'", this.fieldName, this.expression));
        }
    }
}

