/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine.expression;

import com.sun.jdi.Value;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.identifier.Utils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.BImport;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.IdentifierModifier;
import org.ballerinalang.debugadapter.evaluation.engine.EvaluationTypeResolver;
import org.ballerinalang.debugadapter.evaluation.engine.Evaluator;
import org.ballerinalang.debugadapter.evaluation.engine.SymbolBasedArgProcessor;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.GeneratedStaticMethod;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;

public class FunctionInvocationExpressionEvaluator
extends Evaluator {
    private final FunctionCallExpressionNode syntaxNode;
    private final String functionName;
    private final List<Map.Entry<String, Evaluator>> argEvaluators;

    public FunctionInvocationExpressionEvaluator(EvaluationContext context, FunctionCallExpressionNode node, List<Map.Entry<String, Evaluator>> argEvaluators) {
        super(context);
        this.syntaxNode = node;
        this.argEvaluators = argEvaluators;
        this.functionName = this.syntaxNode.functionName().kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE ? ((QualifiedNameReferenceNode)this.syntaxNode.functionName()).identifier().text().trim() : this.syntaxNode.functionName().toSourceCode().trim();
    }

    @Override
    public BExpressionValue evaluate() throws EvaluationException {
        try {
            FunctionSymbol functionDef = this.resolveFunctionDefinitionSymbol();
            String className = EvaluationUtils.constructQualifiedClassName((Symbol)functionDef);
            GeneratedStaticMethod jvmMethod = EvaluationUtils.getGeneratedMethod(this.context, className, this.functionName);
            SymbolBasedArgProcessor argProcessor = new SymbolBasedArgProcessor(this.context, this.functionName, jvmMethod.getJDIMethodRef(), functionDef);
            List<Value> orderedArgsList = argProcessor.process(this.argEvaluators);
            jvmMethod.setArgValues(orderedArgsList);
            Value result = jvmMethod.invokeSafely();
            return new BExpressionValue(this.context, result);
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.INTERNAL_ERROR, this.syntaxNode.toSourceCode().trim());
        }
    }

    private FunctionSymbol resolveFunctionDefinitionSymbol() throws EvaluationException {
        List<FunctionSymbol> functionMatches;
        Optional<Object> modulePrefix;
        if (this.syntaxNode.functionName().kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            modulePrefix = Optional.of(((QualifiedNameReferenceNode)this.syntaxNode.functionName()).modulePrefix().text());
            if (!this.resolvedImports.containsKey(modulePrefix.get())) {
                throw EvaluationException.createEvaluationException(EvaluationExceptionKind.IMPORT_RESOLVING_ERROR, modulePrefix.get());
            }
            functionMatches = ((BImport)this.resolvedImports.get(modulePrefix.get())).getResolvedSymbol().functions().stream().filter(symbol -> symbol.getName().isPresent() && FunctionInvocationExpressionEvaluator.modifyName((String)symbol.getName().get()).equals(this.functionName)).toList();
            if (functionMatches.size() == 1 && !EvaluationTypeResolver.isPublicSymbol((Symbol)functionMatches.get(0))) {
                throw EvaluationException.createEvaluationException(EvaluationExceptionKind.NON_PUBLIC_OR_UNDEFINED_ACCESS, this.functionName);
            }
        } else {
            modulePrefix = Optional.empty();
            SemanticModel semanticContext = this.context.getDebugCompiler().getSemanticInfo();
            functionMatches = semanticContext.moduleSymbols().stream().filter(symbol -> symbol.kind() == SymbolKind.FUNCTION && symbol.getName().isPresent() && FunctionInvocationExpressionEvaluator.modifyName((String)symbol.getName().get()).equals(this.functionName)).map(symbol -> (FunctionSymbol)symbol).toList();
        }
        if (functionMatches.isEmpty()) {
            if (modulePrefix.isPresent()) {
                throw EvaluationException.createEvaluationException(EvaluationExceptionKind.NON_PUBLIC_OR_UNDEFINED_FUNCTION, this.functionName, modulePrefix.get());
            }
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.FUNCTION_NOT_FOUND, this.syntaxNode.functionName().toSourceCode().trim());
        }
        if (functionMatches.size() > 1) {
            throw EvaluationException.createEvaluationException("Multiple function definitions found with name: '" + this.functionName + "'");
        }
        return functionMatches.get(0);
    }

    public static String modifyName(String identifier) {
        return Utils.decodeIdentifier((String)IdentifierModifier.encodeIdentifier(identifier, IdentifierModifier.IdentifierType.OTHER));
    }
}

