/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine.expression;

import com.sun.jdi.Value;
import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.BImport;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.engine.EvaluationTypeResolver;
import org.ballerinalang.debugadapter.evaluation.engine.Evaluator;
import org.ballerinalang.debugadapter.evaluation.engine.NameBasedTypeResolver;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.RuntimeStaticMethod;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;
import org.ballerinalang.debugadapter.evaluation.utils.VariableUtils;

public class QualifiedNameReferenceEvaluator
extends Evaluator {
    private final String nameReference;
    private final QualifiedNameReferenceNode syntaxNode;

    public QualifiedNameReferenceEvaluator(EvaluationContext context, QualifiedNameReferenceNode node) {
        super(context);
        this.syntaxNode = node;
        this.nameReference = node.identifier().text().trim();
    }

    @Override
    public BExpressionValue evaluate() throws EvaluationException {
        try {
            String modulePrefix = this.syntaxNode.modulePrefix().text();
            if (!this.resolvedImports.containsKey(modulePrefix)) {
                throw EvaluationException.createEvaluationException(EvaluationExceptionKind.IMPORT_RESOLVING_ERROR, modulePrefix);
            }
            ModuleSymbol moduleSymbol = ((BImport)this.resolvedImports.get(modulePrefix)).getResolvedSymbol();
            Optional<BExpressionValue> constant = this.searchForModuleConstant(modulePrefix);
            if (constant.isPresent()) {
                return constant.get();
            }
            Optional<BExpressionValue> moduleVariable = this.searchForModuleVariable(moduleSymbol, modulePrefix);
            if (moduleVariable.isPresent()) {
                return moduleVariable.get();
            }
            NameBasedTypeResolver qualifiedTypeResolver = new NameBasedTypeResolver(this.evaluationContext);
            try {
                List<Value> resolvedTypes = qualifiedTypeResolver.resolve(modulePrefix + ":" + this.nameReference);
                if (resolvedTypes.size() != 1) {
                    throw EvaluationException.createEvaluationException(EvaluationExceptionKind.QUALIFIED_VARIABLE_RESOLVING_FAILED, modulePrefix, this.nameReference);
                }
                Value type = resolvedTypes.get(0);
                LinkedList<String> argTypeNames = new LinkedList<String>();
                argTypeNames.add("io.ballerina.runtime.api.types.Type");
                RuntimeStaticMethod createTypeDescMethod = EvaluationUtils.getRuntimeMethod(this.context, "io.ballerina.runtime.api.creators.ValueCreator", "createTypedescValue", argTypeNames);
                LinkedList<Value> argValues = new LinkedList<Value>();
                argValues.add(type);
                createTypeDescMethod.setArgValues(argValues);
                return new BExpressionValue(this.context, createTypeDescMethod.invokeSafely());
            }
            catch (EvaluationException e) {
                throw EvaluationException.createEvaluationException(EvaluationExceptionKind.QUALIFIED_VARIABLE_RESOLVING_FAILED, modulePrefix, this.nameReference);
            }
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.INTERNAL_ERROR, this.syntaxNode.toSourceCode().trim());
        }
    }

    private Optional<BExpressionValue> searchForModuleConstant(String modulePrefix) throws EvaluationException {
        ModuleSymbol moduleSymbol = ((BImport)this.resolvedImports.get(modulePrefix)).getResolvedSymbol();
        Optional<ConstantSymbol> constSymbol = moduleSymbol.constants().stream().filter(constantSymbol -> constantSymbol.getName().isPresent() && ((String)constantSymbol.getName().get()).equals(this.nameReference)).findAny();
        if (constSymbol.isPresent()) {
            if (!EvaluationTypeResolver.isPublicSymbol((Symbol)constSymbol.get())) {
                throw EvaluationException.createEvaluationException(EvaluationExceptionKind.NON_PUBLIC_OR_UNDEFINED_ACCESS, this.nameReference);
            }
            Optional<BExpressionValue> moduleVariable = VariableUtils.getModuleVariable(this.context, moduleSymbol, this.nameReference);
            if (moduleVariable.isEmpty()) {
                throw EvaluationException.createEvaluationException(EvaluationExceptionKind.QUALIFIED_VARIABLE_RESOLVING_FAILED, modulePrefix, this.nameReference);
            }
            return moduleVariable;
        }
        return Optional.empty();
    }

    private Optional<BExpressionValue> searchForModuleVariable(ModuleSymbol moduleSymbol, String modulePrefix) {
        Optional<VariableSymbol> variableSymbol = moduleSymbol.allSymbols().stream().filter(symbol -> symbol.kind() == SymbolKind.VARIABLE && symbol.getName().isPresent() && ((String)symbol.getName().get()).equals(this.nameReference)).map(symbol -> (VariableSymbol)symbol).findAny();
        if (variableSymbol.isEmpty() || variableSymbol.get().getModule().isEmpty() || !EvaluationTypeResolver.isPublicSymbol((Symbol)variableSymbol.get())) {
            return Optional.empty();
        }
        return VariableUtils.getModuleVariable(this.context, (ModuleSymbol)variableSymbol.get().getModule().get(), this.nameReference);
    }
}

