/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine.expression;

import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import io.ballerina.compiler.syntax.tree.TemplateExpressionNode;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.engine.Evaluator;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;

public class StringTemplateEvaluator
extends Evaluator {
    private final TemplateExpressionNode syntaxNode;
    private final List<Evaluator> templateMemberEvaluators;

    public StringTemplateEvaluator(EvaluationContext context, TemplateExpressionNode templateExpressionNode, List<Evaluator> templateMemberEvaluators) {
        super(context);
        this.syntaxNode = templateExpressionNode;
        this.templateMemberEvaluators = templateMemberEvaluators;
    }

    @Override
    public BExpressionValue evaluate() throws EvaluationException {
        try {
            ArrayList<Value> templateMemberValues = new ArrayList<Value>();
            block6: for (int i = 0; i < this.templateMemberEvaluators.size(); ++i) {
                Evaluator evaluator = this.templateMemberEvaluators.get(i);
                BExpressionValue result = evaluator.evaluate();
                switch (result.getType()) {
                    case INT: 
                    case FLOAT: 
                    case DECIMAL: 
                    case STRING: 
                    case BOOLEAN: {
                        templateMemberValues.add(EvaluationUtils.getStringValue(this.context, result.getJdiValue()));
                        continue block6;
                    }
                    default: {
                        throw EvaluationException.createEvaluationException(EvaluationExceptionKind.TYPE_MISMATCH, "(int|float|decimal|string|boolean)", result.getType().getString(), this.syntaxNode.content().get(i).toSourceCode());
                    }
                }
            }
            Value result = EvaluationUtils.concatBStrings(this.context, templateMemberValues.toArray(new Value[0]));
            if (result instanceof StringReference) {
                StringReference stringReference = (StringReference)result;
                result = EvaluationUtils.getAsBString(this.context, stringReference);
            }
            return new BExpressionValue(this.context, result);
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.INTERNAL_ERROR, this.syntaxNode.toSourceCode().trim());
        }
    }
}

