/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine.expression;

import com.sun.jdi.Value;
import io.ballerina.compiler.syntax.tree.TrapExpressionNode;
import java.util.ArrayList;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.engine.Evaluator;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.GeneratedStaticMethod;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;

public class TrapExpressionEvaluator
extends Evaluator {
    private final TrapExpressionNode syntaxNode;
    private final Evaluator subExprEvaluator;

    public TrapExpressionEvaluator(EvaluationContext context, TrapExpressionNode trapExpressionNode, Evaluator subExprEvaluator) {
        super(context);
        this.syntaxNode = trapExpressionNode;
        this.subExprEvaluator = subExprEvaluator;
    }

    @Override
    public BExpressionValue evaluate() throws EvaluationException {
        try {
            BExpressionValue subExprResult = this.subExprEvaluator.evaluate();
            GeneratedStaticMethod trapResultMethod = EvaluationUtils.getGeneratedMethod(this.context, "ballerina.debugger_helpers.1.utils", "getTrapResult");
            ArrayList<Value> trapResultArgs = new ArrayList<Value>();
            trapResultArgs.add(EvaluationUtils.getValueAsObject(this.context, subExprResult.getJdiValue()));
            trapResultMethod.setArgValues(trapResultArgs);
            return new BExpressionValue(this.context, trapResultMethod.invokeSafely());
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.INTERNAL_ERROR, this.syntaxNode.toSourceCode().trim());
        }
    }
}

