/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine.expression;

import com.sun.jdi.Value;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.UnaryExpressionNode;
import java.util.Collections;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.engine.Evaluator;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.GeneratedStaticMethod;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;

public class UnaryExpressionEvaluator
extends Evaluator {
    private final UnaryExpressionNode syntaxNode;
    private final Evaluator exprEvaluator;

    public UnaryExpressionEvaluator(EvaluationContext context, UnaryExpressionNode unaryExpressionNode, Evaluator subExprEvaluator) {
        super(context);
        this.syntaxNode = unaryExpressionNode;
        this.exprEvaluator = subExprEvaluator;
    }

    @Override
    public BExpressionValue evaluate() throws EvaluationException {
        try {
            BExpressionValue result = this.exprEvaluator.evaluate();
            Value valueAsObject = EvaluationUtils.getValueAsObject(this.context, result.getJdiValue());
            GeneratedStaticMethod genMethod = switch (this.syntaxNode.unaryOperator().kind()) {
                case SyntaxKind.PLUS_TOKEN -> EvaluationUtils.getGeneratedMethod(this.context, "ballerina.debugger_helpers.1.unary_operations", "unaryPlus");
                case SyntaxKind.MINUS_TOKEN -> EvaluationUtils.getGeneratedMethod(this.context, "ballerina.debugger_helpers.1.unary_operations", "unaryMinus");
                case SyntaxKind.NEGATION_TOKEN -> EvaluationUtils.getGeneratedMethod(this.context, "ballerina.debugger_helpers.1.unary_operations", "unaryInvert");
                case SyntaxKind.EXCLAMATION_MARK_TOKEN -> EvaluationUtils.getGeneratedMethod(this.context, "ballerina.debugger_helpers.1.unary_operations", "unaryNot");
                default -> throw EvaluationException.createEvaluationException(EvaluationExceptionKind.INTERNAL_ERROR, this.syntaxNode.toSourceCode().trim());
            };
            genMethod.setArgValues(Collections.singletonList(valueAsObject));
            return new BExpressionValue(this.context, genMethod.invokeSafely());
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.INTERNAL_ERROR, this.syntaxNode.toSourceCode().trim());
        }
    }
}

