/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine.expression;

import com.sun.jdi.Value;
import io.ballerina.compiler.syntax.tree.XMLFilterExpressionNode;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.engine.Evaluator;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.RuntimeStaticMethod;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;
import org.ballerinalang.debugadapter.evaluation.utils.VMUtils;
import org.ballerinalang.debugadapter.variable.BVariableType;

public class XMLFilterExpressionEvaluator
extends Evaluator {
    private final XMLFilterExpressionNode syntaxNode;
    private final Evaluator subExprEvaluator;

    public XMLFilterExpressionEvaluator(EvaluationContext context, XMLFilterExpressionNode filterExpressionNode, Evaluator subExprEvaluator) {
        super(context);
        this.syntaxNode = filterExpressionNode;
        this.subExprEvaluator = subExprEvaluator;
    }

    @Override
    public BExpressionValue evaluate() throws EvaluationException {
        try {
            BExpressionValue subExprResult = this.subExprEvaluator.evaluate();
            if (subExprResult.getType() != BVariableType.XML) {
                throw EvaluationException.createEvaluationException("filter expressions are not supported on type '" + subExprResult.getType().getString() + "'");
            }
            ArrayList<String> argTypeNames = new ArrayList<String>();
            argTypeNames.add("io.ballerina.runtime.api.values.BXml");
            argTypeNames.add("io.ballerina.runtime.api.values.BString[]");
            RuntimeStaticMethod getFilterResultMethod = EvaluationUtils.getRuntimeMethod(this.context, "org.ballerinalang.debugadapter.runtime.DebuggerRuntime", "getXMLFilterResult", argTypeNames);
            ArrayList<Value> argValues = new ArrayList<Value>();
            argValues.add(subExprResult.getJdiValue());
            argValues.addAll(this.getXmlPatternChainAsList());
            getFilterResultMethod.setArgValues(argValues);
            return new BExpressionValue(this.context, getFilterResultMethod.invokeSafely());
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.INTERNAL_ERROR, this.syntaxNode.toSourceCode().trim());
        }
    }

    private List<Value> getXmlPatternChainAsList() {
        ArrayList<Value> result = new ArrayList<Value>();
        this.syntaxNode.xmlPatternChain().xmlNamePattern().stream().forEach(node -> {
            try {
                result.add(VMUtils.make(this.context, node.toSourceCode().trim()).getJdiValue());
            }
            catch (EvaluationException evaluationException) {
                // empty catch block
            }
        });
        return result;
    }
}

