/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine.expression;

import com.sun.jdi.Value;
import io.ballerina.compiler.syntax.tree.XMLStepExpressionNode;
import java.util.ArrayList;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.engine.Evaluator;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.RuntimeStaticMethod;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;
import org.ballerinalang.debugadapter.variable.BVariableType;

public class XMLStepExpressionEvaluator
extends Evaluator {
    private final XMLStepExpressionNode syntaxNode;
    private final Evaluator subExprEvaluator;

    public XMLStepExpressionEvaluator(EvaluationContext context, XMLStepExpressionNode stepExpressionNode, Evaluator subExprEvaluator) {
        super(context);
        this.syntaxNode = stepExpressionNode;
        this.subExprEvaluator = subExprEvaluator;
    }

    @Override
    public BExpressionValue evaluate() throws EvaluationException {
        try {
            BExpressionValue subExprResult = this.subExprEvaluator.evaluate();
            if (subExprResult.getType() != BVariableType.XML) {
                throw EvaluationException.createEvaluationException("step expressions are not supported on type '" + subExprResult.getType().getString() + "'");
            }
            ArrayList<String> argTypeNames = new ArrayList<String>();
            argTypeNames.add("io.ballerina.runtime.api.values.BXml");
            argTypeNames.add("java.lang.String");
            RuntimeStaticMethod getStepResultMethod = EvaluationUtils.getRuntimeMethod(this.context, "org.ballerinalang.debugadapter.runtime.DebuggerRuntime", "getXMLStepResult", argTypeNames);
            ArrayList<Value> argValues = new ArrayList<Value>();
            argValues.add(subExprResult.getJdiValue());
            argValues.add(EvaluationUtils.getAsJString(this.context, this.syntaxNode.xmlStepStart().toSourceCode().trim()));
            getStepResultMethod.setArgValues(argValues);
            return new BExpressionValue(this.context, getStepResultMethod.invokeSafely());
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.INTERNAL_ERROR, this.syntaxNode.toSourceCode().trim());
        }
    }
}

