/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine.expression;

import com.sun.jdi.Value;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.TemplateExpressionNode;
import java.util.Collections;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.engine.Evaluator;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.RuntimeStaticMethod;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;
import org.ballerinalang.debugadapter.variable.BVariable;
import org.ballerinalang.debugadapter.variable.VariableFactory;
import org.ballerinalang.debugadapter.variable.types.BXmlSequence;

public class XMLTemplateExpressionEvaluator
extends Evaluator {
    private final TemplateExpressionNode syntaxNode;

    public XMLTemplateExpressionEvaluator(EvaluationContext context, TemplateExpressionNode templateExpressionNode) {
        super(context);
        this.syntaxNode = templateExpressionNode;
    }

    @Override
    public BExpressionValue evaluate() throws EvaluationException {
        try {
            StringBuilder xmlStrBuilder = new StringBuilder();
            for (Node memberNode : this.syntaxNode.content()) {
                xmlStrBuilder.append(memberNode.toSourceCode());
            }
            Value xmlStrValue = EvaluationUtils.getAsJString(this.context, xmlStrBuilder.toString());
            RuntimeStaticMethod strToXmlMethod = EvaluationUtils.getRuntimeMethod(this.context, "io.ballerina.runtime.internal.TypeConverter", "stringToXml", Collections.singletonList("java.lang.String"));
            strToXmlMethod.setArgValues(Collections.singletonList(xmlStrValue));
            Value result = strToXmlMethod.invokeSafely();
            BVariable xmlVar = VariableFactory.getVariable(this.context, result);
            if (xmlVar instanceof BXmlSequence) {
                BXmlSequence xmlSequence = (BXmlSequence)xmlVar;
                if (xmlSequence.getChildrenCount() == 0) {
                    RuntimeStaticMethod createXmlMethod = EvaluationUtils.getRuntimeMethod(this.context, "io.ballerina.runtime.api.creators.TypeCreator", "createXmlItem", Collections.emptyList());
                    createXmlMethod.setArgValues(Collections.singletonList(xmlStrValue));
                    result = strToXmlMethod.invokeSafely();
                } else if (xmlSequence.getChildrenCount() == 1) {
                    result = xmlSequence.getChildByIndex(0);
                }
            }
            return new BExpressionValue(this.context, result);
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.INTERNAL_ERROR, this.syntaxNode.toSourceCode().trim());
        }
    }
}

