/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine.invokable;

import com.sun.jdi.Method;
import com.sun.jdi.Value;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;
import org.ballerinalang.debugadapter.jdi.JDIUtils;

public abstract class JvmMethod {
    protected final SuspendedContext context;
    protected final Method methodRef;
    protected List<Value> argValues;

    JvmMethod(SuspendedContext context, Method methodRef) {
        this.context = context;
        this.methodRef = methodRef;
        this.argValues = null;
    }

    protected abstract Value invoke() throws EvaluationException;

    public Value invokeSafely() throws EvaluationException {
        JDIUtils.disableJDIRequests(this.context.getExecutionContext());
        Value value = this.invoke();
        JDIUtils.enableJDIRequests(this.context.getExecutionContext());
        return value;
    }

    protected abstract List<Value> getMethodArgs(JvmMethod var1) throws EvaluationException;

    public Method getJDIMethodRef() {
        return this.methodRef;
    }

    public void setArgValues(List<Value> argValues) {
        this.argValues = argValues;
    }

    protected Value extractBErrors(Exception e) throws EvaluationException {
        Optional<Value> potentialBError = EvaluationUtils.getBError(e);
        if (potentialBError.isPresent()) {
            return potentialBError.get();
        }
        throw EvaluationException.createEvaluationException(EvaluationExceptionKind.FUNCTION_EXECUTION_ERROR, this.methodRef.name());
    }
}

