/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.parser;

import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.debugadapter.evaluation.parser.DebugParserException;

public class DebugParser {
    protected Map<String, SyntaxTree> parserCache = new HashMap<String, SyntaxTree>();

    public SyntaxTree getSyntaxTreeFor(String source) throws DebugParserException {
        if (!this.parserCache.containsKey(source)) {
            this.parseAndCache(source);
        }
        return this.parserCache.get(source);
    }

    protected String preprocess(String source) {
        return source;
    }

    private void parseAndCache(String source) throws DebugParserException {
        try {
            String parsableSource = this.preprocess(source);
            TextDocument document = TextDocuments.from((String)parsableSource);
            SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)document);
            this.parserCache.put(source, syntaxTree);
        }
        catch (Exception e) {
            throw new DebugParserException("Failed to parse the user input due to: " + e.getMessage());
        }
    }
}

