/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.utils;

import java.io.File;
import java.io.FileWriter;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;

public final class FileUtils {
    private FileUtils() {
    }

    public static void writeToFile(File file, String content) throws EvaluationException {
        try (FileWriter fileWriter = new FileWriter(file, Charset.defaultCharset());){
            fileWriter.write(content);
        }
        catch (Exception e) {
            throw EvaluationException.createEvaluationException(String.format("error occurred while writing to a temp file at: '%s'", file.getPath()));
        }
    }

    public static boolean deleteDirectory(Path directoryPath) {
        try {
            File[] files;
            File directory = new File(String.valueOf(directoryPath));
            if (directory.isDirectory() && (files = directory.listFiles()) != null) {
                for (File f : files) {
                    boolean success = FileUtils.deleteDirectory(f.toPath());
                    if (success) continue;
                    return false;
                }
            }
            return directory.delete();
        }
        catch (Exception ignored) {
            return false;
        }
    }
}

