/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.utils;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.Project;
import io.ballerina.projects.environment.PackageCache;
import io.ballerina.tools.text.LinePosition;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.IdentifierModifier;
import org.ballerinalang.debugadapter.evaluation.engine.FunctionNodeFinder;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.GeneratedStaticMethod;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;
import org.ballerinalang.debugadapter.variable.BVariableType;

public final class LangLibUtils {
    public static final String LANG_LIB_ORG = "ballerina";
    public static final String LANG_LIB_PACKAGE_PREFIX = "lang.";
    public static final String LANG_LIB_VALUE = "value";

    private LangLibUtils() {
    }

    public static Optional<Package> getLangLibPackage(SuspendedContext context, String langLibName) {
        Project project = context.getProject();
        PackageCache pkgCache = (PackageCache)project.projectEnvironmentContext().environment().getService(PackageCache.class);
        List packages = pkgCache.getPackages(PackageOrg.from((String)LANG_LIB_ORG), PackageName.from((String)(LANG_LIB_PACKAGE_PREFIX + langLibName)));
        if (packages.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((Package)packages.get(0));
    }

    public static GeneratedStaticMethod loadLangLibMethod(SuspendedContext context, BExpressionValue result, String langLibCls, String method) throws EvaluationException {
        try {
            return EvaluationUtils.getGeneratedMethod(context, langLibCls, method);
        }
        catch (EvaluationException e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.LANG_LIB_METHOD_NOT_FOUND, method, result.getType().getString());
        }
    }

    public static String getQualifiedLangLibClassName(Package langLibPackage, String langLibName) throws EvaluationException {
        try {
            return new StringJoiner(".").add(LANG_LIB_ORG).add(IdentifierModifier.encodeModuleName(LANG_LIB_PACKAGE_PREFIX + langLibName)).add(String.valueOf(langLibPackage.packageVersion().value().major())).add(langLibName).toString();
        }
        catch (Exception ignored) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.LANG_LIB_NOT_FOUND, langLibName);
        }
    }

    public static Optional<ModuleSymbol> getLangLibDefinition(SuspendedContext context, String langLibName) {
        SemanticModel semanticContext = context.getDebugCompiler().getSemanticInfo();
        LinePosition position = LinePosition.from((int)context.getLineNumber(), (int)0);
        return semanticContext.visibleSymbols(context.getDocument(), position).stream().filter(symbol -> {
            if (symbol.kind() != SymbolKind.MODULE) {
                return false;
            }
            ModuleID moduleID = ((ModuleSymbol)symbol).id();
            return moduleID.orgName().equals(LANG_LIB_ORG) && moduleID.moduleName().startsWith(LANG_LIB_PACKAGE_PREFIX) && moduleID.moduleName().endsWith(langLibName);
        }).findFirst().map(symbol -> (ModuleSymbol)symbol);
    }

    public static Optional<FunctionDefinitionNode> getLangLibFunctionDefinition(Package langLib, String functionName) {
        FunctionNodeFinder functionFinder = new FunctionNodeFinder(functionName);
        return functionFinder.searchInModule(langLib.getDefaultModule());
    }

    public static String getAssociatedLangLibName(BVariableType bVarType) {
        return switch (bVarType) {
            case BVariableType.INT, BVariableType.BYTE -> BVariableType.INT.getString();
            case BVariableType.ARRAY, BVariableType.TUPLE -> BVariableType.ARRAY.getString();
            case BVariableType.RECORD, BVariableType.MAP -> BVariableType.MAP.getString();
            case BVariableType.FLOAT, BVariableType.DECIMAL, BVariableType.STRING, BVariableType.BOOLEAN, BVariableType.STREAM, BVariableType.OBJECT, BVariableType.ERROR, BVariableType.FUTURE, BVariableType.TYPE_DESC, BVariableType.XML, BVariableType.TABLE -> bVarType.getString();
            default -> LANG_LIB_VALUE;
        };
    }
}

