/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.validator.impl;

import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import java.util.List;
import org.ballerinalang.debugadapter.evaluation.parser.DebugParser;
import org.ballerinalang.debugadapter.evaluation.validator.Validator;

public class TopLevelDeclarationValidator
extends Validator {
    private static final String IMPORT_START = "import ";

    public TopLevelDeclarationValidator(DebugParser parser) {
        super(parser);
    }

    @Override
    public void validate(String source) throws Exception {
        SyntaxTree syntaxTree = this.debugParser.getSyntaxTreeFor(source);
        ModulePartNode moduleNode = (ModulePartNode)syntaxTree.rootNode();
        NodeList imports = moduleNode.imports();
        TopLevelDeclarationValidator.failIf(!imports.isEmpty() && imports.stream().allMatch(importNode -> importNode.toSourceCode().trim().startsWith(IMPORT_START)), "Import declaration evaluation is not supported.");
        NodeList memberNodes = moduleNode.members();
        List<ModuleMemberDeclarationNode> members = memberNodes.stream().filter(node -> node.kind() != SyntaxKind.MODULE_VAR_DECL && !node.hasDiagnostics()).toList();
        TopLevelDeclarationValidator.failIf(!members.isEmpty(), "Top-level declaration evaluation is not supported.");
    }
}

