/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.jdi;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Type;
import org.ballerinalang.debugadapter.jdi.JdiProxy;
import org.ballerinalang.debugadapter.jdi.JdiProxyException;
import org.ballerinalang.debugadapter.jdi.LocalVariableProxy;
import org.ballerinalang.debugadapter.jdi.StackFrameProxyImpl;

public class LocalVariableProxyImpl
extends JdiProxy
implements LocalVariableProxy {
    private final StackFrameProxyImpl myFrame;
    private final String myVariableName;
    private final String myTypeName;
    private LocalVariable myVariable;
    private Type myVariableType;

    public LocalVariableProxyImpl(StackFrameProxyImpl frame, LocalVariable variable) {
        super(frame.myTimer);
        this.myFrame = frame;
        this.myVariableName = variable.name();
        this.myTypeName = variable.typeName();
        this.myVariable = variable;
    }

    @Override
    protected void clearCaches() {
        this.myVariable = null;
        this.myVariableType = null;
    }

    public LocalVariable getVariable() throws JdiProxyException {
        this.checkValid();
        if (this.myVariable == null) {
            this.myVariable = this.myFrame.visibleVariableByNameInt(this.myVariableName);
            if (this.myVariable == null) {
                throw new JdiProxyException(new IncompatibleThreadStateException());
            }
        }
        return this.myVariable;
    }

    public Type getType() throws JdiProxyException, ClassNotLoadedException {
        if (this.myVariableType == null) {
            this.myVariableType = this.getVariable().type();
        }
        return this.myVariableType;
    }

    public StackFrameProxyImpl getFrame() {
        return this.myFrame;
    }

    public int hashCode() {
        return 31 * this.myFrame.hashCode() + this.myVariableName.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof LocalVariableProxyImpl) {
            LocalVariableProxyImpl proxy = (LocalVariableProxyImpl)o;
            return proxy.myFrame.equals(this.myFrame) && this.myVariableName.equals(proxy.myVariableName);
        }
        return false;
    }

    public String name() {
        return this.myVariableName;
    }

    public String typeName() {
        return this.myTypeName;
    }

    public String toString() {
        return this.myVariableName;
    }
}

