/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.launcher;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.ballerinalang.debugadapter.JBallerinaDebugServer;
import org.eclipse.lsp4j.debug.launch.DSPLauncher;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import org.eclipse.lsp4j.debug.services.IDebugProtocolServer;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DebugAdapterLauncher {
    private static final int DEFAULT_PORT = 4711;
    private static final Logger LOGGER = LoggerFactory.getLogger(DebugAdapterLauncher.class);

    private DebugAdapterLauncher() {
    }

    public static void main(String[] args) {
        int debugServerPort = args.length != 0 ? Integer.parseInt(args[0]) : 4711;
        try (ServerSocket serverSocket = new ServerSocket(debugServerPort);){
            PrintStream out = System.out;
            out.println("Debug server started on " + debugServerPort);
            Socket clientSocket = serverSocket.accept();
            DataInputStream inputStream = new DataInputStream(clientSocket.getInputStream());
            DataOutputStream outputStream = new DataOutputStream(clientSocket.getOutputStream());
            JBallerinaDebugServer debugServer = new JBallerinaDebugServer();
            Launcher serverLauncher = DSPLauncher.createServerLauncher((IDebugProtocolServer)debugServer, (InputStream)inputStream, (OutputStream)outputStream);
            IDebugProtocolClient client = (IDebugProtocolClient)serverLauncher.getRemoteProxy();
            debugServer.connect(client);
            serverLauncher.startListening();
        }
        catch (IOException e) {
            LOGGER.error(String.format("Failed to create debug server socket connection with port: %d, due to: %s", debugServerPort, e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

