/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.runner;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.debugadapter.config.ClientConfigurationException;
import org.ballerinalang.debugadapter.config.ClientLaunchConfigHolder;
import org.ballerinalang.debugadapter.utils.OSUtils;

public abstract class BProgramRunner {
    protected final String projectRoot;
    protected final ClientLaunchConfigHolder configHolder;
    private static final String BAL_RUN_CMD = "run";
    private static final String BAL_TEST_CMD = "test";
    private static final String CMD_OPTION_DEBUG = "--debug";
    private static final String CMD_OPTION_TESTS = "--tests";
    protected static final String ENV_JAVA_OPTS = "JAVA_OPTS";
    protected static final String ENV_OPTION_BAL_JAVA_DEBUG = "BAL_JAVA_DEBUG";
    protected static final String ENV_DEBUGGER_TEST_MODE = "BAL_DEBUGGER_TEST";
    protected static final String DEBUGGER_CORE_TEST_FILE = "debugger-core-test.exec";
    protected static final String DEBUGGER_RUNTIME_TEST_FILE = "debugger-runtime-test.exec";

    protected BProgramRunner(ClientLaunchConfigHolder configHolder, String projectRoot) {
        this.configHolder = configHolder;
        this.projectRoot = projectRoot;
    }

    public abstract Process start() throws Exception;

    public ArrayList<String> getBallerinaCommand(String balFile) throws ClientConfigurationException {
        boolean networkLogs;
        List<Object> ballerinaExec = new ArrayList<Object>();
        if (OSUtils.isWindows()) {
            ballerinaExec.add("cmd.exe");
            ballerinaExec.add("/c");
            ballerinaExec.add(this.configHolder.getBallerinaHome() + File.separator + "bin" + File.separator + "bal.bat");
        } else {
            ballerinaExec.add("bash");
            ballerinaExec.add(this.configHolder.getBallerinaHome() + File.separator + "bin" + File.separator + "bal");
        }
        if (this.configHolder.getBallerinaCommand().isPresent()) {
            ballerinaExec = Collections.singletonList(this.configHolder.getBallerinaCommand().get());
        }
        ArrayList<String> command = new ArrayList<String>(ballerinaExec);
        boolean isTestDebugMode = this.configHolder.isTestDebug();
        command.add(isTestDebugMode ? BAL_TEST_CMD : BAL_RUN_CMD);
        command.add(CMD_OPTION_DEBUG);
        command.add(Integer.toString(this.configHolder.getDebuggePort()));
        command.addAll(this.configHolder.getCommandOptions());
        if (isTestDebugMode && !this.configHolder.getTestArgs().isEmpty()) {
            command.add(CMD_OPTION_TESTS);
            command.add(String.join((CharSequence)",", this.configHolder.getTestArgs()));
        }
        if (balFile != null) {
            command.add(balFile);
        }
        if ((networkLogs = this.configHolder.isNetworkLogsEnabled()) && !isTestDebugMode && this.configHolder.getNetworkLogsPort().isPresent()) {
            command.add("--b7a.http.tracelog.host=localhost");
            command.add("--b7a.http.tracelog.port=" + String.valueOf(this.configHolder.getNetworkLogsPort()));
        }
        if (!this.configHolder.getProgramArgs().isEmpty()) {
            command.add("--");
            command.addAll(this.configHolder.getProgramArgs());
        }
        return command;
    }
}

