/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.utils;

import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import java.net.ServerSocket;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.ballerinalang.debugadapter.ExecutionContext;
import org.ballerinalang.debugadapter.breakpoint.BalBreakpoint;
import org.ballerinalang.debugadapter.config.ClientConfigHolder;
import org.ballerinalang.debugadapter.config.ClientLaunchConfigHolder;
import org.eclipse.lsp4j.debug.Source;
import org.eclipse.lsp4j.debug.SourceBreakpoint;
import org.eclipse.lsp4j.jsonrpc.services.GenericEndpoint;

public class ServerUtils {
    private static final String FAST_RUN_NOTIFICATION_NAME = "startFastRun";

    public static boolean isNoDebugMode(ExecutionContext context) {
        try {
            ClientLaunchConfigHolder launchConfHolder;
            ClientConfigHolder confHolder = context.getAdapter().getClientConfigHolder();
            return confHolder instanceof ClientLaunchConfigHolder && (launchConfHolder = (ClientLaunchConfigHolder)confHolder).isNoDebugMode();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isFastRunEnabled(ExecutionContext context) {
        try {
            Optional<ClientConfigHolder.ExtendedClientCapabilities> extendedCapabilities = context.getAdapter().getClientConfigHolder().getExtendedCapabilities();
            return extendedCapabilities.map(ClientConfigHolder.ExtendedClientCapabilities::supportsFastRun).orElse(false);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isBalStrand(ThreadReference threadReference) {
        try {
            return ServerUtils.isBalStackFrame(threadReference.frames().getFirst());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isBalStackFrame(StackFrame frame) {
        try {
            return frame.location().sourceName().endsWith(".bal");
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isValidFrame(org.eclipse.lsp4j.debug.StackFrame stackFrame) {
        return stackFrame != null && stackFrame.getSource() != null && stackFrame.getLine() > 0;
    }

    public static BalBreakpoint toBalBreakpoint(ExecutionContext context, SourceBreakpoint sourceBp, Source source) {
        BalBreakpoint breakpoint = new BalBreakpoint(source, sourceBp.getLine());
        breakpoint.setCondition(sourceBp.getCondition());
        breakpoint.setLogMessage(sourceBp.getLogMessage());
        if (ServerUtils.supportsBreakpointVerification(context)) {
            breakpoint.setSupportsVerification(true);
        }
        return breakpoint;
    }

    public static boolean supportsBreakpointVerification(ExecutionContext context) {
        ClientConfigHolder configHolder = context.getAdapter().getClientConfigHolder();
        return Objects.nonNull(configHolder) && configHolder.getExtendedCapabilities().map(ClientConfigHolder.ExtendedClientCapabilities::supportsBreakpointVerification).orElse(false) != false;
    }

    public static void sendFastRunNotification(ExecutionContext context, int port) {
        GenericEndpoint endPoint = new GenericEndpoint((Object)context.getClient());
        ClientConfigHolder configs = context.getAdapter().getClientConfigHolder();
        Map<String, String> envVarMap = ((ClientLaunchConfigHolder)configs).getEnv().orElse(Map.of());
        String[] programArgs = ((ClientLaunchConfigHolder)configs).getProgramArgs().toArray(new String[0]);
        FastRunArgs args = new FastRunArgs(port, envVarMap, programArgs);
        endPoint.notify(FAST_RUN_NOTIFICATION_NAME, (Object)args);
    }

    public static int findFreePort() {
        int n;
        ServerSocket socket = new ServerSocket(0);
        try {
            socket.setReuseAddress(true);
            n = socket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not find a free TCP/IP port to start debugging", e);
            }
        }
        socket.close();
        return n;
    }

    public record FastRunArgs(int debugPort, Map<String, String> env, String[] programArgs) {
    }
}

