/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.variable.types;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.Field;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.variable.BVariableType;
import org.ballerinalang.debugadapter.variable.IndexedCompoundVariable;
import org.ballerinalang.debugadapter.variable.VariableUtils;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class BArray
extends IndexedCompoundVariable {
    int arraySize = -1;

    public BArray(SuspendedContext context, String name, Value value) {
        super(context, name, BVariableType.ARRAY, value);
    }

    @Override
    public String computeValue() {
        try {
            Value value = this.jvmValue;
            if (!(value instanceof ObjectReference)) {
                return "unknown";
            }
            ObjectReference jvmValueRef = (ObjectReference)value;
            String arrayType = this.getArrayType(jvmValueRef);
            int arraySize = this.getArraySize(jvmValueRef);
            return String.format("%s[%d]", arrayType, arraySize);
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    @Override
    protected Either<Map<String, Value>, List<Value>> computeChildVariables(int start, int count) {
        try {
            Value value = this.jvmValue;
            if (!(value instanceof ObjectReference)) {
                return Either.forRight(new ArrayList());
            }
            ObjectReference jvmValueRef = (ObjectReference)value;
            List<Field> fields = jvmValueRef.referenceType().allFields();
            Field arrayValueField = jvmValueRef.getValues(fields).entrySet().stream().filter(fieldValueEntry -> fieldValueEntry.getValue() != null && ((Field)fieldValueEntry.getKey()).toString().endsWith("Values")).map(Map.Entry::getKey).toList().get(0);
            List<Value> children = count > 0 ? ((ArrayReference)jvmValueRef.getValue(arrayValueField)).getValues(start, count) : ((ArrayReference)jvmValueRef.getValue(arrayValueField)).getValues(0, this.getArraySize(jvmValueRef));
            return Either.forRight(children);
        }
        catch (Exception ignored) {
            return Either.forRight(new ArrayList());
        }
    }

    @Override
    public int getChildrenCount() {
        return this.getArraySize((ObjectReference)this.jvmValue);
    }

    private String getArrayType(ObjectReference arrayRef) {
        Field bTypeField = arrayRef.referenceType().fieldByName("elementType");
        Value bTypeRef = arrayRef.getValue(bTypeField);
        Field typeNameField = ((ObjectReference)bTypeRef).referenceType().fieldByName("typeName");
        Value typeNameRef = ((ObjectReference)bTypeRef).getValue(typeNameField);
        return VariableUtils.getStringFrom(typeNameRef);
    }

    private int getArraySize(ObjectReference arrayRef) {
        if (this.arraySize < 0) {
            this.populateArraySize(arrayRef);
        }
        return this.arraySize;
    }

    private void populateArraySize(ObjectReference arrayRef) {
        List<Field> fields = arrayRef.referenceType().allFields();
        Field arraySizeField = arrayRef.getValues(fields).entrySet().stream().filter(fieldValueEntry -> fieldValueEntry.getValue() != null && ((Field)fieldValueEntry.getKey()).toString().endsWith("ArrayValue.size")).map(Map.Entry::getKey).toList().get(0);
        this.arraySize = ((IntegerValue)arrayRef.getValue(arraySizeField)).value();
    }
}

