/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.variable.types;

import com.sun.jdi.Value;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.variable.BVariableType;
import org.ballerinalang.debugadapter.variable.NamedCompoundVariable;
import org.ballerinalang.debugadapter.variable.VariableUtils;

public class BError
extends NamedCompoundVariable {
    private static final String FIELD_MESSAGE = "message";
    private static final String FIELD_CAUSE = "cause";
    private static final String FIELD_DETAILS = "details";

    public BError(SuspendedContext context, String name, Value value) {
        super(context, name, BVariableType.ERROR, value);
    }

    @Override
    public String computeValue() {
        try {
            Optional<Value> message = VariableUtils.getFieldValue(this.jvmValue, FIELD_MESSAGE);
            return message.isPresent() ? VariableUtils.getStringFrom(message.get()) : "unknown";
        }
        catch (Exception ignored) {
            return "unknown";
        }
    }

    @Override
    public Map<String, Value> computeChildVariables() {
        try {
            LinkedHashMap<String, Value> childVarMap = new LinkedHashMap<String, Value>();
            Optional<Value> message = VariableUtils.getFieldValue(this.jvmValue, FIELD_MESSAGE);
            Optional<Value> cause = VariableUtils.getFieldValue(this.jvmValue, FIELD_CAUSE);
            Optional<Value> details = VariableUtils.getFieldValue(this.jvmValue, FIELD_DETAILS);
            message.ifPresent(value -> childVarMap.put(FIELD_MESSAGE, (Value)value));
            cause.ifPresent(value -> childVarMap.put(FIELD_CAUSE, (Value)value));
            details.ifPresent(value -> childVarMap.put(FIELD_DETAILS, (Value)value));
            return childVarMap;
        }
        catch (Exception ignored) {
            return new HashMap<String, Value>();
        }
    }

    @Override
    public int getChildrenCount() {
        return 3;
    }
}

