/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.variable.types;

import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.Optional;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.variable.BSimpleVariable;
import org.ballerinalang.debugadapter.variable.BVariableType;
import org.ballerinalang.debugadapter.variable.VariableUtils;

public class BInt
extends BSimpleVariable {
    public BInt(SuspendedContext context, String name, Value value) {
        super(context, name, BVariableType.INT, value);
    }

    @Override
    public String computeValue() {
        try {
            Optional<Value> field;
            if (this.jvmValue instanceof IntegerValue || this.jvmValue instanceof LongValue) {
                return this.jvmValue.toString();
            }
            if (this.jvmValue instanceof ObjectReference && (field = VariableUtils.getFieldValue(this.jvmValue, "value")).isPresent()) {
                return field.get().toString();
            }
            return "unknown";
        }
        catch (Exception e) {
            return "unknown";
        }
    }
}

