/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.variable.types;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Method;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.variable.BVariableType;
import org.ballerinalang.debugadapter.variable.IndexedCompoundVariable;
import org.ballerinalang.debugadapter.variable.VariableUtils;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class BMap
extends IndexedCompoundVariable {
    private int mapSize = -1;
    private ArrayReference loadedKeys = null;
    private Value[] loadedValues = null;
    private static final String FIELD_SIZE = "size";
    private static final String METHOD_GET_KEYS = "getKeys";
    private static final String METHOD_GET = "get";

    public BMap(SuspendedContext context, String name, Value value) {
        this(context, name, BVariableType.MAP, value);
    }

    public BMap(SuspendedContext context, String name, BVariableType type, Value value) {
        super(context, name, type, value);
    }

    @Override
    public String computeValue() {
        try {
            return String.format("map (size = %d)", this.getChildrenCount());
        }
        catch (Exception e) {
            return VariableUtils.getBType(this.jvmValue);
        }
    }

    @Override
    public Either<Map<String, Value>, List<Value>> computeChildVariables(int start, int count) {
        LinkedHashMap<String, Value> childVarMap = new LinkedHashMap<String, Value>();
        try {
            Map<Value, Value> mapEntries = count > 0 ? this.getEntries(start, count) : this.getEntries(0, this.getChildrenCount());
            for (Map.Entry<Value, Value> mapEntry : mapEntries.entrySet()) {
                childVarMap.put(VariableUtils.getStringFrom(mapEntry.getKey()), mapEntry.getValue());
            }
            return Either.forLeft(childVarMap);
        }
        catch (Exception ignored) {
            return Either.forLeft(childVarMap);
        }
    }

    @Override
    public int getChildrenCount() {
        if (this.mapSize < 0) {
            this.populateMapSize();
        }
        return this.mapSize;
    }

    private Map<Value, Value> getEntries(int startIndex, int count) {
        if (this.loadedKeys == null) {
            this.loadAllKeys();
        }
        LinkedHashMap<Value, Value> entries = new LinkedHashMap<Value, Value>();
        List<Value> keysRange = this.loadedKeys.getValues(startIndex, count);
        for (int i = startIndex; i < startIndex + count; ++i) {
            Value key = keysRange.get(i - startIndex);
            if (this.loadedValues[i] == null) {
                this.loadedValues[i] = this.getValueFor(key);
            }
            entries.put(key, this.loadedValues[i]);
        }
        return entries;
    }

    private Value getValueFor(Value key) {
        try {
            Optional<Method> getValueMethod = VariableUtils.getMethod(this.jvmValue, METHOD_GET);
            if (getValueMethod.isEmpty()) {
                return null;
            }
            return VariableUtils.invokeRemoteVMMethod(this.context, this.jvmValue, getValueMethod.get(), Collections.singletonList(key));
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private void loadAllKeys() {
        try {
            Optional<Method> entrySetMethod = VariableUtils.getMethod(this.jvmValue, METHOD_GET_KEYS);
            if (entrySetMethod.isEmpty()) {
                return;
            }
            Value keyArray = VariableUtils.invokeRemoteVMMethod(this.context, this.jvmValue, entrySetMethod.get(), null);
            this.loadedKeys = (ArrayReference)keyArray;
            this.loadedValues = new Value[this.getChildrenCount()];
        }
        catch (Exception ignored) {
            this.loadedKeys = null;
            this.loadedValues = new Value[0];
        }
    }

    private void populateMapSize() {
        try {
            Optional<Value> mapSizeValue = VariableUtils.getFieldValue(this.jvmValue, FIELD_SIZE);
            if (mapSizeValue.isEmpty() || !(mapSizeValue.get() instanceof IntegerValue)) {
                this.mapSize = 0;
                return;
            }
            this.mapSize = ((IntegerValue)mapSizeValue.get()).intValue();
        }
        catch (Exception ignored) {
            this.mapSize = 0;
        }
    }
}

