/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.variable.types;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import io.ballerina.identifier.Utils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.variable.BVariableType;
import org.ballerinalang.debugadapter.variable.NamedCompoundVariable;
import org.ballerinalang.debugadapter.variable.VariableUtils;

public class BRecord
extends NamedCompoundVariable {
    private static final String GETKEYS_METHOD_SIGNATURE_PATTERN = ".*Object;$";
    private static final String GET_METHOD_SIGNATURE_PATTERN = "\\(Ljava/lang/Object;\\)Ljava/lang/Object;";
    private static final String METHOD_GET_KEYS = "getKeys";
    private static final String METHOD_GET = "get";
    private ArrayReference loadedKeys = null;

    public BRecord(SuspendedContext context, String name, Value value) {
        super(context, name, BVariableType.RECORD, value);
    }

    @Override
    public String computeValue() {
        try {
            return this.isAnonymous() ? "anonymous" : VariableUtils.getRecordBType(this.jvmValue);
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    @Override
    public Map<String, Value> computeChildVariables() {
        try {
            if (!(this.jvmValue instanceof ObjectReference)) {
                return new LinkedHashMap<String, Value>();
            }
            LinkedHashMap<String, Value> childVarMap = new LinkedHashMap<String, Value>();
            Map<Value, Value> recordFields = this.getRecordFields();
            for (Map.Entry<Value, Value> mapEntry : recordFields.entrySet()) {
                childVarMap.put(Utils.encodeNonFunctionIdentifier((String)Utils.escapeSpecialCharacters((String)VariableUtils.getStringFrom(mapEntry.getKey()))), mapEntry.getValue());
            }
            return childVarMap;
        }
        catch (Exception ignored) {
            return new LinkedHashMap<String, Value>();
        }
    }

    private Map<Value, Value> getRecordFields() {
        try {
            this.loadAllKeys();
            LinkedHashMap<Value, Value> recordFields = new LinkedHashMap<Value, Value>();
            List<Value> keysRange = this.loadedKeys.getValues(0, this.loadedKeys.length());
            for (int i = 0; i < this.loadedKeys.length(); ++i) {
                Value key = keysRange.get(i);
                recordFields.put(key, this.getValueFor(key));
            }
            return recordFields;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private void loadAllKeys() {
        if (this.loadedKeys == null) {
            try {
                Optional<Method> getKeysMethod = VariableUtils.getMethod(this.jvmValue, METHOD_GET_KEYS, GETKEYS_METHOD_SIGNATURE_PATTERN);
                Value keyArray = ((ObjectReference)this.jvmValue).invokeMethod(this.context.getOwningThread().getThreadReference(), getKeysMethod.get(), Collections.emptyList(), 1);
                this.loadedKeys = (ArrayReference)keyArray;
            }
            catch (Exception ignored) {
                this.loadedKeys = null;
            }
        }
    }

    private Value getValueFor(Value key) {
        try {
            Optional<Method> getMethod = VariableUtils.getMethod(this.jvmValue, METHOD_GET, GET_METHOD_SIGNATURE_PATTERN);
            if (getMethod.isEmpty()) {
                return null;
            }
            return ((ObjectReference)this.jvmValue).invokeMethod(this.context.getOwningThread().getThreadReference(), getMethod.get(), Collections.singletonList(key), 1);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @Override
    public int getChildrenCount() {
        try {
            if (!(this.jvmValue instanceof ObjectReference)) {
                return 0;
            }
            this.loadAllKeys();
            return this.loadedKeys == null ? 0 : this.loadedKeys.length();
        }
        catch (Exception ignored) {
            return 0;
        }
    }

    private boolean isAnonymous() {
        String bType = VariableUtils.getBType(this.jvmValue);
        return bType.startsWith("$");
    }
}

