/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.variable.types;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.Value;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.variable.BVariableType;
import org.ballerinalang.debugadapter.variable.NamedCompoundVariable;
import org.ballerinalang.debugadapter.variable.VariableUtils;

public class BXmlItemAttributeMap
extends NamedCompoundVariable {
    private static final String FIELD_MAP_DATA = "table";
    private static final String FIELD_MAP_KEY = "key";
    private static final String FIELD_MAP_VALUE = "value";

    public BXmlItemAttributeMap(SuspendedContext context, String name, Value value) {
        super(context, name, BVariableType.MAP, value);
    }

    @Override
    public String computeValue() {
        return String.format("XMLAttributeMap (size = %d)", this.getChildrenCount());
    }

    @Override
    public Map<String, Value> computeChildVariables() {
        LinkedHashMap<String, Value> childVarMap = new LinkedHashMap<String, Value>();
        try {
            Optional<Value> mapValues = VariableUtils.getFieldValue(this.jvmValue, FIELD_MAP_DATA);
            if (mapValues.isEmpty()) {
                return childVarMap;
            }
            for (Value map : ((ArrayReference)mapValues.get()).getValues()) {
                if (map == null) continue;
                Optional<Value> mapKey = VariableUtils.getFieldValue(map, FIELD_MAP_KEY);
                Optional<Value> mapValue = VariableUtils.getFieldValue(map, FIELD_MAP_VALUE);
                if (!mapKey.isPresent() || !mapValue.isPresent()) continue;
                childVarMap.put(VariableUtils.getStringFrom(mapKey.get()), mapValue.get());
            }
            return childVarMap;
        }
        catch (Exception ignored) {
            return childVarMap;
        }
    }

    @Override
    public int getChildrenCount() {
        try {
            Optional<Value> mapValues = VariableUtils.getFieldValue(this.jvmValue, FIELD_MAP_DATA);
            if (mapValues.isEmpty()) {
                return 0;
            }
            List<Value> attributesMap = ((ArrayReference)mapValues.get()).getValues();
            return attributesMap.size();
        }
        catch (Exception ignored) {
            return 0;
        }
    }
}

